<?php
    if (!defined('ABSPATH')) exit;
?>

<div class="buildecom-admin">
    <div class="wrap">
        <h1 class="wp-heading-inline"><?php esc_html_e('Testimonials', 'buildecom'); ?></h1>

        <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-testimonials&action=add-testimonial')); ?>" class="btn btn-primary btn-sm">
            <?php esc_html_e('Add New', 'buildecom'); ?>
        </a>
    </div>
</div>

<?php

if (isset($_GET['action'], $_GET['id']) && check_admin_referer('buildecom_testimonial_action', '_buildecom_nonce')) {
    global $wpdb;
    $id = intval(wp_unslash($_GET['id']));
    if ('delete' === wp_unslash($_GET['action'])) {
        $wpdb->delete($wpdb->prefix . 'buildecom_testimonials', ['id' => $id]);
        wp_safe_redirect(add_query_arg(['message' => 'Testimonial deleted'], esc_url(admin_url('admin.php?page=buildecom-testimonials'))));
        exit;
    } elseif ('testimonial_toggle_status' === wp_unslash($_GET['action'])) {
        $new_status = intval(wp_unslash($_GET['status']));
        $wpdb->update($wpdb->prefix . 'buildecom_testimonials', ['status' => $new_status], ['id' => $id]);
        wp_safe_redirect(add_query_arg(['message' => 'Status updated'], esc_url(admin_url('admin.php?page=buildecom-testimonials'))));
        exit;
    }
}

?>

<?php
    require_once plugin_dir_path(__FILE__) . 'class-testimonials-table.php';

    $testimonial_list_table = new Buildecom_Testimonials_Table();

    $testimonial_list_table->process_bulk_action();

    $testimonial_list_table->prepare_items();
?>

<div class="buildecom-admin">
    <form method="post">
        <?php $testimonial_list_table->display(); ?>
    </form>
</div>