<?php
if (!defined('ABSPATH')) exit;

global $wpdb;

$testimonial_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$testimonial = $wpdb->get_row(
    $wpdb->prepare(
        "SELECT * FROM {$wpdb->prefix}buildecom_testimonials WHERE id = %d",
        $testimonial_id
    )
);

if (!$testimonial) {
    echo '<div class="notice notice-error"><p>' . esc_html__('Testimonial not found.', 'buildecom') . '</p></div>';
    return;
}

if (
    isset($_POST['submit_testimonial']) &&
    isset($_POST['_wpnonce']) &&
    wp_verify_nonce(wp_unslash($_POST['_wpnonce']), 'buildecom_edit_testimonial')
) {
    check_admin_referer('buildecom_edit_testimonial');

    $full_name     = sanitize_text_field($_POST['full_name']);
    $designation   = sanitize_text_field($_POST['designation']);
    $review        = sanitize_textarea_field($_POST['review']);
    $review_rating = intval($_POST['review_rating']);
    $image         = sanitize_text_field($_POST['image']);

    $wpdb->update(
        $wpdb->prefix . 'buildecom_testimonials',
        [
            'full_name'     => $full_name,
            'designation'   => $designation,
            'review'        => $review,
            'review_rating' => $review_rating,
            'image'         => $image,
        ],
        ['id' => $testimonial_id]
    );

    $redirect_url = add_query_arg([
        'message' => urlencode('Testimonial updated successfully')
    ], esc_url(admin_url('admin.php?page=buildecom-testimonials')));

    wp_safe_redirect($redirect_url);
    exit;
}
?>

<div class="buildecom-admin">
    <div class="wrap">
        <h1 class="wp-heading-inline"><?php esc_html_e('Edit Testimonial', 'buildecom'); ?></h1>

        <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-testimonials')); ?>" class="btn btn-primary btn-sm">
            <?php esc_html_e('Back to List', 'buildecom'); ?>
        </a>
    </div>

    <form method="post" enctype="multipart/form-data">
        <?php wp_nonce_field('buildecom_edit_testimonial'); ?>
        <input type="hidden" name="submit_testimonial" />

        <table class="form-table">
            <tr>
                <th><label for="full_name"><?php echo esc_html__('Full Name', 'buildecom'); ?></label></th>
                <td><input type="text" name="full_name" id="full_name" class="form-control" value="<?php echo esc_attr($testimonial->full_name); ?>" required></td>
            </tr>

            <tr>
                <th><label for="designation"><?php echo esc_html__('Designation', 'buildecom'); ?></label></th>
                <td><input type="text" name="designation" id="designation" class="form-control" value="<?php echo esc_attr($testimonial->designation); ?>" required></td>
            </tr>

            <tr>
                <th><label for="review"><?php echo esc_html__('Review', 'buildecom'); ?></label></th>
                <td><textarea name="review" id="review" class="form-control" rows="4"><?php echo esc_textarea($testimonial->review); ?></textarea></td>
            </tr>

            <tr>
                <th><label for="review_rating"><?php echo esc_html__('Review Rating', 'buildecom'); ?></label></th>
                <td>
                    <select name="review_rating" id="review_rating" class="form-control" required>
                        <?php for ($i = 1; $i <= 5; $i++): ?>
                            <option value="<?php echo esc_html($i); ?>" <?php selected($testimonial->review_rating, $i); ?>>
                                <?php echo esc_html($i); ?>
                            </option>
                        <?php endfor; ?>
                    </select>
                </td>
            </tr>

            <tr>
                <th><label for="image"><?php echo esc_html__('Image', 'buildecom'); ?></label></th>
                <td>
                    <input type="button" class="button" id="upload_image_button" value="<?php echo esc_html__('Upload Image', 'buildecom'); ?>">
                    <input type="hidden" name="image" id="image" value="<?php echo esc_attr($testimonial->image); ?>" />
                    <div id="image_preview" style="margin-top:10px;">
                        <?php if (!empty($testimonial->image)): ?>
                            <img src="<?php echo esc_url($testimonial->image); ?>" style="max-width:150px;" />
                        <?php endif; ?>
                    </div>
                </td>
            </tr>

            <tr>
                <td></td>
                <td>
                    <p class="submit">
                        <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php echo esc_html__('Update Testimonial', 'buildecom'); ?>">
                    </p>
                </td>
            </tr>
        </table>
    </form>
</div>