<?php
if (!defined('ABSPATH')) exit;

if (!class_exists('WP_List_Table')) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

class Buildecom_Testimonials_Table extends WP_List_Table
{
    private $testimonials;

    public function __construct()
    {
        parent::__construct([
            'singular' => 'testimonial',
            'plural'   => 'testimonials',
            'ajax'     => false
        ]);
    }

    public function prepare_items()
    {
        global $wpdb;

        $table_name = $wpdb->prefix . 'buildecom_testimonials';
        $this->testimonials = $wpdb->get_results("SELECT * FROM $table_name", ARRAY_A);
        $columns = $this->get_columns();
        $hidden = [];
        $sortable = [];

        $this->_column_headers = [$columns, $hidden, $sortable];
        $this->items = $this->testimonials;
    }

    public function get_columns()
    {
        return [
            'cb'            => '<input type="checkbox" id="cb-select-all-1" />',
            'full_name'     => 'Full Name',
            'designation'   => 'Designation',
            'review'        => 'Review',
            'review_rating' => 'Review Rating',
            'status'        => 'Status',
            'actions'       => 'Actions'
        ];
    }

    public function column_cb($item)
    {
        return sprintf(
            '<input type="checkbox" name="testimonial[]" value="%s" />',
            $item['id']
        );
    }

    public function column_review($item)
    {
        return buildecom_truncate($item['review'], 50);
    }

    public function column_review_rating($item)
    {
        $rating = intval($item['review_rating']);

        $output = '';

        for ($i = 1; $i <= 5; $i++) {
            if ($i <= $rating) {
                $output .= '<span class="dashicons dashicons-star-filled" style="color: #ffcc00;"></span>';
            } else {
                $output .= '<span class="dashicons dashicons-star-empty" style="color: #ccc;"></span>';
            }
        }

        return $output;
    }

    public function column_status($item)
    {
        return $item['status'] ? '<span class="badge text-bg-success">Enabled</span>' : '<span class="badge text-bg-danger">Disabled</span>';
    }

    public function column_actions($item)
    {
        $edit_url = add_query_arg([
            'page'   => 'buildecom-testimonials',
            'action' => 'edit',
            'id'     => $item['id']
        ], esc_url(admin_url('admin.php')));

        $delete_url = wp_nonce_url(add_query_arg([
            'page'   => 'buildecom-testimonials',
            'action' => 'delete',
            'id'     => $item['id']
        ], esc_url(admin_url('admin.php'))), 'buildecom_testimonial_action', '_buildecom_nonce');

        $toggle_status = $item['status'] ? 0 : 1;
        $status_label = $item['status'] ? __('Disable', 'buildecom') : __('Enable', 'buildecom');

        $toggle_url = wp_nonce_url(add_query_arg([
            'page'   => 'buildecom-testimonials',
            'action' => 'testimonial_toggle_status',
            'id'     => $item['id'],
            'status' => $toggle_status
        ], esc_url(admin_url('admin.php'))), 'buildecom_testimonial_action', '_buildecom_nonce');

        return sprintf(
            '<a href="%s" class="btn btn-primary btn-sm me-1">%s</a>
            <a href="%s" class="btn btn-danger btn-sm me-1" onclick="return confirm(\'Are you sure you want to delete?\')">%s</a>
            <a href="%s" class="btn btn-%s btn-sm">%s</a>',
            esc_url($edit_url),
            esc_html__('Edit', 'buildecom'),
            esc_url($delete_url),
            esc_html__('Delete', 'buildecom'),
            esc_url($toggle_url),
            $item['status'] ? 'warning' : 'success',
            esc_html($status_label)
        );
    }

    public function column_default($item, $column_name)
    {
        return $item[$column_name] ?? '';
    }

    public function get_bulk_actions()
    {
        return [
            'delete-testimonials' => 'Delete'
        ];
    }

    public function process_bulk_action()
    {
        if ('delete-testimonials' == $this->current_action() && !empty($_POST['testimonial'])) {
            global $wpdb;
            $ids = array_map('intval', $_POST['testimonial']);
            $table_name = $wpdb->prefix . 'buildecom_testimonials';

            foreach ($ids as $id) {
                $wpdb->delete($table_name, ['id' => $id], ['%d']);
            }

            $redirect_url = add_query_arg([
                'message' => urlencode('Selected testimonials deleted successfully'),
            ], esc_url(admin_url('admin.php?page=buildecom-testimonials')));

            wp_safe_redirect($redirect_url);
            exit;
        }
    }
}
