<?php
if (!defined('ABSPATH')) exit;

global $wpdb;

if (isset($_POST['submit_testimonial']) && isset($_POST['_wpnonce']) && wp_verify_nonce(wp_unslash($_POST['_wpnonce']), 'buildecom_add_testimonial')) {
    check_admin_referer('buildecom_add_testimonial');

    $full_name     = isset($_POST['full_name']) ? sanitize_text_field($_POST['full_name']) : '';
    $designation   = isset($_POST['designation']) ?  sanitize_text_field($_POST['designation']) : '';
    $review        = isset($_POST['review']) ? sanitize_textarea_field($_POST['review']) : '';
    $review_rating = isset($_POST['review_rating']) ?  intval($_POST['review_rating']) : '';
    $image         = isset($_POST['image']) ?  sanitize_text_field($_POST['image']) : '';

    $wpdb->insert(
        $wpdb->prefix . 'buildecom_testimonials',
        [
            'full_name'     => $full_name,
            'designation'   => $designation,
            'review'        => $review,
            'review_rating' => $review_rating,
            'image'         => $image,
            'status'        => 1,
            'created_at'    => current_time('mysql'),
        ]
    );

    $redirect_url = add_query_arg([
        'message' => urlencode('Testimonial added successfully')
    ], esc_url(admin_url('admin.php?page=buildecom-testimonials')));

    wp_safe_redirect($redirect_url);
    exit;
}
?>

<div class="wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('Add New Testimonial', 'buildecom'); ?></h1>

    <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-testimonials')); ?>" class="btn btn-primary btn-sm">
        <?php esc_html_e('Back to List', 'buildecom'); ?>
    </a>
</div>

<form method="post" enctype="multipart/form-data">
    <?php wp_nonce_field('buildecom_add_testimonial'); ?>
    <input type="hidden" name="submit_testimonial" />

    <table class="form-table">
        <tr>
            <th><label for="full_name"><?php echo esc_html__('Full Name', 'buildecom'); ?></label></th>
            <td><input type="text" name="full_name" id="full_name" class="form-control" required></td>
        </tr>

        <tr>
            <th><label for="designation"><?php echo esc_html__('Designation', 'buildecom'); ?></label></th>
            <td><input type="text" name="designation" id="designation" class="form-control" required></td>
        </tr>

        <tr>
            <th><label for="review"><?php echo esc_html__('Review', 'buildecom'); ?></label></th>
            <td><textarea name="review" id="review" class="form-control" rows="4"></textarea></td>
        </tr>

        <tr>
            <th><label for="review_rating"><?php echo esc_html__('Review Rating', 'buildecom'); ?></label></th>
            <td>
                <select name="review_rating" id="review_rating" class="form-control" required>
                    <?php for ($i = 1; $i <= 5; $i++): ?>
                        <option value="<?php echo esc_html($i); ?>"><?php echo esc_html($i); ?></option>
                    <?php endfor; ?>
                </select>
            </td>
        </tr>

        <tr>
            <th><label for="image"><?php echo esc_html__('Image', 'buildecom'); ?></label></th>
            <td>
                <input type="button" class="button" id="upload_image_button" value="<?php echo esc_html__('Upload Image', 'buildecom'); ?>">
                <input type="hidden" name="image" id="image" value="" />
                <div id="image_preview" style="margin-top:10px;"></div>
            </td>
        </tr>

        <tr>
            <td></td>
            <td>
                <p class="submit">
                    <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php echo esc_html__('Save Testimonial', 'buildecom'); ?>">
                </p>
            </td>
        </tr>
    </table>
</form>