<?php
if (!defined('ABSPATH')) exit;

if (isset($_POST['buildecom_policy_settings_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['buildecom_policy_settings_nonce'])), 'buildecom_save_policy_settings')) {
    $policy_content_raw = filter_input(INPUT_POST, 'buildecom_policy', FILTER_UNSAFE_RAW) ?? '';

    $policy_content = wp_kses_post($policy_content_raw);

    update_option('buildecom_policy', $policy_content);

    $redirect_url = add_query_arg([
        'message'      => urlencode(__('Privacy Policy updated successfully!', 'buildecom')),
        'message_type' => 'success',
        'page'         => sanitize_key('buildecom-setting'),
        'action'       => sanitize_key('privacy-policy')
    ], esc_url(admin_url('admin.php')));

    wp_safe_redirect($redirect_url);
    exit;
} elseif (isset($_POST['buildecom_policy_settings_nonce'])) {
    $redirect_url = add_query_arg([
        'message'      => urlencode(__('Security check failed. Please try again.', 'buildecom')),
        'message_type' => 'error',
        'page'         => sanitize_key('buildecom-setting'),
        'action'       => sanitize_key('privacy-policy')
    ], esc_url(admin_url('admin.php')));

    wp_safe_redirect($redirect_url);
    exit;
}

$policy_content = get_option('buildecom_policy', '');

?>

<div class="buildecom-admin">
    <div class="buildecom-container container">
        <div class="buildecom-form-container">
            <h4 class="mb-0 buildecom-container-title"><?php echo esc_html__('Privacy Policy', 'buildecom') ?></h4>

            <div class="card buildecom-form-card">
                <div class="card-body">
                    <form method="post">
                        <?php wp_nonce_field('buildecom_save_policy_settings', 'buildecom_policy_settings_nonce'); ?>

                        <div class="mb-3">
                            <label for="nic-editor" class="form-label"><?php echo esc_html__('Privacy Policy Content', 'buildecom') ?></label>
                            <textarea
                                id="nic-editor"
                                name="buildecom_policy"
                                class="form-control"
                                rows="10"><?php echo esc_textarea($policy_content); ?></textarea>
                            <small><i class="las la-info-circle"></i> <?php esc_html_e('Edit your site privacy policy content.', 'buildecom'); ?></small>
                        </div>

                        <div class="text-end">
                            <button type="submit" class="btn btn-primary">
                                <i class="las la-save"></i>
                                <?php echo esc_html__('Save Policy', 'buildecom') ?>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>