<?php

if (!defined('ABSPATH')) exit;

/** enqueue the assets requried for the testimonials */
function buildecom_enqueue_settings_assets()
{
    wp_enqueue_style('cbuildecom-admin-setting-style', BUILDECOM_ASSET_PATH . 'css/settings.css', [], BUILDECOM_VERSION);
}

function buildecom_enqueue_nicedit_assets()
{
    wp_enqueue_script('buildecom-admin-nicedit-js', BUILDECOM_ASSET_PATH . 'js/nicEdit.js', [], BUILDECOM_VERSION);
    wp_enqueue_script('buildecom-admin-nicedit-init-js', BUILDECOM_ASSET_PATH . 'js/nic-init.js', ['buildecom-admin-nicedit-js'], BUILDECOM_VERSION);
}


$currentAction = isset($_GET['action']) ? sanitize_text_field(wp_unslash($_GET['action'])) : false;

if (isset($_GET['page']) && $_GET['page'] === 'buildecom-setting') {
    remove_all_actions('admin_notices');
}

add_action('admin_notices', function () {
    if (!empty($_GET['message'])) {
        $type = isset($_GET['message_type']) ? sanitize_key($_GET['message_type']) : 'success';
        $allowed_types = ['success', 'error', 'warning', 'info'];
        if (!in_array($type, $allowed_types)) {
            $type = 'info';
        }

        $message = sanitize_text_field($_GET['message']);
        echo '<div class="notice notice-' . esc_attr($type) . ' is-dismissible"><p>' . esc_html($message) . '</p></div>';
    }
});

?>

<div class="buildecom-admin">
    <ul class="breadcrumb-nav ps-0">

        <li class="<?php echo 'privacy-policy' === $currentAction ? 'active' : '' ?>">
            <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-setting&action=privacy-policy')) ?>">
                <i class="las la-user-shield"></i>
                <span class="menu-title"><?php echo esc_html__('Privacy Policy', 'buildecom') ?></span>
            </a>
        </li>
        <li class="<?php echo 'terms-and-condition' === $currentAction ? 'active' : '' ?>">
            <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-setting&action=terms-and-condition')) ?>">
                <i class="las la-file-alt"></i>
                <span class="menu-title"><?php echo esc_html__('Terms and Conditions', 'buildecom') ?></span>
            </a>
        </li>
        <li class="<?php echo 'about-us' === $currentAction ? 'active' : '' ?>">
            <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-setting&action=about-us')) ?>">
                <i class="las la-users"></i>
                <span class="menu-title"><?php echo esc_html__('About Us', 'buildecom') ?></span>
            </a>
        </li>
    </ul>
</div>

<?php do_action('admin_notices'); ?>