<?php
if (!defined('ABSPATH')) exit;

if (isset($_POST['buildecom_currency_settings_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['buildecom_currency_settings_nonce'])), 'buildecom_save_currency_settings')) {
    $cur_text                     = sanitize_text_field($_POST['buildecom_cur_text']);
    $cur_sym                      = sanitize_text_field($_POST['buildecom_cur_sym']);
    $buildecom_email_verification = isset($_POST['buildecom_email_verification']) ? '1' : '0';

    update_option('buildecom_cur_text', $cur_text);
    update_option('buildecom_cur_sym', $cur_sym);
    update_option('buildecom_email_verification', $buildecom_email_verification);

    $redirect_url = add_query_arg([
        'message' => urlencode(__('Currency settings updated successfully!', 'buildecom')),
        'page'    => sanitize_key('buildecom-setting'),
        // 'action'  => sanitize_key('general')
    ], esc_url(admin_url('admin.php')));

    wp_safe_redirect($redirect_url);
    exit;
} elseif (isset($_POST['buildecom_currency_settings_nonce'])) {
    $redirect_url = add_query_arg([
        'error'  => urlencode(__('Security check failed. Please try again.', 'buildecom')),
        'page'   => sanitize_key('buildecom-setting'),
        'action' => sanitize_key('general')
    ], esc_url(admin_url('admin.php')));

    wp_safe_redirect($redirect_url);
    exit;
}

$cur_text = esc_attr(get_option('buildecom_cur_text'));
$cur_sym  = esc_attr(get_option('buildecom_cur_sym'));
?>

<div class="buildecom-admin">
    <div class="buildecom-container container">
        <div class="buildecom-form-container">
            <h4 class="mb-0 buildecom-container-title"><?php echo esc_html__('General Setting', 'buildecom') ?></h4>

            <div class="card buildecom-form-card">
                <div class="card-body">
                    <form method="post">
                        <?php wp_nonce_field('buildecom_save_currency_settings', 'buildecom_currency_settings_nonce'); ?>

                        <div class="mb-3">
                            <label for="buildecom_cur_text" class="form-label"><?php echo esc_html__('Currency Text', 'buildecom') ?></label>
                            <input
                                type="text"
                                id="buildecom_cur_text"
                                name="buildecom_cur_text"
                                class="form-control"
                                value="<?php echo esc_html($cur_text); ?>"
                                required />
                            <small><i class="las la-info-circle"></i> <?php esc_html_e('Site currency text input field', 'buildecom'); ?></small>

                        </div>

                        <div class="mb-3">
                            <label for="buildecom_cur_sym" class="form-label"><?php echo esc_html__('Currency Symbol', 'buildecom') ?></label>
                            <input
                                type="text"
                                id="buildecom_cur_sym"
                                name="buildecom_cur_sym"
                                class="form-control"
                                value="<?php echo esc_html($cur_sym); ?>"
                                required />
                            <small><i class="las la-info-circle"></i> <?php esc_html_e('Site currency symbol input field', 'buildecom'); ?></small>
                        </div>

                        <ul class="list-group mb-3">
                            <li class="list-group-item border-0 py-3 d-flex flex-wrap flex-sm-nowrap gap-2 justify-content-between align-items-center ps-0">
                                <div>
                                    <label for="buildecom_email_verification" class="fw-bold mb-0 d-block">
                                        <?php esc_html_e('Email Verification', 'buildecom'); ?>
                                    </label>
                                    <p class="mb-0">
                                        <small><?php esc_html_e('If you enable this module, that means a user must have to verify their email address before being able to use the system.', 'buildecom'); ?></small>
                                    </p>
                                </div>
                                <div class="form-group">
                                    <div class="buildecom-custom-checkbox">
                                        <input <?php checked(get_option('buildecom_email_verification'), '1'); ?> type="checkbox" name="buildecom_email_verification" id="buildecom_email_verification" />
                                        <svg viewBox="0 0 35.6 35.6">
                                            <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                            <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                            <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                                        </svg>
                                    </div>
                                </div>
                            </li>
                        </ul>

                        <div class="text-end">
                            <button type="submit" class="btn btn-primary">
                                <i class="las la-save"></i>
                                <?php echo esc_html__('Save Settings', 'buildecom') ?>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>