<?php
if (!defined('ABSPATH')) exit;
?>

<div class="wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('Order Statuses', 'buildecom'); ?></h1>

    <a href="<?php echo esc_url(
        wp_nonce_url(
            admin_url('admin.php?page=buildecom-order-status&action=render-tracking-page'),
            'buildecom_order_status_action' 
        )
    ); ?>" class="btn btn-info btn-sm">
        <?php esc_html_e('Track Order Status', 'buildecom'); ?>
    </a>

    <a href="<?php echo esc_url(
        wp_nonce_url(
            admin_url('admin.php?page=buildecom-order-status&action=add-order-status'),
            'buildecom_order_status_action'
        )
    ); ?>" class="btn btn-primary btn-sm">
        <?php esc_html_e('Add New', 'buildecom'); ?>
    </a>

</div>

<?php
if (
    isset($_GET['action'], $_GET['id'], $_GET['_wpnonce']) &&
    wp_verify_nonce(sanitize_text_field($_GET['_wpnonce']), 'buildecom_order_status_action')
) {
    global $wpdb;
    $id = intval($_GET['id']);
    $action = sanitize_key($_GET['action']);

    if ('delete-order-status' === $action) {
        $wpdb->delete($wpdb->prefix . 'buildecom_order_statuses', ['id' => $id]);
        wp_safe_redirect(add_query_arg(['message' => 'Order status deleted'], admin_url('admin.php?page=buildecom-order-status')));
        exit;
    } elseif ('order-status_toggle_status' === $action && isset($_GET['status'])) {
        $new_status = intval($_GET['status']);
        $wpdb->update($wpdb->prefix . 'buildecom_order_statuses', ['status' => $new_status], ['id' => $id]);
        wp_safe_redirect(add_query_arg(['message' => 'Order status updated'], admin_url('admin.php?page=buildecom-order-status')));
        exit;
    }
}
?>

<?php
require_once plugin_dir_path(__FILE__) . 'class-order-status-table.php';

$buildecom_order_status_table = new Buildecom_Order_Status_Table();

$buildecom_order_status_table->process_bulk_action();

$buildecom_order_status_table->prepare_items();
?>

<form method="post">
    <?php $buildecom_order_status_table->display(); ?>
</form>