<?php

if (!defined('ABSPATH')) exit;

/** Enqueue the assets required for the order-statuses */
function buildecom_enqueue_order_status_assets()
{
    wp_enqueue_script('buildecom-order-status-scripts', BUILDECOM_ASSET_PATH . 'js/order-status.js', ['jquery'], BUILDECOM_VERSION, true);
}

/** Enqueue the assets required for the track-order-status page */
function buildecom_enqueue_track_order_status_assets()
{
    wp_enqueue_script('buildecom-track-order-status-scripts', BUILDECOM_ASSET_PATH . 'js/track-order-status.js', ['jquery'], BUILDECOM_VERSION, true);
}

/** Delete Order Status */
if (
    isset($_GET['action'], $_GET['id'], $_GET['_wpnonce']) &&
    'delete-order-status' === wp_unslash($_GET['action']) &&
    wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'buildecom_order_status_action')
) {
    global $wpdb;
    $order_status_id = intval(wp_unslash($_GET['id']));

    $deleted = $wpdb->delete(
        $wpdb->prefix . 'buildecom_order_statuses',
        ['id' => $order_status_id],
        ['%d']
    );

    $redirect_url = add_query_arg([
        'page'         => 'buildecom-order-status',
        'message'      => urlencode($deleted ? __('Order status deleted successfully', 'buildecom') : __('Order status could not be deleted', 'buildecom')),
        'message_type' => $deleted ? 'success' : 'error',
        '_wpnonce'     => wp_create_nonce('buildecom_admin_notice'),
    ], admin_url('admin.php'));

    wp_safe_redirect($redirect_url);
    exit;
}
