<?php
if (!defined('ABSPATH')) exit;

global $wpdb;

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$table_name = $wpdb->prefix . 'buildecom_order_statuses';

$order_status = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $id));

if (!$order_status) {
    wp_die(esc_html__('Order Status not found.', 'buildecom'));
}

if (isset($_POST['submit_order_status']) && isset($_POST['_wpnonce']) && wp_verify_nonce(wp_unslash($_POST['_wpnonce']), 'buildecom_edit_order_status')) {
    check_admin_referer('buildecom_edit_order_status');

    $status_slug  = sanitize_title($_POST['status_slug']);
    $status_label = sanitize_text_field($_POST['status_label']);
    $status_color = sanitize_hex_color($_POST['status_color']);

    $wpdb->update(
        $table_name,
        [
            'status_slug'  => preg_replace('/\s+/', '-', strtolower($status_label)),
            'status_label' => $status_label,
            'status_color' => $status_color,
            'updated_at'   => current_time('mysql')
        ],
        ['id' => $id]
    );

    $redirect_url = add_query_arg([
        'message'  => urlencode(__('Order Status updated successfully', 'buildecom')),
        '_wpnonce' => wp_create_nonce('buildecom_admin_notice'),
        'page'     => 'buildecom-order-status',
    ], esc_url(admin_url('admin.php')));

    wp_safe_redirect($redirect_url);
    exit;
}

?>

<div class="wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('Edit Order Status', 'buildecom'); ?></h1>

    <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-order-status')); ?>" class="btn btn-primary btn-sm">
        <?php esc_html_e('Back to List', 'buildecom'); ?>
    </a>
</div>

<form method="post">
    <?php wp_nonce_field('buildecom_edit_order_status'); ?>
    <input type="hidden" name="submit_order_status" />

    <table class="form-table">
        <tr>
            <th><label for="status_label"><?php echo esc_html__('Status Label', 'buildecom'); ?></label></th>
            <td><input type="text" name="status_label" id="status_label" class="form-control" value="<?php echo esc_attr($order_status->status_label); ?>" required></td>
        </tr>

        <tr>
            <th><label for="status_color"><?php echo esc_html__('Status Color', 'buildecom'); ?></label></th>
            <td>
                <input type="text" name="status_color" id="status_color" class="form-control" value="<?php echo esc_attr($order_status->status_color); ?>" required>
                <input type="color" id="status_color_picker" value="<?php echo esc_attr($order_status->status_color); ?>" style="margin-top:5px;">
            </td>
        </tr>

        <tr>
            <td></td>
            <td>
                <p class="submit">
                    <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php echo esc_html__('Update Order Status', 'buildecom'); ?>">
                </p>
            </td>
        </tr>
    </table>
</form>