<?php
if (!defined('ABSPATH')) exit;

if (!class_exists('WP_List_Table')) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}


class Buildecom_Order_Status_Table extends WP_List_Table
{
    private $order_statuses;

    public function __construct($args = array())
    {
        parent::__construct([
            'singular' => 'banner_category',
            'plural'   => 'banners_categories',
            'ajax'     => false
        ]);
    }

    public function prepare_items()
    {
        global $wpdb;

        $table_name           = $wpdb->prefix . 'buildecom_order_statuses';
        $this->order_statuses = $wpdb->get_results("SELECT * FROM $table_name", ARRAY_A);
        $columns              = $this->get_columns();
        $hidden               = [];
        $sortable             = [];

        $this->_column_headers = [$columns, $hidden, $sortable];
        $this->items           = $this->order_statuses;
    }

    public function column_default($item, $column_name)
    {
        return $item[$column_name] ?? '';
    }

    public function column_status($item)
    {
        return $item['status'] ? '<span class="badge text-bg-success">Enabled</span>' : '<span class="badge text-bg-danger">Disabled</span>';
    }

    public function get_columns()
    {
        return [
            'cb'           => '<input type="checkbox" id="cb-select-all-1" />',
            'status_label' => 'Label',
            'status_color' => 'Color',
            'status'       => 'Status',
            'actions'      => 'Actions'
        ];
    }

    public function column_status_color($item)
    {
        $color = esc_attr($item['status_color']);
        return sprintf(
            '<div style="width: 30px; height: 30px; background-color: %s; border: 1px solid #ccc; border-radius: 4px;"></div>',
            $color
        );
    }


    public function column_cb($item)
    {
        return sprintf(
            '<input type="checkbox" name="order_status[]" value="%s" />',
            $item['id']
        );
    }

    public function column_actions($item)
    {
        $edit_url = wp_nonce_url(add_query_arg([
            'page'   => 'buildecom-order-status',
            'action' => 'edit-order-status',
            'id'     => $item['id'],
        ], admin_url('admin.php')), 'buildecom_order_status_action');

        $delete_url = wp_nonce_url(add_query_arg([
            'page'   => 'buildecom-order-status',
            'action' => 'delete-order-status',
            'id'     => $item['id'],
        ], admin_url('admin.php')), 'buildecom_order_status_action');

        $toggle_status = $item['status'] ? 0 : 1;
        $status_label  = $item['status'] ? __('Disable', 'buildecom') : __('Enable', 'buildecom');

        $toggle_url = wp_nonce_url(add_query_arg([
            'page'   => 'buildecom-order-status',
            'action' => 'order-status_toggle_status',
            'id'     => $item['id'],
            'status' => $toggle_status,
        ], admin_url('admin.php')), 'buildecom_order_status_action');

        return sprintf(
            '<a href="%s" class="btn btn-primary btn-sm me-1">%s</a>
            <a href="%s" class="btn btn-danger btn-sm me-1" onclick="return confirm(\'Are you sure you want to delete?\')">%s</a>
            <a href="%s" class="btn btn-%s btn-sm">%s</a>',
            esc_url($edit_url),
            esc_html__('Edit', 'buildecom'),
            esc_url($delete_url),
            esc_html__('Delete', 'buildecom'),
            esc_url($toggle_url),
            $item['status'] ? 'warning' : 'success',
            esc_html($status_label)
        );
    }

}
