<?php
if (!defined('ABSPATH')) exit;

if (isset($_POST['submit_order_status'])) {
    global $wpdb;
    
    check_admin_referer('buildecom_add_order_status');

    $status_label = sanitize_text_field($_POST['status_label']);
    $status_color = sanitize_hex_color($_POST['status_color']);

    $wpdb->insert(
        $wpdb->prefix . 'buildecom_order_statuses',
        [
            'status_slug'  => preg_replace('/\s+/', '-', strtolower($status_label)),
            'status_label' => $status_label,
            'status_color' => $status_color,
            'created_at'   => current_time('mysql'),
            'updated_at'   => current_time('mysql')
        ]
    );

    $redirect_url = add_query_arg([
        'message' => urlencode('Order Status added successfully')
    ], esc_url(admin_url('admin.php?page=buildecom-order-status')));

    wp_safe_redirect($redirect_url);
    exit;
}
?>

<div class="wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('Add New Order Status', 'buildecom'); ?></h1>

    <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-order-status')); ?>" class="btn btn-primary btn-sm">
        <?php esc_html_e('Back to List', 'buildecom'); ?>
    </a>
</div>

<form method="post">
    <?php wp_nonce_field('buildecom_add_order_status'); ?>
    <input type="hidden" name="submit_order_status" />

    <table class="form-table"> 
        <tr>
            <th><label for="status_label"><?php echo esc_html__('Status Label', 'buildecom'); ?></label></th>
            <td><input type="text" name="status_label" id="status_label" class="form-control" required></td>
        </tr>

        <tr>
            <th><label for="status_color"><?php echo esc_html__('Status Color', 'buildecom'); ?></label></th>
            <td>
                <input type="text" name="status_color" id="status_color" class="form-control" value="#000000" required />
                <input type="color" id="status_color_picker" value="#000000" style="margin-top:5px;" />
            </td>
        </tr>

        <tr>
            <td></td>
            <td>
                <p class="submit">
                    <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php echo esc_html__('Save Order Status', 'buildecom'); ?>">
                </p>
            </td>
        </tr>
    </table>
</form>