<?php

if (!defined('ABSPATH')) exit;

global $wpdb;
$table_name = $wpdb->prefix . 'buildecom_notification_templates';
$templates = $wpdb->get_results("SELECT id, name, subj FROM $table_name");

?>
<div class="buildecom-admin">
    <div class="buildecom-container container">
        <div class="buildecom-form-container">
            <h4 class="mb-0 buildecom-container-title"><?php echo esc_html__('Notification Templates', 'buildecom') ?></h4>

            <div class="card buildecom-table-card">
                <table class="table align-middle mb-0">
                    <thead>
                        <tr>
                            <th><?php echo esc_html__('#', 'buildecom'); ?></th>
                            <th><?php echo esc_html__('Name', 'buildecom'); ?></th>
                            <th><?php echo esc_html__('Subject', 'buildecom'); ?></th>
                            <th class="text-end"><?php echo esc_html__('Actions', 'buildecom'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($templates)) : ?>
                            <?php foreach ($templates as $index => $template) : ?>
                                <tr>
                                    <td><?php echo esc_html($index + 1); ?></td>
                                    <td><?php echo esc_html($template->name); ?></td>
                                    <td><?php echo esc_html($template->subj); ?></td>
                                    <td class="text-end">
                                        <?php
                                            $edit_url = add_query_arg([
                                                'page' => 'buildecom-notification',
                                                'action' => 'edit-template',
                                                'id' => intval($template->id),
                                                '_wpnonce' => wp_create_nonce('buildecom_notification_action'),
                                            ], admin_url('admin.php'));
                                        ?>
                                        <a href="<?php echo esc_url($edit_url); ?>" class="btn btn-primary btn-sm">
                                            <i class="las la-edit"></i>
                                            <?php echo esc_html__('Edit', 'buildecom'); ?>
                                        </a> 
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="3"><?php echo esc_html__('No templates found.', 'buildecom'); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>