<?php
if (!defined('ABSPATH')) exit;

$notifyConfig = get_option('buildecom_notification_config');
$default = [
    'apiKey'            => '',
    'authDomain'        => '',
    'projectId'         => '',
    'storageBucket'     => '',
    'messagingSenderId' => '',
    'appId'             => '',
    'measurementId'     => '',
];

$fileExists   = file_exists(BUILDECOM_ASSET_PATH . 'push_config.json');
$notifyConfig = wp_parse_args($notifyConfig, $default);
$notifyConfig = buildecom_to_object($notifyConfig);

/** Update the configuration  */
if (isset($_POST['buildecom_notification_settings_nonce']) && wp_verify_nonce(sanitize_key(wp_unslash($_POST['buildecom_notification_settings_nonce'])), 'buildecom_save_notification_settings')) {
    $apiKey            = isset($_POST['api_key']) ? sanitize_text_field(wp_unslash($_POST['api_key'])) : '';
    $authDomain        = isset($_POST['auth_domain']) ? sanitize_text_field(wp_unslash($_POST['auth_domain'])) : '';
    $projectId         = isset($_POST['project_id']) ? sanitize_text_field(wp_unslash($_POST['project_id'])) : '';
    $storageBucket     = isset($_POST['storage_bucket']) ? sanitize_text_field(wp_unslash($_POST['storage_bucket'])) : '';
    $messagingSenderId = isset($_POST['messaging_sender_id']) ? sanitize_text_field(wp_unslash($_POST['messaging_sender_id'])) : '';
    $appId             = isset($_POST['app_id']) ? sanitize_text_field(wp_unslash($_POST['app_id'])) : '';
    $measurementId     = isset($_POST['measurement_id']) ? sanitize_text_field(wp_unslash($_POST['measurement_id'])) : '';

    $notificationData = [
        'apiKey'            => $apiKey,
        'authDomain'        => $authDomain,
        'projectId'         => $projectId,
        'storageBucket'     => $storageBucket,
        'messagingSenderId' => $messagingSenderId,
        'appId'             => $appId,
        'measurementId'     => $measurementId,
    ];

    try {
        update_option('buildecom_notification_config', $notificationData);
    } catch (\Exception $e) {
        $redirect_url = add_query_arg([
            'error'    => urlencode($e->getMessage()),
            'page'     => 'buildecom-notification',
            'action'   => 'notification-config',
            '_wpnonce' => wp_create_nonce('buildecom_notification_action'),
        ], esc_url(admin_url('admin.php')));
        wp_safe_redirect($redirect_url);
        exit;
    }

    $redirect_url = add_query_arg([
        'message'  => urlencode(__('Notification settings updated successfully!', 'buildecom')),
        'action'   => 'notification-config',
        'page'     => 'buildecom-notification',
        '_wpnonce' => wp_create_nonce('buildecom_notification_action')
    ], esc_url(admin_url('admin.php')));

    wp_safe_redirect($redirect_url);
    exit;
}

/** Update|upload the config json file  */
if (
    isset($_POST['buildecom_push_config_nonce']) &&
    wp_verify_nonce(wp_unslash($_POST['buildecom_push_config_nonce']), 'buildecom_upload_push_config')
) {
    if (!empty($_FILES['buildecom_push_config_file']) && $_FILES['buildecom_push_config_file']['error'] === UPLOAD_ERR_OK) {
        $file      = isset($_FILES['buildecom_push_config_file']) ? $_FILES['buildecom_push_config_file'] : null;
        $filename  = $file['name'];
        $tmp_path  = $file['tmp_name'];
        $file_type = mime_content_type($tmp_path);

        $is_json = $file_type === 'application/json' || pathinfo($filename, PATHINFO_EXTENSION) === 'json';

        if ($is_json) {
            $uploaded_file = $_FILES['buildecom_push_config_file'];

            add_filter('wp_check_filetype_and_ext', function ($data, $file, $filename, $mimes) {
                $ext = pathinfo($filename, PATHINFO_EXTENSION);
                if ('json' === strtolower($ext)) {
                    return [
                        'ext'             => 'json',
                        'type'            => 'application/json',
                        'proper_filename' => $filename,
                    ];
                }
                return $data;
            }, 10, 4);

            $upload_overrides = ['test_form' => false];
            $movefile = wp_handle_upload($uploaded_file, $upload_overrides);

            if ($movefile && !isset($movefile['error'])) {
                $destination_path = BUILDECOM_DIR_PATH . 'assets/push_config.json';
                if (copy($movefile['file'], $destination_path)) {
                    unlink($movefile['file']);
                    $redirect_url = add_query_arg([
                        'message'  => urlencode(__('Configuration file uploaded successfully!', 'buildecom')),
                        'page'     => 'buildecom-notification',
                        'action'   => 'notification-config',
                        '_wpnonce' => wp_create_nonce('buildecom_admin_notice')
                    ], esc_url(admin_url('admin.php')));
                } else {
                    $redirect_url = add_query_arg([
                        'message'  => urlencode(__('Failed to move the configuration file to the desired location', 'buildecom')),
                        'action'   => 'notification-config',
                        'page'     => 'buildecom-notification',
                        '_wpnonce' => wp_create_nonce('buildecom_admin_notice'),
                    ], esc_url(admin_url('admin.php')));
                }
            } else {
                $redirect_url = add_query_arg([
                    'message'  => urlencode('Upload failed: ' . esc_html($movefile['error'])),
                    'action'   => 'notification-config',
                    'page'     => 'buildecom-notification',
                    '_wpnonce' => wp_create_nonce('buildecom_admin_notice')
                ], esc_url(admin_url('admin.php')));
            }
        } else {
            $redirect_url = add_query_arg([
                'message'  => urlencode(__('Invalid file type. Please upload a valid .json file.', 'buildecom')),
                'action'   => 'notification-config',
                'page'     => 'buildecom-notification',
                '_wpnonce' => wp_create_nonce('buildecom_admin_notice')
            ], esc_url(admin_url('admin.php')));
        }

        wp_safe_redirect($redirect_url);
        exit;
    }
}

?>

<div class="buildecom-admin">
    <div class="buildecom-container container">
        <div class="buildecom-form-container">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="mb-0 buildecom-container-title"><?php echo esc_html__('Push Notification Setting', 'buildecom') ?></h4>
                <div class="d-flex gap-3">
                    <button class="btn btn-success" id="show-help-modal-btn">
                        <i class="las la-question-circle"></i>
                        <?php echo esc_html__('Help', 'buildecom') ?>
                    </button>
                    <button class="btn btn-primary" id="upload-config-file-btn">
                        <i class="las la-file-upload"></i>
                        <?php echo esc_html__('Upload Config File', 'buildecom') ?>
                    </button>

                    <?php
                    $push_config_path     = BUILDECOM_ASSET_PATH . 'push_config.json';
                    $push_config_realpath = str_replace(site_url('/'), ABSPATH, $push_config_path);

                    if (file_exists($push_config_realpath)) : ?>
                        <a href="<?php echo esc_url($push_config_path); ?>" class="btn btn-info" download>
                            <i class="las la-file-download"></i>
                            <?php echo esc_html__('Download File', 'buildecom'); ?>
                        </a>
                    <?php endif; ?>

                </div>
            </div>

            <div class="card buildecom-form-card">
                <div class="card-body">
                    <form method="post">
                        <?php wp_nonce_field('buildecom_save_notification_settings', 'buildecom_notification_settings_nonce'); ?>

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="api_key" class="form-label"><?php esc_html_e('API Key', 'buildecom'); ?></label>
                                <input type="text" id="api_key" name="api_key" class="form-control" value="<?php echo esc_attr($notifyConfig->apiKey); ?>" required />
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="auth_domain" class="form-label"><?php esc_html_e('Auth Domain', 'buildecom'); ?></label>
                                <input type="text" id="auth_domain" name="auth_domain" class="form-control" value="<?php echo esc_attr($notifyConfig->authDomain); ?>" required />
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="project_id" class="form-label"><?php esc_html_e('Project ID', 'buildecom'); ?></label>
                                <input type="text" id="project_id" name="project_id" class="form-control" value="<?php echo esc_attr($notifyConfig->projectId); ?>" required />
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="storage_bucket" class="form-label"><?php esc_html_e('Storage Bucket', 'buildecom'); ?></label>
                                <input type="text" id="storage_bucket" name="storage_bucket" class="form-control" value="<?php echo esc_attr($notifyConfig->storageBucket); ?>" required />
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="messaging_sender_id" class="form-label"><?php esc_html_e('Messaging Sender ID', 'buildecom'); ?></label>
                                <input type="text" id="messaging_sender_id" name="messaging_sender_id" class="form-control" value="<?php echo esc_attr($notifyConfig->messagingSenderId); ?>" required />
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="app_id" class="form-label"><?php esc_html_e('App ID', 'buildecom'); ?></label>
                                <input type="text" id="app_id" name="app_id" class="form-control" value="<?php echo esc_attr($notifyConfig->appId); ?>" required />
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="measurement_id" class="form-label"><?php esc_html_e('Measurement ID', 'buildecom'); ?></label>
                                <input type="text" id="measurement_id" name="measurement_id" class="form-control" value="<?php echo esc_attr($notifyConfig->measurementId); ?>" required />
                            </div>
                        </div>

                        <div class="text-end">
                            <button type="submit" class="btn btn-primary">
                                <i class="las la-save"></i>
                                <?php echo esc_html__('Save Notification Config', 'buildecom') ?>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- help modal -->
<div class="modal fade" id="firebaseHelpModal" tabindex="-1" aria-labelledby="firebaseHelpModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="firebaseHelpModalLabel"><?php echo esc_html__('Firebase setup help', 'buildecom') ?></h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="steps-tab" data-bs-toggle="tab" data-bs-target="#steps" type="button" role="tab" aria-controls="steps" aria-selected="true">Steps</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="configs-tab" data-bs-toggle="tab" data-bs-target="#configs" type="button" role="tab" aria-controls="configs" aria-selected="false">Configs</button>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade active show" id="steps" role="tabpanel" aria-labelledby="steps-tab">
                        <div class="table-responsive overflow-hidden">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th><?php echo esc_html__('To Do', 'buildecom')  ?></th>
                                        <th><?php echo esc_html__('Description', 'buildecom') ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><?php echo esc_html__('Step 1', 'buildecom') ?></td>
                                        <td><?php echo esc_html__('Go to your Firebase account and select', 'buildecom') ?> <span class="text--primary">"<?php echo esc_html__('Go to console', 'buildecom') ?></span>" <?php echo esc_html__('in the upper-right corner of the page.', 'buildecom') ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo esc_html__('Step 2', 'buildecom') ?></td>
                                        <td><?php echo esc_html__('Click on the', 'buildecom') ?> <span class="text--primary">"<?php echo esc_html__('Add Project', 'buildecom') ?></span>" <?php echo esc_html__('button', 'buildecom') ?>.</td>
                                    </tr>
                                    <tr>
                                        <td><?php echo esc_html__('Step 3', 'buildecom') ?></td>
                                        <td><?php echo esc_html__('Enter the project name and click on the', 'buildecom') ?> <span class="text--primary">"<?php echo esc_html__('Continue', 'buildecom') ?></span>" <?php echo esc_html__('button.', 'buildecom') ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo esc_html__('Step 4', 'buildecom') ?></td>
                                        <td><?php echo esc_html__('Enable Google Analytics and click on the', 'buildecom') ?> <span class="text--primary">"<?php echo esc_html__('Continue', 'buildecom') ?></span>" <?php echo esc_html__('button.', 'buildecom') ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo esc_html__('Step 5', 'buildecom') ?></td>
                                        <td><?php echo esc_html__('Choose the default account for the Google Analytics account and click on the', 'buildecom') ?> <span class="text--primary">"<?php echo esc_html__('Create Project', 'buildecom') ?></span>" <?php echo esc_html__('button.', 'buildecom') ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo esc_html__('Step 6', 'buildecom') ?></td>
                                        <td><?php echo esc_html__('Within your Firebase project, select the gear next to Project Overview and choose Project settings.', 'buildecom') ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo esc_html__('Step 7', 'buildecom') ?></td>
                                        <td><?php echo esc_html__('Next, set up a web app under the General section of your project settings.', 'buildecom') ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo esc_html__('Step 8', 'buildecom') ?></td>
                                        <td><?php echo esc_html__('Go to the Service accounts tab and generate a new private key.', 'buildecom') ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo esc_html__('Step 9', 'buildecom') ?></td>
                                        <td><?php echo esc_html__('A JSON file will be downloaded. Upload the downloaded file here.', 'buildecom') ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade mt-3 ms-2 text-center" id="configs" role="tabpanel" aria-labelledby="configs-tab">
                        <img src="<?php echo esc_url(BUILDECOM_ASSET_PATH . 'images/configs.png') ?>" alt="<?php echo esc_attr__('Firebase Config', 'buildecom') ?>">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo esc_html__('Close', 'buildecom') ?></button>
            </div>
        </div>
    </div>
</div>

<!-- file uploader modal -->
<div class="modal fade" id="fileUploaderModal" tabindex="-1" aria-labelledby="fileUploaderModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form method="post" enctype="multipart/form-data">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="fileUploaderModalLabel"><?php echo esc_html__('Upload Push Configuration File', 'buildecom'); ?></h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo esc_attr__('Close', 'buildecom'); ?>"></button>
                </div>
                <div class="modal-body">
                    <?php wp_nonce_field('buildecom_upload_push_config', 'buildecom_push_config_nonce'); ?>
                    <div class="mb-3">
                        <input type="file" name="buildecom_push_config_file" id="buildecom_push_config_file" accept=".json" class="form-control" required />
                        <small class="text-muted"><?php echo esc_html__('Only .json files are allowed.', 'buildecom'); ?></small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo esc_html__('Close', 'buildecom'); ?></button>
                    <button type="submit" class="btn btn-primary">
                        <i class="las la-upload"></i> <?php echo esc_html__('Upload File', 'buildecom'); ?>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>