<?php

if (!defined('ABSPATH')) exit;

/** enqueue the assets requried for the testimonials */
function buildecom_enqueue_notification_assets()
{
    wp_enqueue_script('buildecom-admin-notification-js', BUILDECOM_ASSET_PATH . 'js/notification.js', ['jquery'], BUILDECOM_VERSION);
    wp_enqueue_style('cbuildecom-admin-setting-style', BUILDECOM_ASSET_PATH . 'css/settings.css', [], BUILDECOM_VERSION);
}

function buildecom_enqueue_notification_config_assets()
{
    wp_enqueue_script('buildecom-admin-notification-config-js', BUILDECOM_ASSET_PATH . 'js/notification-config.js', ['jquery'], BUILDECOM_VERSION);
}


$currentAction = isset($_GET['action']) ? sanitize_text_field(wp_unslash($_GET['action'])) : false;

if (isset($_GET['page']) && 'buildecom-notification' === $_GET['page']) {
    remove_all_actions('admin_notices');
}

add_action('admin_notices', function () {
    if (!empty($_GET['message'])) {
        $type = isset($_GET['message_type']) ? sanitize_key($_GET['message_type']) : 'success';
        $allowed_types = ['success', 'error', 'warning', 'info'];
        if (!in_array($type, $allowed_types)) {
            $type = 'info';
        }

        $message = sanitize_text_field($_GET['message']);
        echo '<div class="notice notice-' . esc_attr($type) . ' is-dismissible"><p>' . esc_html($message) . '</p></div>';
    }
});

?>

<div class="buildecom-admin">
    <ul class="breadcrumb-nav ps-0">
        <li class="<?php echo !$currentAction ? 'active' : '' ?>">
            <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-notification')) ?>">
                <i class="las la-globe"></i>
                <span class="menu-title"><?php echo esc_html__('Notification Templates', 'buildecom') ?></span>
            </a>
        </li>
        <li class="<?php echo 'notification-config' === $currentAction ? 'active' : '' ?>">

            <a href="<?php echo esc_url(wp_nonce_url(add_query_arg([
                            'page'   => 'buildecom-notification',
                            'action' => 'notification-config',
                        ], 'admin.php'), 'buildecom_notification_action')) ?>">
                <i class="las la-cog"></i>
                <span class="menu-title"><?php echo esc_html__('Configuration', 'buildecom') ?></span>
            </a>
        </li>
    </ul>
</div>

<?php do_action('admin_notices'); ?>