<?php
if (!defined('ABSPATH')) exit;

global $wpdb;
$table_name = $wpdb->prefix . 'buildecom_notification_templates';

$template_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$template = $wpdb->get_row(
    $wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $template_id)
);

if (!$template) {
    echo '<div class="notice notice-error"><p>' . esc_html__('Template not found.', 'buildecom') . '</p></div>';
    return;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['buildecom_edit_template_nonce']) || !wp_verify_nonce($_POST['buildecom_edit_template_nonce'], 'buildecom_save_template')) {
        wp_die(__('Security check failed. Please try again.', 'buildecom'));
    }

    $name          = isset($_POST['name']) ?  sanitize_text_field(wp_unslash($_POST['name'])) : '';
    $subject       = isset($_POST['subject']) ?  sanitize_text_field(wp_unslash($_POST['subject'])) : '';
    $firebase_body = isset($_POST['firebase_body']) ? sanitize_text_field($_POST['firebase_body']) : '';

    $updated = $wpdb->update(
        $table_name,
        [
            'name'          => $name,
            'subj'          => $subject,
            'firebase_body' => $firebase_body,
        ],
        ['id' => $template_id],
        ['%s', '%s', '%s'],
        ['%d']
    );

    if (false !== $updated) {
        $redirect_url = add_query_arg([
            'page'         => 'buildecom-notification',
            'message'      => urlencode(__('Template updated successfully.', 'buildecom')),
            'message_type' => 'success',
            '_wpnonce'     => wp_create_nonce('buildecom_admin_notice')
        ], esc_url(admin_url('admin.php')));

        wp_safe_redirect($redirect_url);
        exit;
    } else {
        echo '<div class="notice notice-warning is-dismissible"><p>' . esc_html__('Nothing was changed or update failed.', 'buildecom') . '</p></div>';
    }
}

?>

<div class="buildecom-admin">
    <div class="buildecom-container container">
        <div class="buildecom-form-container">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="mb-0 buildecom-container-title"><?php echo esc_html__('Edit - ', 'buildecom'); ?> <?php echo esc_html($template->name) ?></h4>
                <a class="btn btn-primary btn-sm" href="<?php echo esc_url(admin_url('admin.php?page=buildecom-notification')) ?>">
                    <i class="las la-list"></i>
                    <?php echo esc_html__('Back to List', 'buildecom') ?>
                </a>
            </div>

            <div class="row">
                <div class="col-lg-5">
                    <div class="card buildecom-form-card px-2">
                        <div class="card-body pt-1">
                            <h6><?php echo esc_html__('Global Shortcodes', 'buildecom'); ?></h6>

                            <div class="table-responsive table-responsive-sm">
                                <table class=" table align-items-center table--light">
                                    <thead>
                                        <tr>
                                            <th><?php esc_html_e('Short Code', 'buildecom'); ?></th>
                                            <th class="text-end"><?php esc_html_e('Description', 'buildecom'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody class="list">
                                        <?php foreach (buildecom_global_notify_short_codes() as $shortCode => $codeDetails): ?>
                                            <tr>
                                                <td><span class="short-codes copy-element"><?php echo '{{' .  esc_html($shortCode) . '}}'; ?></span></td>
                                                <td class="text-end"><?php echo esc_html($codeDetails); ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="card mt-4 buildecom-form-card px-2">
                        <div class="card-body pt-1">
                            <?php
                            $shortcodes = json_decode($template->shortcodes, true);
                            ?>
                            <?php if ($shortcodes && is_array($shortcodes)) : ?>
                                <h6><?php echo esc_html__('Template Shortcodes', 'buildecom'); ?></h6>

                                <div class="table-responsive table-responsive-sm">
                                    <table class=" table align-items-center table--light">
                                        <thead>
                                            <tr>
                                                <th><?php esc_html_e('Short Code', 'buildecom'); ?></th>
                                                <th class="text-end"><?php esc_html_e('Description', 'buildecom'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody class="list">
                                            <?php foreach ($shortcodes as $key => $desc): ?>
                                                <tr>
                                                    <td><span class="short-codes copy-element"><?php echo '{{' .  esc_html($key) . '}}'; ?></span></td>
                                                    <td class="text-end"><?php echo esc_html($desc); ?></td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="col-lg-7">
                    <div class="card buildecom-form-card px-2">
                        <div class="card-body">
                            <form method="post" action="">
                                <?php wp_nonce_field('buildecom_save_template', 'buildecom_edit_template_nonce'); ?>

                                <div class="mb-3">
                                    <label for="name" class="form-label"><?php echo esc_html__('Template Name', 'buildecom'); ?></label>
                                    <input type="text" name="name" id="name" class="form-control" value="<?php echo esc_attr($template->name); ?>" required />
                                </div>

                                <div class="mb-3">
                                    <label for="subject" class="form-label"><?php echo esc_html__('Subject', 'buildecom'); ?></label>
                                    <input type="text" name="subject" id="subject" class="form-control" value="<?php echo esc_attr($template->subj); ?>" required />
                                </div>

                                <div class="mb-3">
                                    <label for="firebase_body" class="form-label"><?php echo esc_html__('Message', 'buildecom'); ?></label>
                                    <textarea rows="5" name="firebase_body" class="form-control" id="firebase_body"><?php echo esc_attr($template->firebase_body); ?></textarea>
                                </div>

                                <div class="text-end">
                                    <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-notification')); ?>" class="btn btn-secondary">
                                        <?php echo esc_html__('Cancel', 'buildecom'); ?>
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="las la-save"></i>
                                        <?php echo esc_html__('Save Changes', 'buildecom'); ?>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>