<?php

if (!defined('ABSPATH'))
    exit;


if (!function_exists('buildecom_has_user_reviewed_product')) {
    function buildecom_has_user_reviewed_product($user_id, $product_id, $order_id)
    {
        $order = wc_get_order($order_id);

        if ($order && $order->get_user_id() == $user_id) {
            foreach ($order->get_items() as $item) {
                if ($item->get_product_id() == $product_id && wc_get_order_item_meta($item->get_id(), '_reviewed', true)) {
                    return true;
                }
            }
        }

        return false;
    }
}

if (!function_exists('buildecom_has_user_purchased_product')) {
    function buildecom_has_user_purchased_product($user_id, $product_id, $order_id)
    {
        $order = wc_get_order($order_id);

        if ($order && $order->get_user_id() == $user_id) {
            foreach ($order->get_items() as $item) {
                if ($item->get_product_id() == $product_id) {
                    return true;
                }
            }
        }

        return false;
    }
}

if (!function_exists('buildecom_truncate')) {
    function buildecom_truncate(
        string $text,
        int $limit = 100,
        string $suffix = '…',
        bool $preserveWords = true,
        ?string $encoding = null
    ): string {
        if ($limit < 1) {
            throw new InvalidArgumentException('$limit must be at least 1');
        }

        $encoding ??= mb_internal_encoding();
        $suffixLen = mb_strlen($suffix, $encoding);

        if ($suffixLen >= $limit) {
            return mb_substr($suffix, 0, $limit, $encoding);
        }

        if (mb_strlen($text, $encoding) <= $limit) {
            return $text;
        }

        $cut = $limit - $suffixLen;
        $snippet = mb_substr($text, 0, $cut, $encoding);

        if ($preserveWords) {
            $result = preg_replace('/\s+\S*$/u', '', $snippet);

            if (is_string($result)) {
                $snippet = $result;
            }
        }

        return rtrim($snippet) . $suffix;
    }
}

if (!function_exists('buildecom_generate_password_reset_token')) {
    function buildecom_generate_password_reset_token()
    {
        $characters = '0123456789';
        $randomString = '';

        for ($i = 0; $i < 6; $i++) {
            $randomString .= $characters[wp_rand(0, strlen($characters) - 1)];
        }

        return $randomString;
    }
}



if (!function_exists('buildecom_check_empty')) {
    function buildecom_check_empty($data)
    {
        if (is_object($data)) {
            $data = (array) $data;
        }
        return empty($data);
    }
}

if (!function_exists('buildecom_response_error')) {
    function buildecom_response_error($remark, $message, $data = [], $status = 200)
    {
        $response = [
            'status' => 'error',
            'remark' => $remark,
            'message' => ['error' => is_array($message) ? $message : [$message]],
            ...$data
        ];

        return new \WP_REST_Response($response, $status);
    }
}


if (!function_exists('buildecom_get_formatted_date')) {
    function buildecom_get_formatted_date($time = false)
    {
        if (!$time) {
            $time = strtotime('now');
        }

        $format = apply_filters('buildecom_date_format', 'H:i');

        $date = new DateTime();
        $date->setTimestamp($time);
        $date->setTimezone(buildecom_wp_timezone());

        return date_format($date, $format);
    }
}


if (!function_exists('buildecom_wp_timezone')) {
    function buildecom_wp_timezone()
    {
        return new DateTimeZone(buildecom_wp_timezone_string());
    }
}


if (!function_exists('buildecom_wp_timezone_string')) {
    function buildecom_wp_timezone_string()
    {
        $timezone_string = get_option('timezone_string');

        if ($timezone_string) {
            return $timezone_string;
        }

        $offset = (float) get_option('gmt_offset');
        $hours = (int) $offset;
        $minutes = ($offset - $hours);

        $sign = ($offset < 0) ? '-' : '+';
        $abs_hour = abs($hours);
        $abs_mins = abs($minutes * 60);
        $tz_offset = sprintf('%s%02d:%02d', $sign, $abs_hour, $abs_mins);

        return $tz_offset;
    }
}


if (!function_exists('buildecom_response_success')) {
    function buildecom_response_success($remark, $message, $data = [], $status = 200)
    {
        $response = [
            'status' => 'success',
            'remark' => $remark,
            'message' => ['success' => is_array($message) ? $message : [$message]],
            ...$data
        ];

        return new \WP_REST_Response($response, $status);
    }
}

if (!function_exists('buildecom_get_user')) {
    function buildecom_get_user($user_id = false)
    {
        if (!class_exists('BuildecomUser')) {
            require_once BUILDECOM_DIR_PATH . 'inc/api/class-buildecom-user.php';
        }

        return new BuildecomUser($user_id);
    }
}

if (!function_exists('buildecom_get_allowed_roles')) {
    function buildecom_get_allowed_roles()
    {

        $all_roles = wp_roles()->roles;
        $roles_array = array();

        foreach ($all_roles as $slug => $role) {

            if ($slug === 'administrator') {
                continue;
            }

            $roles_array[] = $slug;
        }

        return apply_filters('buildecom_allowed_roles', $roles_array);
    }
}



if (!function_exists('buildecom_get_new_code_expiration_time')) {
    function buildecom_get_new_code_expiration_time($valid_seconds = 900)
    {
        $time_string = '+' . $valid_seconds . ' seconds';
        return strtotime($time_string);
    }
}
if (!function_exists('buildecom_send_password_reset_code_email')) {
    function buildecom_send_password_reset_code_email($email = false, $code = false, $expiry = 0)
    {
        if (!$email) {
            throw new Exception(esc_html__('An email address is required for the reset code email.', 'buildecom'));
        }

        if (!$code) {
            throw new Exception(esc_html__('No code was provided for the password reset email.', 'buildecom'));
        }

        ob_start();
        $template_path = BUILDECOM_DIR_PATH . 'templates/reset-code-email.php';

        if (file_exists($template_path)) {
            include $template_path;
        } else {
            echo esc_html__('A password reset was requested for your account. Your code: ', 'buildecom') . esc_html($code);
        }

        $html_message = ob_get_clean();

        $subject = apply_filters('buildecom_code_email_subject', __('Password Reset', 'buildecom'));

        $html_message = apply_filters('buildecom_code_email_text', $html_message, $email, $code, $expiry);

        $siteName = get_bloginfo('name');
        $mailFrom = get_option('admin_email');
        $headers = [];
        $headers[] = "From: $siteName <$mailFrom>";
        $headers[] = "Reply-To: $siteName <$mailFrom>";
        $headers[] = "MIME-Version: 1.0";
        $headers[] = "Content-Type: text/html; charset=utf-8";

        return wp_mail($email, $subject, $html_message, $headers);
    }
}


if (!function_exists('buildecom_currency')) {
    function buildecom_currency($type = 'text')
    {
        return get_option("buildecom_cur_$type");
    }
}


if (!function_exists('buildecom_to_object')) {
    function buildecom_to_object($args)
    {
        if (is_array($args)) {
            return (object) array_map(__FUNCTION__, $args);
        } else {
            return $args;
        }
    }
}

if (!function_exists('buildecom_global_notify_short_codes')) {
    function buildecom_global_notify_short_codes()
    {
        $data['site_name'] = 'Name of your site';
        $data['site_currency'] = 'Currency of your site';
        $data['currency_symbol'] = 'Symbol of currency';
        return $data;
    }
}

if (!function_exists('buildecom_notify')) {
    function buildecom_notify($user, $templateName, $shortCodes = null, $sendVia = null, $createLog = true)
    {
        $globalShortCodes = [
            'site_name' => get_bloginfo('name'),
        ];

        if (gettype($user) == 'array') {
            $user = (object) $user;
        }

        $userInfo = [
            'id' => $user->ID,
            'email' => $user->user_email,
            'fullname' => $user->display_name,
            'username' => $user->user_login
        ];

        if (!class_exists('Buildecom_Notify')) {
            require_once BUILDECOM_DIR_PATH . '/notify/class-buildecom-notify.php';
        }

        $userInfo = buildecom_to_object($userInfo);
        $shortCodes = array_merge($shortCodes ?? [], $globalShortCodes);
        $notify = new Buildecom_Notify($sendVia);
        $notify->templateName = $templateName;
        $notify->shortCodes = $shortCodes;
        $notify->user = $userInfo;
        $notify->createLog = $createLog;
        $notify->send();
    }
}


if (!function_exists('buildecom_get_media_file')) {
    function buildecom_get_media_file($postId)
    {
        return home_url() . '/wp-content/uploads/' . get_post_meta($postId, '_wp_attached_file', true);
    }
}

if (!function_exists('buildecom_to_array')) {
    function buildecom_to_array($args)
    {
        if (is_object($args)) {
            $args = get_object_vars($args);
        }

        if (is_array($args)) {
            return array_map(__FUNCTION__, $args);
        } else {
            return $args;
        }
    }
}


if (!function_exists('buildecom_post_content')) {
    function buildecom_post_content($url, $postData = null, $headers = [])
    {
        $args = [
            'method' => 'POST',
            'body' => is_array($postData) ? wp_json_encode($postData) : $postData,
            'headers' => array_merge(['Content-Type' => 'application/json'], $headers),
            'sslverify' => true
        ];

        $response = wp_remote_post($url, $args);

        if (is_wp_error($response)) {
            return $response->get_error_message();
        }

        return wp_remote_retrieve_body($response);
    }
}



if (!function_exists('buildecom_get_woocommerce_order_data')) {
    function buildecom_get_woocommerce_order_data($orderId)
    {
        $order = wc_get_order($orderId);

        if ($order) {
            $shortCodesArr = [
                'status' => $order->get_status(),
                'currency' => $order->get_currency(),
                'shipping_tax' => $order->get_shipping_tax(),
                'total' => $order->get_total(),
                'total_tax' => $order->get_total_tax(),
                'order_key' => $order->get_order_key(),
                'billing_first_name' => $order->get_billing_first_name(),
                'billing_last_name' => $order->get_billing_last_name(),
                'billing_company' => $order->get_billing_company(),
                'billing_address_1' => $order->get_billing_address_1(),
                'billing_address_2' => $order->get_billing_address_2(),
                'billing_city' => $order->get_billing_city(),
                'billing_state' => $order->get_billing_state(),
                'billing_postcode' => $order->get_billing_postcode(),
                'billing_country' => $order->get_billing_country(),
                'billing_email' => $order->get_billing_email(),
                'billing_phone' => $order->get_billing_phone(),
                'shipping_first_name' => $order->get_shipping_first_name(),
                'shipping_last_name' => $order->get_shipping_last_name(),
                'shipping_company' => $order->get_shipping_company(),
                'shipping_address_1' => $order->get_shipping_address_1(),
                'shipping_address_2' => $order->get_shipping_address_2(),
                'shipping_city' => $order->get_shipping_city(),
                'shipping_state' => $order->get_shipping_state(),
                'shipping_postcode' => $order->get_shipping_postcode(),
                'shipping_country' => $order->get_shipping_country(),
                'shipping_phone' => $order->get_shipping_phone(),
                'payment_method' => $order->get_payment_method(),
                'payment_method_title' => $order->get_payment_method_title(),
                'transaction_id' => $order->get_transaction_id(),
                'date_paid' => $order->get_date_paid(),
            ];
        }

        return $shortCodesArr;
    }
}


if (!function_exists('buildecom_wc_order_status_changed')) {
    function buildecom_wc_order_status_changed($orderId, $newStatus = null)
    {
        $user = wp_get_current_user()->data;

        $shortCodesArr = buildecom_get_woocommerce_order_data($orderId);

        $newStatus = $shortCodesArr['status'];

        if ($newStatus === 'pending') {
            buildecom_notify($user, 'WC_PENDING', $shortCodesArr, ['email']);
        } else if ($newStatus === 'processing') {
            buildecom_notify($user, 'WC_PROCESSING', $shortCodesArr, ['email']);
        } else if ($newStatus === 'shipped') {
            buildecom_notify($user, 'WC_SHIPPED', $shortCodesArr, ['email']);
        } else if ($newStatus === 'on-hold') {
            buildecom_notify($user, 'WC_ONHOLD', $shortCodesArr, ['email']);
        } else if ($newStatus === 'cancelled') {
            buildecom_notify($user, 'WC_CANCELLED', $shortCodesArr, ['email']);
        } else if ($newStatus === 'refunded') {
            buildecom_notify($user, 'WC_REFUNDED', $shortCodesArr, ['email']);
        } else if ($newStatus === 'failed') {
            buildecom_notify($user, 'WC_FAILED', $shortCodesArr, ['email']);
        } else if ($newStatus === 'completed') {
            buildecom_notify($user, 'WC_COMPLETED', $shortCodesArr, ['email']);
        } else {
            $status = 'WC_' . strtoupper(str_replace('-', '_', $newStatus));
            buildecom_notify($user, $status, $shortCodesArr, ['email']);
        }
    }
}

if(!function_exists('buildecom_make_slug')){
    function buildecom_make_slug($str){
        $str = strtolower($str);

        $str = str_replace(' ', '-', $str);

        $str = preg_replace('/[^a-z0-9-]/', '', $str);

        $str = preg_replace('/-+/', '-', $str);

        $str = trim($str, '-');

        return $str;
    }
}
