<?php

if (!defined('ABSPATH')) exit;

/** Delete banner itself */
if ('delete' === $current_action && isset($_GET['id'], $_GET['_wpnonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'buildecom_banner_action')) {
    $banner_id = intval($_GET['id']);
    global $wpdb;

    $deleted = $wpdb->delete(
        $wpdb->prefix . 'buildecom_banners',
        ['id' => $banner_id],
        ['%d']
    );

    if ($deleted) {
        $redirect_url = add_query_arg([
            'message'      => urlencode('banner_deleted'),
            'message_type' => 'success',
            'page'         => sanitize_key('buildecom-banners'),
            // 'action'       => sanitize_key('categories'),
            '_wpnonce'     => wp_create_nonce('buildecom_banner_action')
        ], admin_url('admin.php'));
    } else {
        $redirect_url = add_query_arg([
            'message'      => urlencode('banner_delete_failed'),
            'message_type' => 'error',
            'page'         => sanitize_key('buildecom-banners'),
            'action'       => sanitize_key('categories'),
            '_wpnonce'     => wp_create_nonce('buildecom_banner_action')
        ], admin_url('admin.php'));
    }

    wp_safe_redirect($redirect_url);
    exit;
}


/** Banner Status Toggle */
if (isset($_GET['action'], $_GET['id'], $_GET['_wpnonce']) && $_GET['action'] === 'toggle_status') {
    global $wpdb;

    if (wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'buildecom_banner_action')) {
        $banner_id  = isset($_GET['id']) ? intval($_GET['id']) : 0;
        $new_status = isset($_GET['status']) ? intval($_GET['status']) : 0;

        $wpdb->update(
            $wpdb->prefix . 'buildecom_banners',
            ['status' => $new_status],
            ['id' => $banner_id]
        );

        $message = $new_status ? 'Banner enabled' : 'Banner disabled';

        $redirect_url = add_query_arg([
            'page'     => sanitize_key('buildecom-banners'),
            'message'  => urlencode($message),
            '_wpnonce' => wp_create_nonce('buildecom_banner_action')
        ], admin_url('admin.php'));

        wp_safe_redirect($redirect_url);
        exit;
    } else {
        wp_die(esc_html__('Invalid nonce.', 'buildecom'));
    }
}

require_once BUILDECOM_DIR_PATH . 'class-buildecom-banners-table.php';

$banner_table = new Buildecom_Banners_Table();

$banner_table->process_bulk_action();

$banner_table->prepare_items();


?>
<div class="wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('Manage Banners', 'buildecom'); ?></h1>

    <a class="page-title-action" href="<?php echo esc_url(admin_url('admin.php?page=buildecom-banners&action=categories')); ?>">
        <?php esc_html_e('Banner Categories', 'buildecom') ?>
    </a>

    <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-banners&action=add')); ?>" class="page-title-action">
        <?php esc_html_e('Add New', 'buildecom'); ?>
    </a>

    <form method="post">
        <?php $banner_table->display(); ?>
    </form>
</div>