<?php
if (!defined('ABSPATH')) exit;

global $wpdb;

$banner_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if (!$banner_id) {
    wp_die(esc_html__('Invalid banner ID.', 'buildecom'));
}

$banner = $wpdb->get_row($wpdb->prepare(
    "SELECT * FROM {$wpdb->prefix}buildecom_banners WHERE id = %d",
    $banner_id
));

if (!$banner) {
    wp_die(esc_html__('Banner not found.', 'buildecom'));
}

$products = wc_get_products(['limit' => -1]);

$product_categories = get_terms([
    'taxonomy'   => 'product_cat',
    'hide_empty' => false,
]);

$banner_categories = $wpdb->get_results("SELECT id, name FROM {$wpdb->prefix}buildecom_categories");

if (
    isset($_POST['submit_banner']) &&
    isset($_POST['_wpnonce']) &&
    wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'buildecom_edit_banner')
) {
    check_admin_referer('buildecom_edit_banner');

    $title              = isset($_POST['title']) ?  sanitize_text_field(wp_unslash($_POST['title'])) : null;
    $position           = isset($_POST['position']) ?  intval(wp_unslash($_POST['position'])) : null;
    $banner_type        = isset($_POST['banner_type']) ? intval(wp_unslash($_POST['banner_type'])) : null;
    $category_id        = isset($_POST['category_id']) ?  intval(wp_unslash($_POST['category_id'])) : null;
    $product_id         = isset($_POST['product_id']) ?  intval(wp_unslash($_POST['product_id'])) : null;
    $banner_category_id = isset($_POST['banner_category_id']) ?  intval(wp_unslash($_POST['banner_category_id'])) : null;
    $image              = isset($_POST['image']) ? sanitize_text_field($_POST['image']) : null;

    $wpdb->update(
        $wpdb->prefix . 'buildecom_banners',
        [
            'title'              => $title,
            'position'           => $position,
            'banner_type'        => $banner_type,
            'category_id'        => $category_id,
            'banner_category_id' => $banner_category_id,
            'product_id'         => $product_id,
            'image'              => $image,
        ],
        ['id' => $banner_id]
    );

    $redirect_url = add_query_arg([
        'message'  => urlencode(__('Banner updated successfully', 'buildecom')),
        '_wpnonce' => wp_create_nonce('buildecom_admin_notice'),
        'page'     => 'buildecom-banners',
    ], esc_url(admin_url('admin.php')));

    wp_safe_redirect($redirect_url);
    exit;
}
?>

<div class="wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('Edit Banner', 'buildecom'); ?></h1>
    <a class="page-title-action" href="<?php echo esc_url(admin_url('admin.php?page=buildecom-banners')) ?>"><?php echo esc_html__('Back to List', 'buildecom') ?></a>

    <form method="post" enctype="multipart/form-data">
        <?php wp_nonce_field('buildecom_edit_banner'); ?>
        <input type="hidden" name="submit_banner" />

        <table class="form-table">
            <tr>
                <th><label for="title"><?php echo esc_html__('Title', 'buildecom'); ?></label></th>
                <td><input type="text" name="title" id="title" class="form-control" required value="<?php echo esc_attr($banner->title); ?>"></td>
            </tr> 
            <tr>
                <th><label for="banner_type"><?php echo esc_html__('Banner Type', 'buildecom'); ?></label></th>
                <td>
                    <select name="banner_type" id="banner_type" class="form-control">
                        <option value="1" <?php selected($banner->banner_type, 1); ?>><?php echo esc_html__('Category', 'buildecom'); ?></option>
                        <option value="0" <?php selected($banner->banner_type, 0); ?>><?php echo esc_html__('Product', 'buildecom'); ?></option>
                    </select>
                </td>
            </tr>

            <tr>
                <th><label for="category_id"><?php echo esc_html__('Category', 'buildecom'); ?></label></th>
                <td>
                    <select name="category_id" id="category_id" class="form-control">
                        <?php foreach ($product_categories as $category): ?>
                            <option value="<?php echo esc_attr($category->term_id); ?>" <?php selected($banner->category_id, $category->term_id); ?>>
                                <?php echo esc_html($category->name); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </td>
            </tr>

            <tr>
                <th><label for="product_id"><?php echo esc_html__('Product', 'buildecom'); ?></label></th>
                <td>
                    <select name="product_id" id="product_id" class="form-control">
                        <?php foreach ($products as $product): ?>
                            <option value="<?php echo esc_attr($product->get_id()); ?>" <?php selected($banner->product_id, $product->get_id()); ?>>
                                <?php echo esc_html($product->get_name()); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </td>
            </tr>

            <tr>
                <th><label for="banner_category_id"><?php echo esc_html__('Banner Category', 'buildecom'); ?></label></th>
                <td>
                    <select name="banner_category_id" id="banner_category_id" class="form-control">
                        <?php if (!empty($banner_categories)): ?>
                            <?php foreach ($banner_categories as $banner_category): ?>
                                <option value="<?php echo esc_attr($banner_category->id); ?>" <?php selected($banner->banner_category_id, $banner_category->id); ?>>
                                    <?php echo esc_html($banner_category->name); ?>
                                </option>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <option value=""><?php echo esc_html__('No banner categories found', 'buildecom'); ?></option>
                        <?php endif; ?>
                    </select>
                </td>
            </tr>

            <tr>
                <th><label for="image"><?php echo esc_html__('Banner Image', 'buildecom'); ?></label></th>
                <td>
                    <input type="button" class="button" id="upload_image_button" value="<?php echo esc_html__('Upload Image', 'buildecom'); ?>">
                    <input type="hidden" name="image" id="image" value="<?php echo esc_attr($banner->image); ?>" />
                    <div id="image_preview">
                        <?php if ($banner->image): ?>
                            <img src="<?php echo esc_url($banner->image); ?>" style="max-width:150px; margin-top:10px;" />
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
            <tr>
                <td></td>
                <td>
                    <p class="submit">
                        <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php echo esc_html__('Update Banner', 'buildecom'); ?>">
                    </p>
                </td>
            </tr>
        </table>
    </form>
</div>