<?php
if (!defined('ABSPATH')) exit;

$products = wc_get_products(['limit' => -1]);

$product_categories = get_terms([
    'taxonomy'   => 'product_cat',
    'hide_empty' => false,
]);

global $wpdb;

$banner_categories = $wpdb->get_results("SELECT id, name FROM {$wpdb->prefix}buildecom_categories");

if (
    isset($_POST['submit_banner']) &&
    isset($_POST['_wpnonce']) &&
    wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'buildecom_add_banner')
) {
    $title              = isset($_POST['title']) ?  sanitize_text_field(wp_unslash($_POST['title'])) : null;
    $position           = isset($_POST['position']) ?  intval(wp_unslash($_POST['position'])) : null;
    $banner_type        = isset($_POST['banner_type']) ? intval(wp_unslash($_POST['banner_type'])) : null;
    $category_id        = isset($_POST['category_id']) ?  intval(wp_unslash($_POST['category_id'])) : null;
    $product_id         = isset($_POST['product_id']) ?  intval(wp_unslash($_POST['product_id'])) : null;
    $banner_category_id = isset($_POST['banner_category_id']) ?  intval(wp_unslash($_POST['banner_category_id']))  : null;
    $image              = isset($_POST['image']) ?  sanitize_text_field($_POST['image']) : null;

    /** other fields are optional */
    if ($title && $position) {
        $wpdb->insert(
            $wpdb->prefix . 'buildecom_banners',
            [
                'title'              => $title,
                'position'           => $position,
                'banner_type'        => $banner_type,
                'category_id'        => $category_id,
                'banner_category_id' => $banner_category_id,
                'product_id'         => $product_id ?? 0,
                'image'              => $image,
                'status'             => 1,
                'created_at'         => current_time('mysql'),
            ]
        );

        $redirect_url = add_query_arg([
            'message'  => urlencode(__('Banner addedd successfully', 'buildecom')),
            '_wpnonce' => wp_create_nonce('buildecom_admin_notice'),
            'page'     => 'buildecom-banners',
            // '_wpnonce_action' => wp_create_nonce('buildecom_banner_action')
        ], esc_url(admin_url('admin.php')));

        wp_safe_redirect($redirect_url);
        exit;
    }
}

?>

<div class="wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('Add New Banner', 'buildecom'); ?></h1>
    <a class="page-title-action" href="<?php echo esc_url(admin_url('admin.php?page=buildecom-banners')) ?>"><?php echo esc_html__('Back to List', 'buildecom') ?></a>

    <hr class="wp-header-end" />

    <form method="post" enctype="multipart/form-data">
        <?php wp_nonce_field('buildecom_add_banner'); ?>
        <input type="hidden" name="submit_banner" />

        <table class="form-table">
            <tr>
                <th><label for="title"><?php echo esc_html__('Title', 'buildecom'); ?></label></th>
                <td><input type="text" name="title" id="title" class="form-control" required></td>
            </tr>
 

            <tr>
                <th><label for="banner_type"><?php echo esc_html__('Banner Type', 'buildecom'); ?></label></th>
                <td>
                    <select name="banner_type" id="banner_type" class="form-control">
                        <option value="1"><?php echo esc_html__('Category', 'buildecom'); ?></option>
                        <option value="0"><?php echo esc_html__('Product', 'buildecom'); ?></option>
                    </select>
                </td>
            </tr>

            <tr>
                <th><label for="category_id"><?php echo esc_html__('Category', 'buildecom'); ?></label></th>
                <td>
                    <select name="category_id" id="category_id" class="form-control">
                        <?php foreach ($product_categories as $category): ?>
                            <option value="<?php echo esc_attr($category->term_id); ?>">
                                <?php echo esc_html($category->name); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </td>
            </tr>

            <tr>
                <th><label for="product_id"><?php echo esc_html__('Product', 'buildecom'); ?></label></th>
                <td>
                    <select name="product_id" id="product_id" class="form-control">
                        <?php foreach ($products as $product): ?>
                            <option value="<?php echo esc_attr($product->get_id()); ?>">
                                <?php echo esc_html($product->get_name()); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </td>
            </tr>

            <tr>
                <th><label for="banner_category_id"><?php echo esc_html__('Banner Category', 'buildecom'); ?></label></th>
                <td>
                    <select name="banner_category_id" id="banner_category_id" class="form-control">
                        <?php if (!empty($banner_categories)): ?>
                            <?php foreach ($banner_categories as $banner_category): ?>
                                <option value="<?php echo esc_attr($banner_category->id); ?>">
                                    <?php echo esc_html($banner_category->name); ?>
                                </option>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <option value=""><?php echo esc_html__('No banner categories found', 'buildecom'); ?></option>
                        <?php endif; ?>
                    </select>
                </td>
            </tr>

            <tr>
                <th><label for="image"><?php echo esc_html__('Banner Image', 'buildecom'); ?></label></th>
                <td>
                    <input type="button" class="button" id="upload_image_button" value="<?php echo esc_html__('Upload Image', 'buildecom'); ?>">
                    <input type="hidden" name="image" id="image" value="" />
                </td>
            </tr>

            <tr>
                <td></td>
                <td>
                    <p class="submit">
                        <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php echo esc_html__('Save Banner', 'buildecom'); ?>">
                    </p>
                </td>
            </tr>
        </table>

    </form>
</div>