<?php
if (!defined('ABSPATH')) exit;
?>

<?php

/** Banner Category Status toggle */
if (isset($_GET['action'], $_GET['id']) && $_GET['action'] === 'category_toggle_status' && isset($_GET['_wpnonce'])) {
    global $wpdb;

    if (wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'buildecom_banner_action')) {
        $banner_id  = isset($_GET['status']) ? intval($_GET['id']) : 0;
        $new_status = isset($_GET['status']) ?  intval($_GET['status']) : 0;

        $wpdb->update(
            $wpdb->prefix . 'buildecom_categories',
            ['status' => $new_status],
            ['id' => $banner_id]
        );

        $message = $new_status ? 'Banner category enabled' : 'Banner category disabled';

        $redirect_url = add_query_arg([
            'page'     => sanitize_key('buildecom-banners'),
            'action'   => sanitize_key('categories'),
            'message'  => urlencode($message),
            '_wpnonce' => wp_create_nonce('buildecom_banner_action')
        ], admin_url('admin.php'));

        wp_safe_redirect($redirect_url);
        exit;
    } else {
        wp_die(esc_html__('Invalid nonce.', 'buildecom'));
    }
}

/** Delete banner category */
if ('category-delete' === $current_action && isset($_GET['id'], $_GET['_wpnonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'buildecom_banner_action')) {
    $banner_category_id = intval($_GET['id']);
    global $wpdb;

    $deleted = $wpdb->delete(
        $wpdb->prefix . 'buildecom_categories',
        ['id' => $banner_category_id],
        ['%d']
    );

    if ($deleted) {
        $redirect_url = add_query_arg([
            'message'      => urlencode('Category deleted successfully.'),
            'message_type' => 'success',
            'page'         => sanitize_key('buildecom-banners'),
            'action'       => sanitize_key('categories'),
            '_wpnonce'     => wp_create_nonce('buildecom_banner_action')
        ], admin_url('admin.php'));
    } else {
        $redirect_url = add_query_arg([
            'message'      => urlencode('Category could note be deleted.'),
            'message_type' => 'error',
            'page'         => sanitize_key('buildecom-banners'),
            'action'       => sanitize_key('categories'),
            '_wpnonce'     => wp_create_nonce('buildecom_banner_action')
        ], admin_url('admin.php'));
    }

    wp_safe_redirect($redirect_url);
    exit;
}


require_once plugin_dir_path(__FILE__) . 'class-banner-categories-table.php';

$banner_category_table = new Buildecom_Banners_Categories_Table();

$banner_category_table->process_bulk_action();

$banner_category_table->prepare_items();


?>

<div class="buildecom-admin">
    <div class="wrap">
        <h1 class="wp-heading-inline"><?php esc_html_e('Banner Categories', 'buildecom'); ?></h1>
        <a class="page-title-action" href="<?php echo esc_url(admin_url('admin.php?page=buildecom-banners&action=categories-add')) ?>"><?php echo esc_html__('Add New', 'buildecom') ?></a>

        <form method="post">
            <?php
            $banner_category_table->display();
            ?>
        </form>
    </div>
</div>