<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'buildecom'));
}

if (!isset($_GET['_wpnonce']) || !isset($_GET['id'])) {
    wp_die(esc_html__('Invalid request.', 'buildecom'));
}

$category_id = isset($_GET['id']) ? absint($_GET['id']) : 0;

if (!wp_verify_nonce(sanitize_key($_GET['_wpnonce']), 'view_category_' . $category_id)) {
    wp_die(esc_html__('Security check failed.', 'buildecom'));
}

if ($category_id <= 0) {
    wp_die(esc_html__('Invalid category ID.', 'buildecom'));
}

global $wpdb;

$category = $wpdb->get_row($wpdb->prepare(
    "SELECT * FROM {$wpdb->prefix}buildecom_categories WHERE id = %d",
    $category_id
));

if (!$category) {
    wp_die(esc_html__('Category not found.', 'buildecom'));
}

if (
    isset($_POST['submit_banner_category']) &&
    isset($_POST['_wpnonce']) &&
    wp_verify_nonce(wp_unslash($_POST['_wpnonce']), 'buildecom_edit_banner_category')
) {
    $category_name = sanitize_text_field($_POST['name']);

    $updated = $wpdb->update(
        "{$wpdb->prefix}buildecom_categories",
        ['name' => $category_name],
        ['id' => $category_id]
    );

    $redirect_url = add_query_arg([
        'page'         => 'buildecom-banners',
        'action'       => 'categories',
        'message'      => urlencode(__('Category updated successfully', 'buildecom')),
        'message_type' => 'success',
        '_wpnonce'     => wp_create_nonce('buildecom_admin_notice'),
    ], admin_url('admin.php'));

    wp_safe_redirect(esc_url_raw($redirect_url));
    exit;
}
?>

<h1><?php esc_html_e('Edit Banner Category', 'buildecom') ?></h1>

<form method="post" enctype="multipart/form-data">
    <?php wp_nonce_field('buildecom_edit_banner_category'); ?>
    <input type="hidden" name="submit_banner_category" />

    <table class="form-table">
        <tr>
            <th><label for="name"><?php echo esc_html__('Name', 'buildecom'); ?></label></th>
            <td><input type="text" name="name" id="name" class="form-control" value="<?php echo esc_attr($category->name); ?>" required></td>
        </tr>
        <tr>
            <td></td>
            <td>
                <p class="submit">
                    <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php echo esc_html__('Update', 'buildecom'); ?>">
                </p>
            </td>
        </tr>
    </table>
</form>