<?php
if (!defined('ABSPATH')) exit;

if (!class_exists('WP_List_Table')) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

class Buildecom_Banners_Categories_Table extends WP_List_Table
{
    private $banners_categories;

    public function __construct()
    {
        parent::__construct([
            'singular' => 'banner_category',
            'plural'   => 'banners_categories',
            'ajax'     => false
        ]);
    }

    public function prepare_items()
    {
        global $wpdb;

        $table_name               = $wpdb->prefix . 'buildecom_categories';
        $this->banners_categories = $wpdb->get_results("SELECT * FROM $table_name", ARRAY_A);
        $columns                  = $this->get_columns();
        $hidden                   = [];
        $sortable                 = [];

        $this->_column_headers = [$columns, $hidden, $sortable];
        $this->items           = $this->banners_categories;
    }

    public function get_columns()
    {
        return [
            'cb'      => '<input type="checkbox" id="cb-select-all-1" />',
            'name'    => 'Name',
            'status'  => 'Status',
            'actions' => 'Actions'
        ];
    }

    public function column_cb($item)
    {
        return sprintf(
            '<input type="checkbox" name="banner_category[]" value="%s" />',
            $item['id']
        );
    }

    public function column_actions($item)
    {
        $edit_url = add_query_arg([
            'page'     => 'buildecom-banners',
            'action'   => 'category-edit',
            'id'       => $item['id'],
            '_wpnonce' => wp_create_nonce('view_category_' . $item['id']),
        ], esc_url(admin_url('admin.php')));

        $delete_url = wp_nonce_url(add_query_arg([
            'page'   => 'buildecom-banners',
            'action' => 'category-delete',
            'id'     => $item['id']
        ], esc_url(admin_url('admin.php'))), 'buildecom_banner_action');

        $toggle_status = $item['status'] ? 0 : 1;
        $status_label  = $item['status'] ? __('Disable', 'buildecom') : __('Enable', 'buildecom');

        $toggle_url = wp_nonce_url(add_query_arg([
            'page'   => 'buildecom-banners',
            'action' => 'category_toggle_status',
            'id'     => $item['id'],
            'status' => $toggle_status
        ], esc_url(admin_url('admin.php'))), 'buildecom_banner_action');

        return sprintf(
            '<a href="%s" class="btn btn-primary btn-sm me-1">%s</a>
            <a href="%s" class="btn btn-danger btn-sm me-1" onclick="return confirm(\'Are you sure you want to delete?\')">%s</a>
            <a href="%s" class="btn btn-%s btn-sm">%s</a>',
            esc_url($edit_url),
            esc_html__('Edit', 'buildecom'),
            esc_url($delete_url),
            esc_html__('Delete', 'buildecom'),
            esc_url($toggle_url),
            $item['status'] ? 'warning' : 'success',
            esc_html($status_label)
        );
    }

    public function column_status($item)
    {
        return $item['status'] ? '<span class="badge text-bg-success">Enabled</span>' : '<span class="badge text-bg-danger">Disabled</span>';
    }

    public function column_default($item, $column_name)
    {
        return $item[$column_name] ?? '';
    }

    public function get_bulk_actions()
    {
        return [
            'delete-banner-categories' => 'Delete'
        ];
    }

    public function process_bulk_action()
    {
        if ('delete-banner-categories' == $this->current_action() && !empty($_POST['banner_category'])) {
            global $wpdb;
            $ids = array_map('intval', $_POST['banner_category']);
            $table_name = $wpdb->prefix . 'buildecom_categories';

            foreach ($ids as $id) {
                $wpdb->delete($table_name, ['id' => $id], ['%d']);
            }

            $redirect_url = add_query_arg([
                'message' => urlencode('Selected categories deleted successfully'),
            ], admin_url('admin.php?page=buildecom-banners&action=categories'));

            wp_safe_redirect($redirect_url);
            exit;
        }
    }
}
