<?php
if (!defined('ABSPATH')) exit;
?>

<?php
if (
    isset($_POST['submit_banner_category']) &&
    isset($_POST['_wpnonce']) &&
    wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'buildecom_add_banner_category')
) {
    global $wpdb;

    $name = isset($_POST['name']) ? sanitize_text_field(wp_unslash($_POST['name'])) : false;

    $wpdb->insert(
        $wpdb->prefix . 'buildecom_categories',
        [
            'name'       => $name,
            'created_at' => current_time('mysql'),
        ]
    );

    $redirect_url = add_query_arg([
        'message' => urlencode(__('Category added successfully', 'buildecom')),
        'page'    => 'buildecom-banners',
        'action'  => 'categories',
    ], esc_url(admin_url('admin.php')));

    wp_safe_redirect($redirect_url);
    exit;
}
?>

<div class="wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('Add Banner Category', 'buildecom'); ?></h1>
    <a class="page-title-action" href="<?php echo esc_url(admin_url('admin.php?page=buildecom-banners&action=categories')) ?>"><?php echo esc_html__('Back to List', 'buildecom') ?></a>

    <form method="post" enctype="multipart/form-data">
        <?php wp_nonce_field('buildecom_add_banner_category'); ?>
        <input type="hidden" name="submit_banner_category" />

        <table class="form-table">
            <tr>
                <th><label for="name"><?php echo esc_html__('Name', 'buildecom'); ?></label></th>
                <td><input type="text" name="name" id="name" class="form-control" required></td>
            </tr>
            <tr>
                <td></td>
                <td>
                    <p class="submit">
                        <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php echo esc_html__('Submit', 'buildecom'); ?>">
                    </p>
                </td>
            </tr>
        </table>

    </form>
</div>