<?php

if (!defined('ABSPATH')) exit;

$page = isset($_GET['page']) ? wp_unslash($_GET['page']) : false;

if ($page && ('buildecom-setting' !== $page && 'buildecom-notification' !== $page)) {
    add_action('admin_notices', function () {
        if (
            !empty($_GET['message']) &&
            isset($_GET['_wpnonce']) &&
            wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'buildecom_admin_notice')
        ) {
            $type = isset($_GET['message_type']) ? sanitize_key(wp_unslash($_GET['message_type'])) : 'success';
            $allowed_types = ['success', 'error', 'warning', 'info'];
            if (!in_array($type, $allowed_types)) {
                $type = 'info';
            }

            $message = sanitize_text_field(wp_unslash($_GET['message']));
            echo '<div class="notice notice-' . esc_attr($type) . ' is-dismissible"><p>' . esc_html($message) . '</p></div>';
        }
    });
}
