CREATE TABLE `{{prefix}}buildecom_extensions` (
  `id` bigint(20) UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `act` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `script` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shortcode` text COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'object',
  `support` text COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'help section',
  `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=>enable, 2=>disable',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `{{prefix}}buildecom_extensions` (`id`, `act`, `name`, `description`, `image`, `script`, `shortcode`, `support`, `status`, `created_at`, `updated_at`) VALUES
(2, 'google-recaptcha2', 'Google Recaptcha 2', 'Key location is shown bellow', 'recaptcha3.png', '\n<script src=\"https://www.google.com/recaptcha/api.js\"></script>\n<div class=\"g-recaptcha\" data-sitekey=\"{{site_key}}\" data-callback=\"verifyCaptcha\"></div>\n<div id=\"g-recaptcha-error\"></div>', '{\"site_key\":{\"title\":\"Site Key\",\"value\":\"6LdPC88fAAAAADQlUf_DV6Hrvgm-pZuLJFSLDOWV\"},\"secret_key\":{\"title\":\"Secret Key\",\"value\":\"6LdPC88fAAAAAG5SVaRYDnV2NpCrptLg2XLYKRKB\"}}', 'recaptcha.png', 0, '2019-10-18 11:16:05', '2023-01-14 22:28:49'),
(3, 'custom-captcha', 'Custom Captcha', 'Just put any random string', 'customcaptcha.png', NULL, '{\"random_key\":{\"title\":\"Random String\",\"value\":\"SecureString\"}}', 'na', 0, '2019-10-18 11:16:05', '2023-01-14 22:28:46');

CREATE TABLE `{{prefix}}buildecom_forms` (
  `id` bigint(20) UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `act` varchar(40) COLLATE utf8_unicode_520_ci DEFAULT NULL,
  `form_data` text COLLATE utf8_unicode_520_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_520_ci;

CREATE TABLE `{{prefix}}buildecom_device_tokens` (
  `id` int(11)  PRIMARY KEY AUTO_INCREMENT NOT NULL,
  `user_id` int(11) NOT NULL,
  `device_token` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `{{prefix}}buildecom_banners` (
  `id` bigint(20) PRIMARY KEY AUTO_INCREMENT NOT NULL,
  `title` varchar(255) NOT NULL,
  `position` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=> top|2=>middle|3=>bottom',
  `banner_type` tinyint(1) NOT NULL COMMENT '1=> category|0=>product',
  `category_id` int(20) NOT NULL,
  `category_data` text DEFAULT NULL,
  `banner_category_id` int(20) NOT NULL,
  `product_id` int(20) NOT NULL,
  `product_data` text DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=> enable|0=>disable',
  `image` varchar(255) COLLATE utf8_unicode_520_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `{{prefix}}buildecom_categories` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `status` smallint(1) NOT NULL DEFAULT 1 COMMENT '0 = inactive| 1 = active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
)ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `{{prefix}}buildecom_testimonials` (
  `id` bigint(20) PRIMARY KEY AUTO_INCREMENT NOT NULL,
  `image` varchar(255) COLLATE utf8_unicode_520_ci DEFAULT NULL,
  `full_name` varchar(255) NOT NULL,
  `designation` varchar(255) NOT NULL,
  `review` text DEFAULT NULL,
  `review_rating` int(20) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=> enable|0=>disable',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `{{prefix}}buildecom_order_statuses` (
 `id` bigint(20) PRIMARY KEY AUTO_INCREMENT NOT NULL,
  `status_slug` varchar(255) NOT NULL,
  `status_label` varchar(255) NOT NULL,
  `status_color` varchar(255) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=enable|0=disable',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `{{prefix}}buildecom_notification_templates` (
  `id` bigint(20)  PRIMARY KEY AUTO_INCREMENT NOT NULL,
  `act` varchar(40) COLLATE utf8_unicode_520_ci DEFAULT NULL,
  `name` varchar(40) COLLATE utf8_unicode_520_ci DEFAULT NULL,
  `subj` varchar(255) COLLATE utf8_unicode_520_ci DEFAULT NULL,
  `shortcodes` text COLLATE utf8_unicode_520_ci DEFAULT NULL,
  `firebase_status` tinyint(1) NOT NULL DEFAULT 1,
  `firebase_body` text COLLATE utf8_unicode_520_ci DEFAULT  NULL,
  `plugin_name` varchar(255) COLLATE utf8_unicode_520_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_520_ci;


INSERT INTO `{{prefix}}buildecom_notification_templates` (`id`, `act`, `name`, `subj`, `shortcodes`, `firebase_status`, `firebase_body`, `plugin_name`, `created_at`, `updated_at`) VALUES
(1, 'DEFAULT', 'Default Template', 'A notification from', '{\"subject\":\"Subject\",\"message\":\"Message\"}', 0, 'This is a message', 'default', '2019-09-13 13:14:22', '2021-11-03 09:38:55'),
(2, 'WC_PROCESSING', 'Woocommece Order Processing', 'Order Processing', '{\"status\":\"Order status\", \"currency\":\"Currency of the site\",\"shipping_tax\":\"Shipping tax\", \"cart_tax\":\"Cart tax\",\"total\":\"Order total\", \"total_tax\":\"Total tax\",\"order_key\":\"Order unique key\",\"billing_first_name\":\"Biller first name\", \"billing_last_name\":\"Biller last name\",\"billing_company\":\"Biller company name\",\"billing_address_1\":\"Biller first address\",\"billing_address_2\":\"Biller second address\",\"billing_city\":\"Biller city\",\"billing_state\":\"Biller state\",\"billing_postcode\":\"Biller post code\",\"billing_country\":\"Biller country\",\"billing_email\":\"Biller email\",\"billing_phone\":\"Biller phone\", \"shipping_first_name\":\"Shipper first name\",\"shipping_last_name\":\"Shipper last name\",\"shipping_company\":\"Shipper company name\",\"shipping_address_1\":\"Shipper first address\", \"shipping_address_2\":\"Shipper second address\",\"shipping_city\":\"Shipper city\", \"shipping_state\":\"Shipper state\",\"shipping_postcode\":\"Shipper postcode\",\"shipping_country\":\"Shipper country\",\"shipping_phone\":\"Shipper phone\",\"payment_method\":\"Payment method name\", \"payment_method_title\":\"Order payment title\",\"transaction_id\":\"Transaction ID\", \"date_paid\":\"Paid date\"}', 1, 'Your order is processing now.\r\nwith tax: {{shipping_tax}}', 'woocommerce', '2019-09-13 13:14:22', '2021-11-03 09:38:55'),
(3, 'WC_PENDING', 'Woocommerce Pending', 'Order Pending', '{\"status\":\"Order status\", \"currency\":\"Currency of the site\",\"shipping_tax\":\"Shipping tax\", \"cart_tax\":\"Cart tax\",\"total\":\"Order total\", \"total_tax\":\"Total tax\",\"order_key\":\"Order unique key\",\"billing_first_name\":\"Biller first name\", \"billing_last_name\":\"Biller last name\",\"billing_company\":\"Biller company name\",\"billing_address_1\":\"Biller first address\",\"billing_address_2\":\"Biller second address\",\"billing_city\":\"Biller city\",\"billing_state\":\"Biller state\",\"billing_postcode\":\"Biller post code\",\"billing_country\":\"Biller country\",\"billing_email\":\"Biller email\",\"billing_phone\":\"Biller phone\", \"shipping_first_name\":\"Shipper first name\",\"shipping_last_name\":\"Shipper last name\",\"shipping_company\":\"Shipper company name\",\"shipping_address_1\":\"Shipper first address\", \"shipping_address_2\":\"Shipper second address\",\"shipping_city\":\"Shipper city\", \"shipping_state\":\"Shipper state\",\"shipping_postcode\":\"Shipper postcode\",\"shipping_country\":\"Shipper country\",\"shipping_phone\":\"Shipper phone\",\"payment_method\":\"Payment method name\", \"payment_method_title\":\"Order payment title\",\"transaction_id\":\"Transaction ID\", \"date_paid\":\"Paid date\"}', 1, 'Order is pending', 'woocommerce', '2019-09-13 13:14:22', '2021-11-03 09:38:55'),
(4, 'WC_SHIPPED', 'Woocommerce Shipped', 'Order Shpipped', '{\"status\":\"Order status\", \"currency\":\"Currency of the site\",\"shipping_tax\":\"Shipping tax\", \"cart_tax\":\"Cart tax\",\"total\":\"Order total\", \"total_tax\":\"Total tax\",\"order_key\":\"Order unique key\",\"billing_first_name\":\"Biller first name\", \"billing_last_name\":\"Biller last name\",\"billing_company\":\"Biller company name\",\"billing_address_1\":\"Biller first address\",\"billing_address_2\":\"Biller second address\",\"billing_city\":\"Biller city\",\"billing_state\":\"Biller state\",\"billing_postcode\":\"Biller post code\",\"billing_country\":\"Biller country\",\"billing_email\":\"Biller email\",\"billing_phone\":\"Biller phone\", \"shipping_first_name\":\"Shipper first name\",\"shipping_last_name\":\"Shipper last name\",\"shipping_company\":\"Shipper company name\",\"shipping_address_1\":\"Shipper first address\", \"shipping_address_2\":\"Shipper second address\",\"shipping_city\":\"Shipper city\", \"shipping_state\":\"Shipper state\",\"shipping_postcode\":\"Shipper postcode\",\"shipping_country\":\"Shipper country\",\"shipping_phone\":\"Shipper phone\",\"payment_method\":\"Payment method name\", \"payment_method_title\":\"Order payment title\",\"transaction_id\":\"Transaction ID\", \"date_paid\":\"Paid date\"}', 1, 'Order has been shipped', 'woocommerce', '2019-09-13 13:14:22', '2021-11-03 09:38:55'),
(5, 'WC_ONHOLD', 'Woocommerce On Hold', 'Order On-hold', '{\"status\":\"Order status\", \"currency\":\"Currency of the site\",\"shipping_tax\":\"Shipping tax\", \"cart_tax\":\"Cart tax\",\"total\":\"Order total\", \"total_tax\":\"Total tax\",\"order_key\":\"Order unique key\",\"billing_first_name\":\"Biller first name\", \"billing_last_name\":\"Biller last name\",\"billing_company\":\"Biller company name\",\"billing_address_1\":\"Biller first address\",\"billing_address_2\":\"Biller second address\",\"billing_city\":\"Biller city\",\"billing_state\":\"Biller state\",\"billing_postcode\":\"Biller post code\",\"billing_country\":\"Biller country\",\"billing_email\":\"Biller email\",\"billing_phone\":\"Biller phone\", \"shipping_first_name\":\"Shipper first name\",\"shipping_last_name\":\"Shipper last name\",\"shipping_company\":\"Shipper company name\",\"shipping_address_1\":\"Shipper first address\", \"shipping_address_2\":\"Shipper second address\",\"shipping_city\":\"Shipper city\", \"shipping_state\":\"Shipper state\",\"shipping_postcode\":\"Shipper postcode\",\"shipping_country\":\"Shipper country\",\"shipping_phone\":\"Shipper phone\",\"payment_method\":\"Payment method name\", \"payment_method_title\":\"Order payment title\",\"transaction_id\":\"Transaction ID\", \"date_paid\":\"Paid date\"}', 1, 'Order is on-hold', 'woocommerce', '2019-09-13 13:14:22', '2021-11-03 09:38:55'),
(6, 'WC_CANCELLED', 'Woocommerce Cancelled', 'Order Cancelled', '{\"status\":\"Order status\", \"currency\":\"Currency of the site\",\"shipping_tax\":\"Shipping tax\", \"cart_tax\":\"Cart tax\",\"total\":\"Order total\", \"total_tax\":\"Total tax\",\"order_key\":\"Order unique key\",\"billing_first_name\":\"Biller first name\", \"billing_last_name\":\"Biller last name\",\"billing_company\":\"Biller company name\",\"billing_address_1\":\"Biller first address\",\"billing_address_2\":\"Biller second address\",\"billing_city\":\"Biller city\",\"billing_state\":\"Biller state\",\"billing_postcode\":\"Biller post code\",\"billing_country\":\"Biller country\",\"billing_email\":\"Biller email\",\"billing_phone\":\"Biller phone\", \"shipping_first_name\":\"Shipper first name\",\"shipping_last_name\":\"Shipper last name\",\"shipping_company\":\"Shipper company name\",\"shipping_address_1\":\"Shipper first address\", \"shipping_address_2\":\"Shipper second address\",\"shipping_city\":\"Shipper city\", \"shipping_state\":\"Shipper state\",\"shipping_postcode\":\"Shipper postcode\",\"shipping_country\":\"Shipper country\",\"shipping_phone\":\"Shipper phone\",\"payment_method\":\"Payment method name\", \"payment_method_title\":\"Order payment title\",\"transaction_id\":\"Transaction ID\", \"date_paid\":\"Paid date\"}', 1, 'Your order has been cancelled by {{site_name}}', 'woocommerce', '2019-09-13 13:14:22', '2021-11-03 09:38:55'),
(7, 'WC_REFUNDED', 'Woocommerce Refunded', 'Refunded', '{\"status\":\"Order status\", \"currency\":\"Currency of the site\",\"shipping_tax\":\"Shipping tax\", \"cart_tax\":\"Cart tax\",\"total\":\"Order total\", \"total_tax\":\"Total tax\",\"order_key\":\"Order unique key\",\"billing_first_name\":\"Biller first name\", \"billing_last_name\":\"Biller last name\",\"billing_company\":\"Biller company name\",\"billing_address_1\":\"Biller first address\",\"billing_address_2\":\"Biller second address\",\"billing_city\":\"Biller city\",\"billing_state\":\"Biller state\",\"billing_postcode\":\"Biller post code\",\"billing_country\":\"Biller country\",\"billing_email\":\"Biller email\",\"billing_phone\":\"Biller phone\", \"shipping_first_name\":\"Shipper first name\",\"shipping_last_name\":\"Shipper last name\",\"shipping_company\":\"Shipper company name\",\"shipping_address_1\":\"Shipper first address\", \"shipping_address_2\":\"Shipper second address\",\"shipping_city\":\"Shipper city\", \"shipping_state\":\"Shipper state\",\"shipping_postcode\":\"Shipper postcode\",\"shipping_country\":\"Shipper country\",\"shipping_phone\":\"Shipper phone\",\"payment_method\":\"Payment method name\", \"payment_method_title\":\"Order payment title\",\"transaction_id\":\"Transaction ID\", \"date_paid\":\"Paid date\"}', 1, 'Order has been refunded', 'woocommerce', '2019-09-13 13:14:22', '2021-11-03 09:38:55'),
(8, 'WC_FAILED', 'Woocommerce Failed', 'Order failed', '{\"status\":\"Order status\", \"currency\":\"Currency of the site\",\"shipping_tax\":\"Shipping tax\", \"cart_tax\":\"Cart tax\",\"total\":\"Order total\", \"total_tax\":\"Total tax\",\"order_key\":\"Order unique key\",\"billing_first_name\":\"Biller first name\", \"billing_last_name\":\"Biller last name\",\"billing_company\":\"Biller company name\",\"billing_address_1\":\"Biller first address\",\"billing_address_2\":\"Biller second address\",\"billing_city\":\"Biller city\",\"billing_state\":\"Biller state\",\"billing_postcode\":\"Biller post code\",\"billing_country\":\"Biller country\",\"billing_email\":\"Biller email\",\"billing_phone\":\"Biller phone\", \"shipping_first_name\":\"Shipper first name\",\"shipping_last_name\":\"Shipper last name\",\"shipping_company\":\"Shipper company name\",\"shipping_address_1\":\"Shipper first address\", \"shipping_address_2\":\"Shipper second address\",\"shipping_city\":\"Shipper city\", \"shipping_state\":\"Shipper state\",\"shipping_postcode\":\"Shipper postcode\",\"shipping_country\":\"Shipper country\",\"shipping_phone\":\"Shipper phone\",\"payment_method\":\"Payment method name\", \"payment_method_title\":\"Order payment title\",\"transaction_id\":\"Transaction ID\", \"date_paid\":\"Paid date\"}', 1, 'Your order has been failed', 'woocommerce', '2019-09-13 13:14:22', '2021-11-03 09:38:55'),
(9, 'WC_COMPLETED', 'Woocommerce Completed', 'Order Completed', '{\"status\":\"Order status\", \"currency\":\"Currency of the site\",\"shipping_tax\":\"Shipping tax\", \"cart_tax\":\"Cart tax\",\"total\":\"Order total\", \"total_tax\":\"Total tax\",\"order_key\":\"Order unique key\",\"billing_first_name\":\"Biller first name\", \"billing_last_name\":\"Biller last name\",\"billing_company\":\"Biller company name\",\"billing_address_1\":\"Biller first address\",\"billing_address_2\":\"Biller second address\",\"billing_city\":\"Biller city\",\"billing_state\":\"Biller state\",\"billing_postcode\":\"Biller post code\",\"billing_country\":\"Biller country\",\"billing_email\":\"Biller email\",\"billing_phone\":\"Biller phone\", \"shipping_first_name\":\"Shipper first name\",\"shipping_last_name\":\"Shipper last name\",\"shipping_company\":\"Shipper company name\",\"shipping_address_1\":\"Shipper first address\", \"shipping_address_2\":\"Shipper second address\",\"shipping_city\":\"Shipper city\", \"shipping_state\":\"Shipper state\",\"shipping_postcode\":\"Shipper postcode\",\"shipping_country\":\"Shipper country\",\"shipping_phone\":\"Shipper phone\",\"payment_method\":\"Payment method name\", \"payment_method_title\":\"Order payment title\",\"transaction_id\":\"Transaction ID\", \"date_paid\":\"Paid date\"}', 1, 'Order has been completed successfully.', 'woocommerce', '2019-09-13 13:14:22', '2021-11-03 09:38:55'),
(10, 'WC_PAYMENT_COMPLETED', 'Woocommerce Payment Complete', 'Payment Completed', '{\"status\":\"Order status\", \"currency\":\"Currency of the site\",\"shipping_tax\":\"Shipping tax\", \"cart_tax\":\"Cart tax\",\"total\":\"Order total\", \"total_tax\":\"Total tax\",\"order_key\":\"Order unique key\",\"billing_first_name\":\"Biller first name\", \"billing_last_name\":\"Biller last name\",\"billing_company\":\"Biller company name\",\"billing_address_1\":\"Biller first address\",\"billing_address_2\":\"Biller second address\",\"billing_city\":\"Biller city\",\"billing_state\":\"Biller state\",\"billing_postcode\":\"Biller post code\",\"billing_country\":\"Biller country\",\"billing_email\":\"Biller email\",\"billing_phone\":\"Biller phone\", \"shipping_first_name\":\"Shipper first name\",\"shipping_last_name\":\"Shipper last name\",\"shipping_company\":\"Shipper company name\",\"shipping_address_1\":\"Shipper first address\", \"shipping_address_2\":\"Shipper second address\",\"shipping_city\":\"Shipper city\", \"shipping_state\":\"Shipper state\",\"shipping_postcode\":\"Shipper postcode\",\"shipping_country\":\"Shipper country\",\"shipping_phone\":\"Shipper phone\",\"payment_method\":\"Payment method name\", \"payment_method_title\":\"Order payment title\",\"transaction_id\":\"Transaction ID\", \"date_paid\":\"Paid date\"}', 1, 'Payment has been completed', 'woocommerce', '2019-09-13 13:14:22', '2021-11-03 09:38:55'),
(11, 'WC_NEWCUSTOMER', 'Woocommerce New customer', 'Welcome to Our Store', '{\"subject\":\"Registration\",\"message\":\"Thank you for registering with us!\"}', 1, 'Thank you for registering with us!', 'woocommerce', '2019-09-13 13:14:22', '2021-11-03 09:38:55'),
(12, 'WC_ORDER_CHECKOUT_PROCESS', 'Woocommerce Checkout order process', 'Thank you for your order!', '{\"status\":\"Order status\", \"currency\":\"Currency of the site\",\"shipping_tax\":\"Shipping tax\", \"cart_tax\":\"Cart tax\",\"total\":\"Order total\", \"total_tax\":\"Total tax\",\"order_key\":\"Order unique key\",\"billing_first_name\":\"Biller first name\", \"billing_last_name\":\"Biller last name\",\"billing_company\":\"Biller company name\",\"billing_address_1\":\"Biller first address\",\"billing_address_2\":\"Biller second address\",\"billing_city\":\"Biller city\",\"billing_state\":\"Biller state\",\"billing_postcode\":\"Biller post code\",\"billing_country\":\"Biller country\",\"billing_email\":\"Biller email\",\"billing_phone\":\"Biller phone\", \"shipping_first_name\":\"Shipper first name\",\"shipping_last_name\":\"Shipper last name\",\"shipping_company\":\"Shipper company name\",\"shipping_address_1\":\"Shipper first address\", \"shipping_address_2\":\"Shipper second address\",\"shipping_city\":\"Shipper city\", \"shipping_state\":\"Shipper state\",\"shipping_postcode\":\"Shipper postcode\",\"shipping_country\":\"Shipper country\",\"shipping_phone\":\"Shipper phone\",\"payment_method\":\"Payment method name\", \"payment_method_title\":\"Order payment title\",\"transaction_id\":\"Transaction ID\", \"date_paid\":\"Paid date\"}', 1, 'Your order has been successfully processed.\r\nBy: {{site_name}}\r\nFrom : {{billing_city}}', 'woocommerce', '2019-09-13 13:14:22', '2021-11-03 09:38:55');

