<?php
if (!defined('ABSPATH')) exit;

if (!class_exists('WP_List_Table')) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

class Buildecom_Banners_Table extends WP_List_Table
{
    private $banners;

    public function __construct()
    {
        parent::__construct([
            'singular' => 'banner',
            'plural'   => 'banners',
            'ajax'     => false
        ]);
    }

    public function prepare_items()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'buildecom_banners';

        $this->banners = $wpdb->get_results("SELECT * FROM $table_name", ARRAY_A);

        $columns  = $this->get_columns();
        $hidden   = [];
        $sortable = [];

        $this->_column_headers = [$columns, $hidden, $sortable];

        $this->items = $this->banners;
    }

    public function get_columns()
    {
        return [
            'cb'       => '<input type="checkbox" />',
            'title'    => 'Title', 
            'status'   => 'Status',
            'actions'  => 'Actions'
        ];
    }

    public function column_cb($item)
    {
        return sprintf(
            '<input type="checkbox" name="banner_ids[]" value="%s" />',
            $item['id']
        );
    }

    public function column_position($item)
    {
        if ($item['position'] == 1) return __('Top', 'buildecom');
        if ($item['position'] == 2) return __('Middle', 'buildecom');
        if ($item['position'] == 3) return __('Bottom', 'buildecom');
    }

    public function column_actions($item)
    {
        $edit_url = add_query_arg([
            'page'   => 'buildecom-banners',
            'action' => 'edit',
            'id'     => $item['id']
        ], admin_url('admin.php'));

        $toggle_status = $item['status'] ? 0 : 1;
        $status_label = $item['status'] ? __('Disable', 'buildecom') : __('Enable', 'buildecom');

        $toggle_url = wp_nonce_url(
            add_query_arg([
                'page'   => 'buildecom-banners',
                'action' => 'toggle_status',
                'id'     => $item['id'],
                'status' => $toggle_status
            ], admin_url('admin.php')),
            'buildecom_banner_action'
        );

        $delete_url = wp_nonce_url(
            add_query_arg([
                'page'   => 'buildecom-banners',
                'action' => 'delete',
                'id'     => $item['id']
            ], admin_url('admin.php')),
            'buildecom_banner_action'
        );

        return sprintf(
            '<a href="%s" class="btn btn-primary btn-sm me-1">Edit</a>
            <a href="%s" class="btn btn-danger btn-sm me-1" onclick="return confirm(\'Are you sure you want to delete?\')">Delete</a>
            <a href="%s" class="btn btn-%s btn-sm">%s</a>',
            esc_url($edit_url),
            esc_url($delete_url),
            esc_url($toggle_url),
            $item['status'] ? 'warning' : 'success',
            esc_html($status_label)
        );
    }


    public function column_status($item)
    {
        return $item['status'] ? '<span class="badge text-bg-success">Enabled</span>' : '<span class="badge text-bg-danger">Disabled</span>';
    }

    public function column_default($item, $column_name)
    {
        return $item[$column_name] ?? '';
    }

    public function get_bulk_actions()
    {
        return [
            'delete_banner_bulk' => __('Delete', 'buildecom')
        ];
    }

    public function process_bulk_action()
    {
        if ($this->current_action() == 'delete_banner_bulk') {
            $banner_ids = !empty($_POST['banner_ids']) ? array_map('intval', $_POST['banner_ids']) : [];

            foreach ($banner_ids as $id) {
                global $wpdb;
                $wpdb->delete($wpdb->prefix . 'buildecom_banners', ['id' => $id]);
            }

            $redirect_url = add_query_arg([
                'page' => 'buildecom-banners',
                'message' => urlencode('Selected banners deleted.')
            ], admin_url('admin.php'));

            wp_safe_redirect($redirect_url);
            exit;
        }
    }
}
