<?php

if (!defined('ABSPATH')) exit;

function buildecom_render_home()
{
    global $wpdb;

    $total_banners = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}buildecom_banners");

    $total_testimonials = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}buildecom_testimonials");
?>
    <div class="wrap">
        <h1><?php echo esc_html__('BuildEcom Dashboard', 'buildecom'); ?></h1>

        <div class="buildecom-dashboard-cards">
            <!-- Banners Card -->
            <div class="buildecom-card">
                <span class="dashicons dashicons-format-image"></span>
                <h2><?php echo esc_html__('Total Banners', 'buildecom'); ?></h2>
                <div class="count"><?php echo esc_html($total_banners); ?></div>
                <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-banners')); ?>" class="button button-primary"><?php echo esc_html__('View Banners', 'buildecom'); ?></a>
            </div>

            <!-- Testimonials Card -->
            <div class="buildecom-card">
                <span class="dashicons dashicons-testimonial"></span>
                <h2><?php echo esc_html__('Total Testimonials', 'buildecom'); ?></h2>
                <div class="count"><?php echo esc_html($total_testimonials); ?></div>
                <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-testimonials')); ?>" class="button button-primary"><?php echo esc_html__('View Testimonials', 'buildecom'); ?></a>
            </div>

            <!-- Example extra card -->
            <div class="buildecom-card">
                <span class="dashicons dashicons-admin-generic"></span>
                <h2><?php echo esc_html__('Settings', 'buildecom'); ?></h2>
                <div style="flex-grow:1;"></div>
                <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-setting')); ?>" class="button"><?php echo esc_html__('Go to Settings', 'buildecom'); ?></a>
            </div>

        </div>
    </div>
<?php
}
