jQuery(function ($) {
    $('.modal-btn').on('click', function () {
        const listModal = $('.list-modal');
        const modalInstance = new bootstrap.Modal(document.querySelector('.list-modal'));
        modalInstance.show();

        $('#sortable-statuses li').each(function () {
            let statusKey = $(this).attr('data-status');
            statusKey = statusKey.toLowerCase().replace(/\s+/g, "-");
            $(`#${statusKey}--id`).prop('checked', true);
        });
    });

    $('.modal-footer .btn-primary').on('click', function () {
        let selectedStatuses = [];

        $('.list-modal input[type="checkbox"]:checked').each(function () {
            selectedStatuses.push($(this).attr('id').replace('--id', ''));
        });

        $('#sortable-statuses li').each(function () {
            const statusKey = $(this).attr('data-status');
            if (selectedStatuses.indexOf(statusKey) === -1) {
                $(this).remove();
            }
        });

        selectedStatuses.forEach(function (statusKey) {
            if ($('#sortable-statuses li[data-status="' + statusKey + '"]').length === 0) {
                const statusName = $(`#${statusKey}--id`).siblings('span').text();

                $('#sortable-statuses').append(
                    `<li class="ui-state-default status-state" data-status="${statusKey}">
                        <span class="dashicons dashicons-move"></span> ${statusName}
                        <input type="hidden" name="order[]" value="${statusName}">
                    </li>`
                );
            }
        });

        const modalInstance = bootstrap.Modal.getInstance(document.querySelector('.list-modal'));
        modalInstance.hide();
    });

    $('#sortable-statuses').sortable({
        update: function (event, ui) {
            $('#sortable-statuses li').each(function () {
                var statusKey = $(this).attr('data-status');
                $(this).find('input[name="order[]"]').val(statusKey);
            });
        }
    });

    $('#sortable-statuses').disableSelection();
});