(function ($) {
	'use strict';

	function btaialge_updateAltField(id, value) {
													// Update text in ALT attribute.
		var el = document.getElementById( id );
		if (el) {
			el.value = value;
			el.dispatchEvent( new Event( 'input', { bubbles: true } ) );
			el.dispatchEvent( new Event( 'change', { bubbles: true } ) );
			if (window.jQuery) {
				$( el ).trigger( 'input' ).trigger( 'change' ).trigger( 'keyup' );
			}
		}
	}

	function btaialge_append_btn($elem, post_id, align) {
											// Append button to generate ALT-Text with AI.
		var infoText = '';
		var disabled = '';

		if (btaialge.hasApiKey) {
			infoText += '<br><span id="btaialge-msg" class="btaialge-msg" style="text-align:' + align + ';">';
			infoText += btaialge.texts.overwrite_notice;
			infoText += '</span>';
		} else {
			disabled  = ' disabled ';
			infoText += '<br><span id="btaialge-msg" class="btaialge-msg" style="text-align:' + align + ';"><strong>';
			infoText += btaialge.texts.api_key_notice + ' ';
			infoText += '<a href="' + btaialge.settingsUrl + '">' + btaialge.texts.settings + '</a>';
			infoText += '</strong></span>';
		}

		$elem.append(
			'<div class="btaialge-wrapper">' +
			'<button type="button" class="button button-secondary" id="btaialge-gen-btn" data-id="' + post_id + '" ' + disabled + '>' +
			btaialge.texts.btn_label +
			'</button>' +
			infoText +
			'</div>'
		);
	}

	function btaialge_alt_text_found() {
															// ALT attribute in media library found.

		$( '#attachment-details-alt-text, #attachment_alt, .attachment-alt-text, .alt-text, .attachment-details-alt-text' ).first().each(
			function () {
				var $container = $( this );
				var align      = 'left';
				var post_id    = null;

				if ($container.find( '#btaialge-gen-btn' ).length === 0) {
					if ($container.find( '#attachment-details-two-column-alt-text' ).length) {
						align = 'right'; }

					if (document.getElementById( 'post_ID' )) {
						post_id = document.getElementById( 'post_ID' ).value;
					}

					if ( ! post_id) {
						post_id = $container.closest( '[data-id]' ).attr( 'data-id' );
					}

					if ( ! post_id && typeof _wpMediaGridSettings !== 'undefined' && _wpMediaGridSettings.queryVars && _wpMediaGridSettings.queryVars.item) {
						post_id = _wpMediaGridSettings.queryVars.item;
					}

					if ($( '#attachment-details-alt-text' ).length > 0) {
						var $sidebar = $( '.media-sidebar' );
						if ($sidebar.length) {

							var $editLink = $sidebar.find( '.attachment-info a.edit-attachment' );
							var href      = $editLink.attr( 'href' );

							if (href) {
								var match = href.match( /post=(\d+)/ );
								if (match && match[1]) {
									post_id = match[1];
									align   = 'right';
								}
							}
						}
					}

					if (post_id) {
						btaialge_append_btn( $container, post_id, align );
					}
				}
			}
		);
	}

	var observer = new MutationObserver(
		function (mutations) {
										// Mutation Observer for the media library.
			mutations.forEach(
				function (mutation) {
					if (mutation.addedNodes.length && $( '.attachment-alt-text, .alt-text' ).length > 0) {
						btaialge_alt_text_found();
					}
				}
			);
		}
	);
	observer.observe( document.body, { childList: true, subtree: true } );

	if (typeof wp !== 'undefined' && wp.data && typeof wp.data.subscribe === 'function') {          // Gutenberg editor.
		wp.data.subscribe(
			function () {
				var selectedBlock = wp.data.select( 'core/block-editor' ).getSelectedBlock();
				if (selectedBlock && selectedBlock.name === 'core/image') {
					setTimeout(
						function () {
							var $altField = $( '.components-base-control:contains("' + btaialge.texts.alt_text + '")' ).find( 'textarea, input' );
							if ($altField.length > 0) {
								var $wrapper = $altField.closest( '.components-base-control' );
								if ($wrapper.find( '#btaialge-gen-btn' ).length === 0) {
									btaialge_append_btn( $wrapper, selectedBlock.attributes.id, 'left' );
								}
								$wrapper.find( '#btaialge-gen-btn' ).attr( 'data-id', selectedBlock.attributes.id );
							}
						},
						100
					);
				}
			}
		);
	}

	$( document ).on(
		'click',
		'#btaialge-gen-btn',
		function () {
			var $btn    = $( this );
			var post_id = $btn.attr( 'data-id' );
			var $msg    = $btn.parent().find( '#btaialge-msg' );

			$msg.html( btaialge.texts.wait );
			$btn.prop( 'disabled', true );

			$.ajax(
				{
					url: btaialge.ajax_url,
					type: 'POST',
					data: {
						action: 'btaialge_generate_alt',
						post_id: post_id,
						btaialge_nonce: btaialge.nonce
					},
					success: function (response) {
						if (response.success) {

							btaialge_updateAltField( 'attachment_alt', response.data );                       // Update ALT text in media library.
							btaialge_updateAltField( 'attachment-details-alt-text', response.data );
							btaialge_updateAltField( 'attachment-details-two-column-alt-text', response.data );

																									// Update ALT text in Gutenberg editor
							var $altField = $( '.components-base-control:contains("' + btaialge.texts.alt_text + '")' ).find( 'textarea, input' );
							if ($altField.length > 0) {
								$altField.val( response.data );
								$altField[0].dispatchEvent( new Event( 'input', { bubbles: true } ) );

								if (window.wp && wp.data) {
									var selectedBlock = wp.data.select( 'core/block-editor' ).getSelectedBlock();
									if (selectedBlock && selectedBlock.name === 'core/image') {
										wp.data.dispatch( 'core/block-editor' ).updateBlockAttributes(
											selectedBlock.clientId,
											{
												alt: response.data
											}
										);
									}
								}
							}
							$msg.text( btaialge.texts.success );
						} else {
							$msg.html( btaialge.texts.error + ': ' + response.data );
						}
						$btn.prop( 'disabled', false );
					},
					error: function () {
						$msg.text( btaialge.texts.error );
						$btn.prop( 'disabled', false );
					}
				}
			);
		}
	);

})( jQuery );