# Brizy - Page Builder

Contributors: themefuse<br>
Requires at least: 4.5<br>
Tested up to: 6.9<br>
Requires PHP: 7.2.24<br>
Stable tag: 2.7.21<br>
License: GPLv3<br>
License URI: https://www.gnu.org/licenses/gpl-3.0.html

A page builder that is fast & easy, Brizy is a next-gen website builder that anyone can use. No designer or developer
skills required. Once you go Brizy, nothing else feels easy!

More details on: https://brizy.io

## Description

https://vimeo.com/263343966

A page builder that is fast & easy, [Brizy](https://brizy.io/) is a next-gen website builder that anyone can use. No
designer or developer skills required. Once you go Brizy, nothing else feels easy!

## Highlights

### Smart & clutter free

Most page builder crowd all the options for a specific element in remote sidebars, making it hard to focus on the task
at hand. Our website builder shows only what's needed, front & centre, close to the element you are editing.

### Intuitive Drag & Drop

Moving content elements, columns or rows is a breeze with our intuitive Drag & Drop feature. Just grab and drag them to
the desired position and everything will instantly fall into place.

### Page Builder Design Elements

Text, buttons, images, icons, video, maps and many more are ready to help you create your page design in a snap.

### Over 500 pre-made blocks

Expertly crafted with conversions in mind, the Brizy website builder design kit is a collection of 500+ blocks that will
enable you to create websites in minutes.

### Over 4000 icons included

Available in both Outline and Glyph versions, even the most demanding icon needs are covered. Quickly find the icons
you're after by filtering through categories or searching by keywords.

### Undo / Redo

Don't worry if you make a mistake or delete something that you shouldn't have. With Undo you can get everything back.

### Global styling

Ever wanted to change all the similar colors in your web page with a single click? With Brizy page builder, you can! Not
only that, but you can change all texts that share the same properties in one go, as well.

### Mobile Friendly

Switch instantly to Mobile View mode, where you can make changes that will only apply to these type of devices. This
gives you the power to differentiate your page design and optimise for smaller screens.

### Cloud auto-save

The progress you're making while building your page is always backed up in the cloud, so you'll never lose your work.

### Liked Brizy?

- Join our [Facebook Group](https://www.facebook.com/groups/brizy).

## Bug reports

We strive to make Brizy to be awesome and user friendly, though sometimes it's impossible to avoid bugs.
A bug means "something is broken" or is not working as it should.

In order to offer you an effective support and fix for an issue, please follow the below guidelines before submitting a
bug report:

#### Explore Known Issues

Has your issue already been reported? Check the [Issues page](https://github.com/ThemeFuse/Brizy/issues).

If your issue has already been reported, great! It will be reviewed in an upcoming release.

#### Submitting a Bug Report

You can report the issue via [Issues page](https://github.com/ThemeFuse/Brizy/issues).
A good bug report includes full details to easily understand the issue you are having and the exact steps to reproduce
if it is a bug.

## Installation

### Minimum Requirements

* WordPress 4.5 or greater
* PHP version 5.4 or greater
* MySQL version 5.0 or greater

### We recommend your host supports:

* PHP version 7.0 or greater
* MySQL version 5.6 or grDeclared $is_allowed_for_current_usereater
* WP Memory limit of 64 MB or greater (128 MB or higher is preferred)

### Installation

1. Install using the WordPress built-in Plugin installer, or Extract the zip file and drop the contents in
   the `wp-content/plugins/` directory of your WordPress installation.
2. Activate the plugin through the 'Plugins' menu in WordPress.
3. Go to Pages > Add New
4. Press the 'Edit with Brizy' button.

### How to integration in your plugin

Do not use the html from post_content.
That content is updated only to support some seo plugins.

To correctly get the compiled post html use the code below:

```
$post    = Brizy_Editor_Post::get( $post_id );
$html = new Brizy_Editor_CompiledHtml( $post->get_compiled_html() );

// the <head> content
// the $headHtml contains all the assets the page needs
$headHtml = apply_filters( 'brizy_content', $html->get_head(), Brizy_Editor_Project::get(), $post->getWpPost() );

// the <body> content
$bodyHtml = apply_filters( 'brizy_content', $html->get_body(), Brizy_Editor_Project::get(), $post->getWpPost() );
```

### Terms of Service

[Terms of use](https://brizy.io/terms/)
[Privacy policy](https://brizy.io/privacy/)

## Changelog

### 2.7.21 - 2025-12-18
* Fixed: Text copy and paste shows editable text in preview

### 2.7.20 - 2025-12-15
* New:  Translations now add country codes to image alt text
* New:  Form agreement checkbox option
* New:  Column element includes a max-height option
* New:  Block kits selection issue resolved
* Fixed:  Tabs toolbar no longer opens incorrect tabs
* Fixed:  RichText slider options no longer trigger infinite re-render
* Fixed:  Page compilation error resolved
* Fixed:  Video element default link now works correctly
* Fixed:  Global style font changes now apply correctly in preview
* Improved:  Lazy loading added for preview.pro.min.css
* Improved:  Builder upgraded to the latest Redux version
* Improved:  State management migrated from Recoil to Valtio
* Improved:  ESLint and related dependencies updated
* Improved:  Testing Library React dependencies updated
* Improved:  Editor now uses an internal scrollbar instead of react-custom-scrollbars

### 2.7.19 - 2025-12-03
* Fixed: Richtext does not works correctly for emails


### 2.7.18 - 2025-12-01

* Improved: Input Text - retains its value when the toolbar is closed instantly
* Improved: Removed old JavaScript code for cleaner performance
* Fixed: Rich-Text - added static className support for background image blots
* Fixed: Rich-Text - dynamic content for third-party integrations now replaces correctly
* Fixed: Rich-Text - image mask restored for third-party instances
* Fixed: Rich-Text - preview now shows latest edits for third-party use
* Fixed: Rich-Text - links now work properly in third-party preview
* Fixed: Media Library - select menu now opens correctly
* Fixed: Addable - improved third-party compatibility and behavior
* Fixed: Icons - outline icons display correctly in the editor
* Fixed: Box Shadow - blur 0 now applies properly
* Fixed: Tabs - toolbar now opens the correct tab

### 2.7.17 - 2025-11-10

* New: Navigator component
* Fixed: Flatten families object before getCopiedValue processing
* Fixed: Empty button link appends '#' at the end
* Fixed: Icon prompt not loading icons on first render
* Improved: Audio added possibility to hide custom audio via config
* Improved: Placeholder loading performance
* Improved: Builder code refactoring — moved all from redux/selectors.js to new selector-new.ts and renamed selector-new

### 2.7.16 - 2025-10-21

* New: Counter - added “fix value” option for better number control
* New: Context Menu - improved copy/paste styling on Firefox
* New: Section - introduced CSS variable for full-height sections
* New: Typography - improved custom-style handling
* Fixed: Story - widget sizes preserved when pasting styles
* Fixed: Story - custom attributes now work correctly
* Fixed: Typography - toolbar now applies default font style properly
* Fixed: Row - “show on device” visibility works correctly
* Fixed: Link - absolute URLs keep their original link format

### 2.7.15 - 2025-09-30

* New: Rich-Text - added tags support for dynamic content
* New: Rich-Text - toolbar now toggles automatically while typing
* New: Forms - dynamic IDs for checkboxes and radio fields
* New: Third-Party - new toolbar placement option
* Fixed: Colors - updated Brizy UI version to resolve styling issues

### 2.7.14 - 2025-09-04

* New: Links - phone numbers and email addresses now automatically prepend tel: and mailto:
* New: Image - option to enable/disable lazy loading
* New: Rich-Text - toolbar now opens directly next to the selected text
* New: Webhooks - display name shown instead of full URL
* New: Posts - placeholder added when no content is available
* New: Conditions - improved selection for global block conditions
* Fixed: Global Blocks - updating a global block no longer causes infinite loading
* Fixed: Context Menu - no empty context menu appears for the first container inside a popup
* Fixed: Section - elements are correctly added inside Section Slider (fade mode)

### 2.7.13 - 2025-09-01

* Fixed: Security enhancements

### 2.7.12 - 2025-08-26

* New: Rich-Text - tooltip option added
* New: Update Button - hover color now white for better visibility
* New: Section - hotkeys for faster block actions
* Fixed: Jenkins - workspace now cleaned after each build, tags publish correctly
* Fixed: Links - smooth scroll behavior
* Fixed: Links - “rel” attribute now includes 'noreferrer' for blank pages
* Fixed: Links - block linking now works correctly
* Fixed: reCAPTCHA - z-index styles corrected
* Fixed: Controls (Select2) - popper now renders correctly
* Fixed: Form - submit button no longer “jumps” on hover
* Fixed: Form - select field in Mega Menu works correctly in editor
* Fixed: Button - alignment Fixed when using hover animations
* Fixed: Editor - padding removed between content and scrollbar in tablet/mobile view
* Fixed: Visual - file upload from 'ElementModel' always returns a model
* Fixed: Context Menu - now closes properly in Firefox
* Fixed: Screenshots - block screenshot ID updates when backend provides New ID
* Fixed: Publish Button - no more infinite loading when saving a draft
* Fixed: Global Blocks - link redirects to global blocks work correctly
* Fixed: Background - overlay now works on responsive devices even if opacity is 0 on desktop
* Fixed: Animated Headline - text no longer wraps into multiple rows incorrectly
* Fixed: Section - global blocks are no longer duplicated
* Fixed: Rich-Text - tooltip retrieves dynamic CSS correctly in preview
* Fixed: Compiler - missing sections in preview now render properly
* Improved: Image element converted to TypeScript for better stability and maintainability

### 2.7.11 - 2025-08-18

* Fixed: Readme file typos

### 2.7.10 - 2025-08-18

* Fixed: The links to the global block do not always work.

### 2.7.9 - 2025-08-18

* Fixed: The links to the global block do not always work.

### 2.7.8 - 2025-08-14

* Fixed: global block name in anchor link is not showed
* Fixed: CORS error for custom icons

### 2.7.7 - 2025-08-11

* Fixed: Compiler editor version

### 2.7.6 - 2025-08-11

* Fixed: Compiler editor version

### 2.7.5 - 2025-08-11

* New: Tooltip option for Icon, Button and Image elements
* New: Role and ARIA-hidden attributes for Icon element (accessibility improvement)
* New: Focus indicators for buttons, links and form items (accessibility improvement)
* New: Captions support for video and audio elements
* New: Title display for uploaded audio tracks
* New: Stop-animation option for Carousel and Section Slider
* New: Multi-step form - set custom width for navigation buttons
* New: Form validation errors for empty fields and invalid emails
* New: Added a third-party container for integrations
* New: Context menu now closes reliably after use
* New: White Label - “Brizy” name is hidden in exported block/layout JSON files
* Improved: Video element height handling
* Improved: Image element - better width/height calculation
* Improved: Image element - smoother re-render process
* Improved: Pass media configuration to browser compiler
* Improved: Added utility function to get image source for third-party components
* Improved: Select dropdown positioning
* Improved: Widget positioning in accessibility mode
* Improved: Rich-text - consistent “em” font size in dynamic content
* Improved: Split some visual editor components into editor/preview files for faster loading, plus cleaned up imports
* Fixed: CSS - styleBgColorHex now works correctly with palette colours
* Fixed: Form - fields now receive focus correctly
* Fixed: Internal Link - search now finds items correctly
* Fixed: Sections - smoother scrolling between sections in Blocksy theme
* Fixed: Row - reverse columns option works as expected
* Fixed: Image links now update correctly when moving a staging site to production

### 2.7.4 - 2025-07-23

* Fixed: reverse column
* Fixed: popup trigger once condition

### 2.7.3 - 2025-07-18

* Fixed: html sanitize on compile page

### 2.7.2 - 2025-07-17

* Fixed: Removed redundant cache invalidation

### 2.7.1 - 2025-07-16

* Fixed: Missing global blocks

### 2.7.0 - 2025-07-15

* New: Animated Headline element for attention‑grabbing text
* New: AlphaModal component replaces deprecated defaults
* New: Column element gains full RTL support
* New: Icon element now has an ARIA‑LABEL field for better accessibility
* New: Fonts upload is handled by the faster API client
* New: Context menu closes reliably after use
* New: First‑Block Adder height refined for cleaner layouts
* Improved: Compiled Sections - pages are rendered server‑side for faster load times
* Improved: Rich‑Text toolbar - bold, italic and underline work consistently
* Improved: Visual settings can now be adjusted via add/apply filters
* Improved: Sidebar alignment and other UI optimisations
* Improved: Colour palette and UI contrast tweaks
* Improved: User‑role handling inside the builder
* Improved: Global‑typography CSS output is leaner
* Improved: Transition CSS de‑duplicated to avoid repeats
* Improved: CSS generator works faster on large pages
* Improved: Smaller compiler bundle and section‑level runtime compilation
* Improved: Deep context‑menu trees load more quickly
* Fixed: Conditional Display - no more slow‑downs on sites with a large user base when the rule checks the logged‑in
  user
* Fixed: Button - hover fill effect not working
* Fixed: Button - fill effect not working for hover (duplicate issue resolved)
* Fixed: Button - box resizer wrong position in Story mode
* Fixed: Builder - chartType selector is stable
* Fixed: Builder - global theme CSS variables load correctly
* Fixed: Left Sidebar - collapsed‑category state is saved
* Fixed: Left Sidebar (RTL) - layout displays correctly
* Fixed: Rich‑Text - @ address sign renders correctly
* Fixed: Rich‑Text - opacity values below 1 apply
* Fixed: Section - duplicate display‑style values removed
* Fixed: Section - background video plays only on active slide
* Fixed: RTL - dropdowns and selects display properly
* Fixed: RTL - prompt dialogs align correctly
* Fixed: RTL - menu dropdowns support RTL
* Fixed: RTL - overall UI layout no longer breaks
* Fixed: Colours - UI palette improvements
* Fixed: Right Sidebar - separator now inherits theme colour
* Fixed: Editor - no more crashes on archive pages
* Fixed: Form - select field uses correct font size with Blocksy theme
* Fixed: Menu - free menu works in editor mode
* Fixed: Build Environment - added develop branch for WP Free
* Fixed: Toolbar - section‑header toolbar no longer hidden behind menus
* Fixed: Animated Headline - loop‑off option previews correctly
* Fixed: Internal Link - alignment options now respected
* Fixed: Visual - config via filter applies correctly
* Fixed: Roles - user permission fixes applied
* Fixed: Colours - additional UI colour tweaks
* Fixed: Visual - sidebar alignment & minor optimisations
* Fixed: Fonts - upload process via API client stable
* Fixed: First‑Block Adder - height calculation fixed
* Fixed: Context Menu - closes properly on exit

### 2.6.22 - 2025-06-10

* Improved: Enhanced performance for image resizing.

### 2.6.21 - 2025-05-28

* Fixed: Check if the current user can "list_users" on Posts component

### 2.6.20 - 2025-05-28

* Fixed: Removed all user sensitive info from user list endpoint

### 2.6.19 - 2025-05-26

* Fixed: Image UID validation

### 2.6.18 - 2025-05-13

* New: Add a hover image to the Image element
* New: Image titles now show up in the preview
* Improved: Leaner HTML for buttons, icons, rows, columns and sections
* Improved: Better right-to-left (RTL) editing
* Fixed: Dynamic and hover background images display correctly
* Fixed: Button hover colors save as expected
* Fixed: Progress bars without a percentage preview properly
* Fixed: Button text no longer gets cut off on small screens
* Fixed: Style copy-and-paste works on tablet and mobile
* Fixed: Rich-text option list works in Story mode
* Fixed: No more crashes when adding a new font
* Fixed: Variable-font weight tab shows correctly
* Fixed: Context menu appears on responsive views
* Fixed: Parallax effect no longer conflicts with other plugins

### 2.6.17 - 2025-04-23

* Fixed: Force page recompilation

### 2.6.16 - 2025-04-22

* Fixed: Internal page links

### 2.6.15 - 2025-04-17

* Fixed: Not all weights in Fonts tab for Adobe Fonts

### 2.6.14 - 2025-03-20

* Fixed: Squirrly SEO plugin compatibility

### 2.6.13 - 2025-03-13

* Fixed: Elements not displayed in preview
* Fixed: User with Editor role cannot edit page

### 2.6.12 - 2025-02-25

* Improved: 3rd party API
* Improved: Compiler Bundle Size
* Updated: Removed icons from blocks
* Fixed: Bug with Menu failing to open when clicked multiple times
* Fixed: Parallax animation in preview with open popup
* Fixed: Scroll on parallax in Safari
* Fixed: Mixed content error when Brizy is installed on subfolder
* Fixed: Deleting images on Media Gallery

### 2.6.11 - 2025-02-18

* Fixed: Gallery with layout justify

### 2.6.10 - 2025-02-11

* Fixed: SVG attachment creation
* Fixed: added a security fix on API endpoint

### 2.6.9 - 2025-01-30

* Fixed: Image upload
* Fixed: Importing starter template erases code snippet
* Fixed: Global block code gets added to SEO description
* Fixed: Images are not responsive
* Fixed: Blurry Image

### 2.6.8 - 2025-01-16

* Fixed: Bug with the html escape in preview

### 2.6.7 - 2025-01-15

* Fixed: Increased the minimum compiler version

### 2.6.6 - 2025-01-15

* Fixed: Image side load

### 2.6.4 - 2024-12-17

* Fixed: Incorrect style of Tabs element in table and mobile
* Fixed: Icon Box is not displayed correctly in preview

### 2.6.3 - 2024-11-19

* Fixed: SQL query using wrong prefixes

### 2.6.2 - 2024-11-18

* Fixed: Simplify the check if compilation is required

### 2.6.1 - 2024-11-15

* Fixed: Invalidate cached image URLs after site migration.

### 2.6.0 - 2024-11-12

* New: Added video "URL" option for the Playlist element
* New: Added "Blending Mode" styling option for the Image element
* New: Ability to add multi-line text in one Buttons
* New: Add mask on Video
* New:: Added decimal sizes for VW, EM, and REM font size option
* Fixed: Publish button not available on private pages
* Fixed: When scrolling to a block, consider the height of the menu
* Fixed: Global block renaming
* Fixed: Paralax effect
* Fixed: Download saved blocks and layouts on Firefox
* Fixed: Some WP templates broke the view in Editor
* Fixed: Translate Press switcher is not displayed correctly
* Fixed: Images loading in editor
* Fixed: Warnings displayed on Brizy pages
* Improved: Color Hex code input
* Updated: Brizy-ui library

### 2.5.9 - 2024-10-21

* Fixed: CSS styles in Hamburger Menu
* Fixed: File upload extension issues
* Fixed: Image links pointing incorrectly
* Improved: Page, Popup and Global Blocks dependencies

### 2.5.8 - 2024-09-19

* Fixed: Anchor link with dynamic ID placeholder
* Fixed: Missing Icon for help video
* Fixed: Global typography - Missing generate method in config

### 2.5.7 - 2024-09-18

* Fixed: Astra Pro compatibility issue

### 2.5.6 - 2024-09-18

* Fixed:  Simplified the method that obtain the attachment by UID

### 2.5.5 - 2024-09-17

* Fixed:  Simplified the method that obtain the attachment by UID

### 2.5.4 - 2024-09-17

* New: Hover animations for Buttons
* New: Paypal element
* New: Slideshow option for Section
* New: Text transform options for typography
* New: Subscript and superscript for Text element
* New: Background color option for Video element
* New: Background video for responsive modes for Section, Row and Column
* New: Regenerate Global styles with AI
* New: Ability to pin elements in left sidebar
* Improved: Ability to copy and paste effects and animations
* Improved: Box resizer restrictions for Map
* Improved: Removed "To dashboard" button
* Improved: After upload, Image element by default has original size
* Improved: Increase width of column resizer bar
* Improved: Tollbar options code base and migrate Map, Line and Video to new CSS generator
* Improved: Center "Styling" and "Effects" toolbar buttons:
* Fixed: Disabled zoom option for Section,Row and Column for respondive modes:* Fixed: Background video error after
  cloning the container
  element:
* Fixed: Text selection opacity if mask/gradinent is set
* Fixed: Box resizer in responsive modes for all elements
* Fixed: Copya and paste styles for responsive modes
* Fixed: Bullet list alignment in Text element
* Fixed: Text formatting after clear in Story
* Fixed: Button size with default fill type
* Fixed: Size of typography text decoration icons
* Fixed: Background color does not remove on clear formatting on Text element
* Fixed: Paste style of font style in Text element
* Fixed: Section slider content snaps after slider load
* Fixed: Slider block hover arrow color
* Fixed: Slider block remains active after deleting
* Fixed: Close dropdown of internal link after selection
* Fixed: Compilation error
* Fixed: Excerpt recursion when using Brizy posts in post loops
* Fixed: Global block rule matching

### 2.5.3 - 2024-08-16

* Fixed: Send the form nonce on submit when the user is authenticated

### 2.5.2 - 2024-08-01

* Fixed: Assets not loading on subfolder WordPress instances

### 2.5.1 - 2024-07-26

* Fixed: Icons not loading on subfolder WordPress instances
* Fixed: 404 templates not displaying correctly
* Fixed: Restored backward compatibility support for Astra
* Fixed: reCAPTCHA issues for current users
* Fixed: Page content visibility in wp-admin when editing pages

### 2.5.0 - 2024-07-22

* New: HTML Compilation process for major page-loading improvements
* Fixed: Copy-Paste Styles for Text Element when using selected text
* Fixed: Various vulnerabilities
* Fixed: Global Styles not saving current state in some instances
* Fixed: Text multi-select with gradients bug
* Fixed: Section background displaying incorrect option
* Improved: Uploading images in WEBP format
* Improved: Moved Form element from FREE to PRO
* Improved: Added rich-text formatting clearance
* Improved: Reload the preview tab if already open instead of new tab
* Updated: Builder developer dependencies

### 2.4.45 - 2024-07-05

* Fixed: small fixes in how the uploaded files are hnadled

### 2.4.44 - 2024-05-14

* Fixed: Fixed vulnerabilities reported by Worldfence

### 2.4.43 - 2024-03-26

* Fixed: dynamic content
* FIxed: Embed element is not working

### 2.4.42 - 2024-03-20

* Fixed: Drag and drop functionality not working outside the visible viewport
* Fixed: Copy and Paste for Text element with color gradient
* Fixed: Selecting all text via shortcut then writing does not show new texts
* Fixed: Text element with selection for text-transform
* Fixed: Mask for Text element when using Dynamic Image not working
* Fixed: Screenshots for blocks inside Reorder sidebar
* Fixed: Global Typography in responsive viewports
* Fixed: Text element broken error
* Improved: Added fade option for Carousel element and Slider option in blocks
* Improved: Added 'Open in new tab' option for internal page links
* Improved: Added Underline for links on hover
* Improved: Changed UI for Dynamic population option
* Improved: Text element performance with color change

### 2.4.41 - 2024-02-13

* Fixed: Text color from hex when we have the type transparent
* Fixed: Text Copy and Paste
* Fixed: Added image content validator on import blocks
* Fixed: Directory Traversal on screenshot update

### 2.4.40 - 2024-02-07

* New: Help video functionality inside the builder
* New: Added variable fonts
* New: Text highlight color
* Improved: Custom Attributes position in the right sidebar
* Improved: Include Global Style when saving layouts
* Improved: Toolbar options arrow position on Rows
* Improved: Extract React from editor build, and add this as standalone script in HTML
* Improved: Disable shorten/extend actions for AI text in some cases
* Improved: Drag and drop for Icons and Buttons
* Improved: Tabs UI colors in right sidebar
* Fixed: Progress bar comes out of the wrapper
* Fixed: Text Link option pasted value doesn't save if instantly closing toolbar
* Fixed: Video player won't extend on mobile on IOS
* Fixed: Form Select arrow
* Fixed: Column align when Effects are enabled
* Fixed: Writing long texts in Form fields
* Fixed: Video element crashed when imported with a block
* Fixed: Column alignment doesn't work on Auto distribute option
* Fixed: Toolbar css issue when searching a Collection Type name
* Fixed: Copy Styles don't apply for Dynamic Content Rich Text
* Fixed: Background button and icon hover color didn't match preview
* Fixed: Video background for blocks and columns unable to pause

### 2.4.39 - 2024-01-17

* New: Add Right Click Context Menu to Tabs Element
* New: Added tooltip message when saving draft pages
* Improved: Speed when searching pages URL for Links
* Improved: Reduced file size of the Client API
* Improved: UI Translation
* Fixed: Link To option loses focus
* Fixed: Icon Background corner is not active
* Fixed: Save selected Page in Link option on any Text element
* Fixed: Scroll in toolbar and typography is not working when parallax effect is set
* Fixed: Some Saved Blocks thumbnails are not displayed
* Fixed: Styling Dividers Show thin line on some mobile devices
* Fixed: Background color on hover "Get a pro Plan" button
* Fixed: Drag & Drop for Posts, Accordion Tab elements
* Fixed: Drag & Drop Lines remain active randomly
* Fixed: Padding bottom for Video with Cover Image

### 2.4.38 - 2023-12-28

* Fixed: Small layout fixes in templates

### 2.4.37 - 2023-12-28

* New: Added 16 new templates.

### 2.4.36 - 2023-12-19

* New: Added corner radius styling for tabs in Tab Element
* New: Added ability to filter by keywords in the element panel
* New: Added ability to delete, duplicate all buttons or icons at once
* Improved: Added additional styling for the dynamic placeholder in Text elements
* Improved: Localisation strings for Icons tab
* Improved: Localisation strings for Audio element
* Improved: Localisation strings for Video element
* Improved: Localisation strings for Accordion element
* Improved: Localisation strings for Accordion tags
* Improved: Localisation strings for Block option translation
* Improved: Localisation strings for Form element
* Improved: Localisation strings for "View as" option in left sidebar
* Improved: Localisation for Right Sidebar
* Improved: Localisation for Posts element
* Improved: Localisation for Blocks popup
* Improved: Localisation for Counter element
* Improved: Localisation for Text
* Improved: Localisation for Right Sidebar effects
* Improved: Localisation for Shortcuts popup
* Improved: Hide longer title options in UI with elipse
* Fixed: Unable to delete title in Saved Blocks and Layouts
* Fixed: Youtube Shorts in Video element
* Fixed: Hover effects break column dimensions
* Fixed: Show explicit error messages when import saved blocks
* Fixed: Fix the JSON data before sending to compiler

### 2.4.35 - 2023-12-07

* Improved: Reduce text generation time

### 2.4.34 - 2023-12-05

* Fixed: Lightbox option on images is not working on frontend
* Fixed: Accordion icon size issue on front end

### 2.4.33 - 2023-12-01

* Fixed: Buttons width in preview
* Fixed: Overlay was visible under gradient color

### 2.4.32 - 2023-11-29

* New: Use system default fonts instead of Google or custom fonts
* Improved: Reduce icons size
* Improved: Save form checkbox value in preview
* Improved: Move "Show on Desktop" icon under the Basic tab in the right sidebar
* Improved: Delete dynamic content inside Text in one backspace
* Improved: Optimised code output for the Accordion element
* Improved: Optimised code output for the Tabs element
* Improved: Optimised code output for the Icon element
* Improved: Optimised code output for the Button element
* Improved: Reduced ID length in HTML attributes
* Improved: Removed "data-uid" and "name" attributes from section in preview
* Improved: Integrations API new data output format
* Fixed: Drag image with link
* Fixed: Icon sizes values in the Icon element
* Fixed: Dynamic content text color in preview
* Fixed: Sound of video with cover image plays twice
* Fixed: Custom video loop not working
* Fixed: Copy and Paste styles for hover overlay
* Fixed: Return empty for placeholders that are working with WooCommerce functions

### 2.4.31 - 2023-11-08

* Fixed: Malformed attribute selector data-brz-popup
* Fixed: Order By feature in Posts and Archive element is not displayed

### 2.4.30 - 2023-11-06

* New: Added title and tags for global blocks
* New: Added delete option for form integrations
* Improved: Brizy UI Library in Editor
* Improved: Added notification for outdated Safari browser (version 16.3 and below)
* Improved: Styling option for the Button element in responsive
* Improved: Removed Effects from the Text element in responsive
* Improved: Various option toolbars where the title of the label is too long
* Improved: Added scroll navigation to active element when device mode changes
* Improved: Added GET, POST for Form webhooks
* Improved: Prefixed all data-attributes
* Improved: Added width in PX for the Row element
* Improved: Removed the terms & conditions checkbox from authorization form
* Improved: Sidebar device mode titles
* Improved: Google Fonts updated to the latest version
* Fixed: HTML tags being removed from the Embed element
* Fixed: Autoplay for video background in block slider
* Fixed: Line element does not align if hover is set
* Fixed: Random Google Fonts were not displayed in the preview
* Fixed: Word break does not work correctly in the Alert element
* Fixed: Background video on block slider does not resize correctly
* Fixed: Updated Twitter icon to X
* Fixed: Hide background preview for popups
* Fixed: XSS vulnerability to Text Editor
* Fixed: Accordion tags not working correctly in preview
* Fixed: Version checking for zip files when moving blocks or layouts from WP to Cloud
* Fixed: Setup config data for help videos inside the builder
* Fixed: Added permission to download svg files
* Fixed: Default template display in preview
* Fixed: Jump to the second block by link
* Fixed: Sites give a 500 Error when Brizy Free is updated to latest version on WordPress.com
* Fixed: Gutenberg opens in iframe and the edit with brizy button is not displayed

### 2.4.29 - 2023-10-20

* Fixed: Login element error when try to register

### 2.4.28 - 2023-10-11

* New: Added Internal Link on the link option for all elements
* Improved: Removed getPage request added pageData inside config
* Improved: Sections container width was changed in 1170px
* Improved: Changed icon for the Webhooks integration on forms
* Improved: Removed the ability to change icons in responsive views for the icon element
* Improved: Button width for default fill type
* Improved: Rename Tags titles in Saved blocks
* Improved: Rearrange Global typography styles
* Improved: Responsive views change automatically when you select the devices in global typography styling
* Fixed: Text color picker on dynamic elements
* Fixed: Hover on certain elements that have motion effects set
* Fixed: Drag and Drop was not working on images with link
* Fixed: Lightbox preview
* Fixed: Toolbars label text length
* Fixed: Dynamic text with gradient color was not visible
* Fixed: Hover animation not working for the same item after sliding
* Fixed: Column content align when scroll animation is applied
* Fixed: Text space for ordered and unordered lists
* Fixed: The accordion element disappears after deleting tags
* Fixed: Opacity for Gradient color does not work correctly
* Fixed: Button Spacing incorrectly affects position and alignment
* Fixed: Global styling not changing
* Fixed: Audio element is still playing after the pop-up is closed
* Fixes: Global colors for Image shadow
* Fixes: Global colors for Image border
* Fixed: Tab and Accordion elements heading get hidden under Sticky/Fixed menu on mobiles

### 2.4.27 - 2023-08-08

* New: Added 26 new premade design templates

### 2.4.26 - 2023-07-12

* New: Added custom video URL for Block background
* New: Added copy/paste styles for Text element
* New: Added mask option for all containers: Rows, Columns, Blocks
* Improved: Display selected font at top of font list in the Typography options
* Improved: Hexagon Shape in the Mask options
* Improved: Updated icons library Font Awesome to version 6
* Fixed: Text crashed after population change
* Fixed: Block Slider on preview
* Fixed: Element with rotate motion effect moves when hovering on toolbar
* Fixed: Text alignment in the preview
* Fixed: Remove saved block tag
* Fixed: Label text pushing the options out of the UI
* Fixed: Container width in PX shows 1400px max slider value instead of 1170px

### 2.4.25 - 2023-07-03

* Fixed: Hot Fix - Redirect only in admin after activation of the plugin

### 2.4.24 - 2023-06-26

* Fixed: Scrollbar inside Popup

### 2.4.23 - 2023-06-22

* Fixed: Image sizes on the preview
* Fixed: Section Parallax
* Fixed: Section containers

### 2.4.22 - 2023-06-21

* New: Added option to sort tags alphabetically in the Accordion element
* New: Added vertical space option for Accordion element
* New: Add width in px for the boxed option on Blocks
* New: Tags and Titles for saved blocks and saved layouts
* Fixed: Builder UI Themes
* Fixed: W3C Accessibility issues: AA, AAA, W3C
* Fixed: Countdown timezone offset
* Fixed: Numbering unordered list in Text element
* Fixed: Image Alt Title option in Right Sidebar
* Fixed: Scroll for code Mirror in Right Sidebar
* Improved: Full width for WordPress Media gallery in tablet and mobile mode
* Improved: Codebase migrate to node 18
* Improved: Changed some elements positions and order in the elements panel
* Improved: Builder select option
* Improved: Added a helper icon for YouTube links in the Video element
* Improved: Omit 1 request for get project

### 2.4.21 - 2023-06-07

* Fixed: Button style fill
* Fixed: IconBox with hover effect

### 2.4.20 - 2023-06-01

* Fixed: Image resize on preview
* Fixed: Uploaded webp Image

### 2.4.19 - 2023-05-31

* New: Advanced Hover animation
* Improved: Button old options to new options
* Improved: Removed title attribute from HTML for the block slider .svg arrows
* Improved: Remove icon on global style in the left sidebar
* Improved: Added IST timezone in the Countdown element
* Improved: Youtube video in the Video element
* Improved: Made all UI scrollbars custom
* Improved: Added .min suffix for all css and js minified files
* Updated: Codemirror plugins
* Updated: Core-js library
* Fixed: Added support to escaping singe and double quotes
* Fixed: Link anchor is not working on the correct block if you scroll
* Fixed: Screenshots browser compatibility on Safari when saving blocks
* Fixed: Link option in a Row element
* Fixed: Escape backslashes in the form data json before inserting in the post content
* New: Added a Getting Started Page for easier onboarding
* New: Added left sidebar config (module groups in config)
* Fixed: Append text via parser by CSS class only
* Fixed: Click twice or more to close a pop-up
* Fixed: Starter template import
* Fixed: Remove the sufix from version compare when importing from archives
* Fixed: Restore WP revisions

### 2.4.18 - 2023-04-03

* Fixed: onclick Custom Attribute RightSidebar
* Fixed: Responsive brackground map
* Fixed: Reorder column - option
* Fixed: Background overflow && z-index auto
* Fixed: Tabs text on responsiveMode
* Fixed: Opacity for language switcher drop-down
* Fixed: Form input length validation
* Fixed: Flash on hover transition bg gradient
* Fixed: Text link
* Fixed: Global Style Colorpicker
* Fixed: Element Tabs icon
* Fixed: Form Email input length
* Fixed: Text with Mask
* Fixed: Option file upload remove
* Fixed: Resolve CSS conflicts with woo commerce products
* Fixed: Added dom encoding to utf-8
* Improved: ImageUpload canceling
* Improved: Countdown new timezone
* Improved: LeftSidebar Bottom panel
* Improved: Video Element options
* Improved: Text font size option increased to 200
* Improved: Multiline for Custom Attribute
* Updated: Slick Slider

### 2.4.17 - 2023-03-10

* Fixed: Screenshots
* Fixed: Section Background Image

### 2.4.16 - 2023-03-07

* New: New eye dropper feature for colors
* New: Preparations for future UI color themes
* Improved: Minified CSS in HTML
* Improved: Editor strings improvements
* Improved: Added Pro visual cues for PRO options inside the builder
* Fixed: Value for Form checkbox was sent in lead even if empty
* Fixed: Background Vimeo video is getting zoomed in preview mode
* Fixed: Right Sidebar advanced settings for icons and buttons
* Fixed: Losing global styling in Text element after refresh
* Fixed: Text on top of custom video is pushed under the video in preview
* Fixed: Made it more clear what video formats can be added for custom video URLs
* Fixed: Removed black strip on the top of the custom video
* Fixed: Broken Links checker is reporting incorrect image URLs
* Fixed: Compatibility with php 8.1
* Fixed: Conflicts with SiteGround Optimizer
* Fixed: The possibility to disable our meta tag viewport, viewport meta tag was duplicated in some cases
* Fixed: The disappearance of texts in the editor when TranslatePress is enabled

### 2.4.15 - 2023-01-31

* Fixed: Menu hamburger - items link on responsive mode

### 2.4.13 - 2022-11-17

* New: Added styles and more options for the Line element
* New: Added paddings for Counter, Embed, Video, Map, Audio & Countdown elements
* New: Added Mask option for the Image element
* New: Video element new options: Lazy Load, Privacy Mode, Suggested Videos, Muted
* Improved: Borders moved from toolbar to sidebar
* Improved: Color works under CSS variables in Text CSS classes
* Fixed: Column width changed when you click the column resize handle
* Fixed: Hover styles for Update toolbar icons
* Fixed: Border global color on Tabs
* Fixed: Hover styles on icons from Effects
* Fixed: Right Click on Row element
* Fixed: Added new rule matches for current page

### 2.4.11 - 2022-10-12

* Fixed: Images URL

### 2.4.10 - 2022-10-11

* Fixed: Using SVGs in Image element
* Fixed: Image URLs when using Sync
* Fixed: Fonts when missing fontFamilyType
* Improved: Prefetch for Bunny Fonts
* Improved: Rename Base category to Essentials in element panel
* Improved: Grid elements moved to the top in the element panel

### 2.4.9 - 2022-10-03

* Fixed: Global Blocks rules for the Archive template

### 2.4.8 - 2022-09-28

* Fixed: The crash when the WooComerce plugin is disabled.

### 2.4.7 - 2022-09-28

* Improved: Get fonts from https://fonts.bunny.net instead of https://fonts.googleapis.com to address GDPR font issues
* Improved: Saved blocks pagination 50 blocks
* Improved: Deleting request when you delete saved block or saved layout
* Improved: Removed Math.random for security
* Fixed: Map - popup is not closed when the cover on map is clicked
* Fixed: Parallax in responsive mode
* Fixed: Menu element - Icon size option
* Fixed: Product Archive template shows posts instead of products
* Fixed: Wp Optimize plugin compatibility

### 2.4.6 - 2022-09-17

* New: Infinite animation option
* New: Added select All option for custom post types in Global blocks conditions
* Fixed: Lag when you select colors in Global styles
* Fixed: Added from category display condition for global blocks
* Fixed: Made mouse pointer when you hover the color option on block dividers
* Fixed: Undo and Redo in Text element
* Fixed: Empty column crash on Editor role
* Fixed: Mute video when you set the cover option in Video element
* Fixed: Divider on Section
* Fixed: Parallax in responsive views
* Fixed: Enable update button on undo or redo
* Fixed: Diacritics are converted to unicode characters
* Fixed: Image crashing when clicking the resize pointers
* Fixed: Counter style 2-3-4 in Story
* Fixed: Countdown height in Story
* Fixed: Form submit button in Story
* Fixed: Button border in Story
* Fixed: Accordion - border-radius on tags
* Fixed: Tabs - Title in responsive views
* Fixed: Carousel - Working with text breaks the carousel
* Fixed: Fast scroll on Blocks that have Parallax option on
* Improved: UI improvement to accommodate long text translation
* Improved: Minify global typography CSS variables
* Improved: Root window referrer request
* Improved: Color picker gradient issues
* Improved: LeftSidebar icon position in dropdown menu
* Improved: Added First Name and Last Name in Authorization form with Cloud when you save blocks layouts

### 2.4.5 - 2022-08-30

* Fixed: Mute on video with cover
* Fixed: Recaptcha keys not saving in the contact form

### 2.4.4 - 2022-08-16

* Fixed: Copy/Paste RichText
* Fixed: Global Style LetterSpacing

### 2.4.3 - 2022-07-20

* New: New Templates

### 2.4.2 - 2022-06-15

* Fixed: Template Conditions
* Fixed: Polylang fix home url in breadcrumbs
* Fixed: Remove logs for cropping images
* Fixed: Escape the script contents for non adminstrators users. This vulnerability was discovered by Vishnupriya Ilango
  of Fortinets FortiGuard Labs
* Fixed: Fix autoupdate of the pro version, added an admin notice in the plugins list page when a major update is
  available

### 2.4.1 - 2022-06-02

* Improved: Saved blocks lazy load
* Improved: Performance on columns drag and drop
* Improved: Performance on videos and images resize
* Improved: Performance on column resize
* Improved: Section padding resize
* Fixed: Column issue when is inside a Tab element
* Fixed: Featured image on columns hover did not inherit image from normal state
* Fixed: The right sidebar on Tab element was messed up
* Fixed: Endless spinning on the Video element
* Fixed: Block margin in px and %
* Fixed: Block border radius on color hover
* Fixed: YouTube header script
* Fixed: Do not render PRO elements in preview
* Fixed: Added controls option for Vimeo videos

### 2.4.0 - 2022-05-18

* New: Counter width changing the location in color section of toolbar
* New: Possibility to add URL for video like .mp4 URLs
* New: Added block bg. options: auto, contain, cover and bg. repeat
* New: More options for SoundCloud
* New: Added background map and video for columns
* New: Added Overlay color for image
* New: Added example for Shortcode element
* New: Added reorder option for columns
* New: Added new line styles
* New: RichText Matching HTML tag with typography font style
* New: Added new align option for column, auto and custom height
* New: Created possibility to change default font
* New: Added order to tabs
* New: Section Added slider reorder
* New: Counter added text shadow
* New: Added Form reorder option
* New: Add New Block Divider
* New: Added Accordion Title padding
* New: Added reorder option to accordion
* New: Moved entrance animation effects functionality in right sidebar
* New: Added vh and em suffixes to Spacer
* New: Add new style blending mode for certain elements
* New: Added Column width option
* New: Added status badge in the block display conditions popup
* New: Added support for placeholders in email templates
* Improved: Added new shortcut Ctrl+M opens Styling right panel
* Improved: Added new shortcut Ctrl + K opens Effects right panel
* Improved: All options in the builder were refactored
* Improved: Publish Update button state
* Improved: Added input value change on scroll
* Improved: Toolbar option for shortcode element
* Improved: Added additional animation styles for tabs and accordions
* Improved: Added new icon for breadcrumbs
* Improved: Added Autoplay and loop for Youtube and Vimeo
* Improved: Removed separator option for Counter types Empty and Pie
* Improved: Can change name for All tag in Accordion element
* Improved: Reply-to user email placeholder for contact forms
* Improved: More settings icon alignment
* Improved: Added typography value boundaries
* Improved: Added loading icon when importing a Layout
* Improved: Enabled swipe option for slider
* Improved: Working with code in Embed element
* Improved: Opacity value for colors is displayed on hover
* Improved: Tabs hover transition
* Fixed: Sidebar update for Switcher, Table, Tabs
* Fixed: The scale option for Rating appears only for desktop view
* Fixed: Counter suffix option when working with dynamic values
* Fixed: Filters Hover for certain elements
* Fixed: Rename size to width for Map element
* Fixed: Overlay option for Images appears only for desktop view
* Fixed: Countdown redirect label
* Fixed: Accordion item head align and css
* Fixed: Responsive slider dots option with a lot of slides
* Fixed: Outline border when resizing an element from the resize dots
* Fixed: Remove Products from single template type
* Fixed: Added option to allow json file upload
* Fixed: Fixed placeholder strip on post save.
* Fixed: Cast rule values to int on serialization
* Fixed: Refactor post_type to postType in editor config
* Fixed: Show Products post type in global block rules
* Fixed: Send post_term_parents as an array not object when the array is not empty
* Fixed: Added additional data about the post in editor config.
* Fixed: Return all global block ignoring the status
* Fixed: Added post_status in brizy_get_posts actions
* Fixed: Change the Pages group name to Main Content in template rule form

### 2.3.37 - 2022-05-05

* Fixed: Section dividers on Firefox
* Fixed: Tab background color on mobile responsive view
* Fixed: Unexpected token h in JSON at position 0 error when saving a layout

### 2.3.36 - 2022-05-03

* Improved: Improved performance when you have a lot of columns on the page
* Improved: Improved performance when you change global styling
* Improved: Improved performance when you copy paste styles
* Fixed: Mouse cursor when hovering the UI on the left sidebar
* Fixed: Moved layout Ekstra to PRO
* Fixed: Import Blocks button in Safari
* Fixed: Buttons conflicts with GTM

### 2.3.35 - 2022-04-21

* Fixed: Text blink
* Fixed: Section Dividers

### 2.3.34 - 2022-04-20

* New: Added hover Transition for elements: Accordion, ProgressBar and Tabs
* New: Added cover image option for the Map element
* Fixed: Cover images not displaying in Playlist element
* Fixed: YouTube loop when you set start-end options
* Fixed: Changed size for Image option upload field
* Fixed: Text element blinks when changing align options
* Fixed: Layout Carwash was changed to PRO
* Fixed: Layout Scooter Rental was changed to PRO
* Fixed: Active border size for element Tabs
* Fixed: Style 3 for Tabs element
* Fixed: Center align option for arrows in the Accordion element
* Fixed: Cover image repeat issue
* New: Auto install for Brizy Starter Templates
* Fixed: Fixed attachment post type exclusion
* Fixed: Remove attachment post type from post type list from editor config
* Fixed: Lost global colour styling
* Fixed: Include inline JS scripts depending on their priority
* Fixed: Preventing directory traversal on get icon

### 2.3.33 - 2022-03-10

* New: Import and Export Saved Blocks, Popups, Layouts
* New: Show progress on story when autoplay is on
* Improved: Increased the number of history snapshots from 10 to 20. Happy Ctrl-Z-ing
* Improved: SEO for Video element
* Improved: Plugin Cross-Site Scripting
* Fixed: Link to slide in Web Stories
* Fixed: Undo and redo in Text element
* Fixed: Text styles after pasting text from outside the builder
* Fixed: Random global blocks are not saved in Global block list
* Fixed: Posts include and exclude select
* Fixed: Style for Counter element in Firefox
* Fixed: Vimeo video background loop
* Fixed: Countdown restart after finished

### 2.3.32 - 2022-03-04

* Fixed: Security fix

### 2.3.31 - 2022-03-02

* New: Collaboration tool option in left sidebar
* Improved: Changed max value for counter element
* Improved: Selecting dropdown options in Post filter option
* Improved: Cache for dynamic content images
* Improved: Performance on extracting images, avoid creating duplicate of images when the sizes are bigger than image,
  removed functions and all data sent to editor regards to download_images from s3
* Improved: SQL query for attachment id
* Improved: Optimize save global blocks
* Fixed: Avoid load duplicates images in the editor
* Fixed: Original image width and height
* Fixed: Width for sidebar custom attributes
* Fixed: Links on buttons when global blocks are missing
* Fixed: Gradient color for buttons
* Fixed: External Popups font assets
* Fixed: Form hidden field send only label
* Fixed: Premade popup designs available only in PRO
* Fixed: View as for membership roles in builder
* Fixed: Separators in responsive and hamburger dropdowns in the left sidebar
* Fixed: Accordion active tags
* Fixed: Hide go to dashboard for reseller partners
* Fixed: Removed dependency asset storage of asset proxy processor
* Fixed: Custom fonts endpoint

### 2.3.30 - 2022-02-09

* Improved: Form element - added Loading animation to button after submit
* Fixed: Form element - Hidden field not working correctly
* Fixed: Video element - gets muted after cover image is added
* Fixed: Tabs element - options not working on responsive views
* Fixed: Tabs element - orientation and style not working on responsive views
* Fixed: Tabs element - duplicate options in right sidebar on responsive views
* Fixed: Blocks get reordered when only global blocks exist in page
* Fixed: Menu element - jumping on hover when border opacity is 0 in normal mode
* Fixed: Columns and Rows - image background hover not working
* Fixed: Global blocks conditions in custom post types
* Fixed: Section Background Video error when loop is enabled
* Fixed: Slider and Carousel element - dots not positioned correctly

### 2.3.29 - 2022-02-03

* Fixed: Font url validation
* Fixed: Do shortcode on render brizy content of the shop page
* Fixed: Brizy and Complianz - GDPR/CCPA Cookie Consent plugin incompatibility
* Fixed: Saves scripts relative to the plugin main folder
* Fixed: WPML menu switcher, WPML sync menu, WPML fatal error on duplicate non brizy posts
* Fixed: Brizy Overview dashboard widget
* Fixed: Allow br tags on render lead list in admin dashboard

### 2.3.28 - 2022-01-17

* Fixed: Color and align for text element

### 2.3.27 - 2022-01-14

* New: Added border, background-color and shadow for content
* New: Added Image width px unit for svg and gif type
* Improved: XSS in RichText and all Links
* Fixed: Login entered information error
* Fixed: Dashboard news
* Fixed: Update pot file and corrected some strings translations
* Fixed: Fatal error on duplicate page with wpml, restore asset url by wp option siteurl

### 2.3.26 - 2022-01-10

* Improved: Removed icon ids
* Fixed: Video with cover was not playing on click
* Fixed: Upload form field could not be edited if placeholder is off
* Fixed: Form error messages
* Fixed: Added compatibility with the plugin Perfmatters
* Fixed: On export templates check if the license key is valid
* Fixed: Tell the editor if the current user is admin
* Fixed: Do not load scripts in header and footer when they are build it with Astra Pro and template is brizy blank
  template
* Fixed: WPML Menu switcher is missing from Brizy pages
* Fixed: Escape the script contents for non adminstrators users (This vulnerability was discovered by Vishnupriya Ilango
  of Fortinets FortiGuard Labs)

### 2.3.25 - 2021-12-20

* Fixed: Image size select
* Fixed: Search by layout name
* Fixed: Custom css characters transformed to unicode in preview
* Fixed: Form select scroll
* Fixed: Increased the returned post count on brizy_get_pots

### 2.3.24 - 2021-12-13

* Fixed: Included all composer files

### 2.3.23 - 2021-12-13

* Fixed: Switching weights on custom uploaded fonts
* Fixed: Select dropdown width on Countdown
* Fixed: Responsive corrections in Seo Agency layout
* Fixed: Added brizy_attachment_uid to attachments
* Fixed: Show WooCommerce notices on templates for products
* Fixed: Menu improvement
* Improved: Need help URLs in Form app integrations

### 2.3.22 - 2021-12-02

* Fixed: Global blocks conditions
* Fixed:  Black stripes after image crop

### 2.3.21 - 2021-11-30

* New: Size options when you upload .svg and .gifs files in Image element
* Fixed: Remove rel attributes for style to solve some plugin conflicts
* Fixed: Button align and width on Login element
* Fixed: Labels correspond with input id in the Form element
* Fixed: 505 error when you use extra large retina images
* Fixed: Text alignment when it is in a list for certain fonts
* Fixed: Color for bullet points
* Fixed: Removed the form placeholder name from dropdowns on the front end
* Fixed: Form pattern attribute
* Fixed: Individual IDs and CSS classes for Icons and Buttons
* Fixed: Decode html entity on export leads
* Fixed: Blurred images with TranslatePress plugin installed
* Fixed: Added display block by logged-in users* Fixed: Show in preview blocks by role even the user has the role of
  administrator
* Fixed: Syntax error in CSS when you have custom CSS
* Improved: Drag and Drop performance

### 2.3.20 - 2021-11-10

* Improved: Added system check at the plugin startup
* Fixed: Black line on resized images
* Fixed:  Avoid using the WP image functions for getting image sizes

### 2.3.19 - 2021-11-09

* New: Select original image in the Image Element
* New: Select original image for the dynamic image element
* Improved: Updated the Google fonts library
* Fixed: Google fonts search option was not working correctly
* Fixed: Image is cut in full height option
* Fixed: The fonts no longer intersect for element tabs
* Fixed: End option on Vimeo videos
* Fixed: Border Shadow options display
* Fixed: Border top on tabs in responsive
* Fixed: Media file upload position
* Fixed: Counter goes only to 100 in preview
* Fixed: Text sometime data-href is empty (Internal 500 error on the front-end)
* Fixed: Select drop-down options in the contact form are not showing the selected font
* Fixed: Allowing redirects on loading our iframe, so you can use theme default templates

### 2.3.18 - 2021-10-18

* New: 3 design layout packs
* Improved: Added autoplay and loop options for the Video element
* Improved: Drag and Drop between columns
* Improved: Compatibility WP Ultimo plugin. Edit brizy pages with remapping domain
* Improved: Compatibility with Page Optimize plugin
* Improved: Moved HTML Tag option back on the main toolbar on Text element
* Fixed: PostTitle added title hover transition
* Fixed: Contact form text arrangement in dropdown
* Fixed: Contact form dropdown border
* Fixed: Nested accordions collapse issue
* Fixed: Alignment in Login element
* Fixed: Fonts for Tabs
* Fixed: Styles issues for nested tabs
* Fixed: Styles issues for nested accordions
* Fixed: Vimeo bg video starting with a delay
* Fixed: Nested accordions animation
* Fixed: Displays negative values for the Counter element
* Fixed: Hexa color code in gradient background for Blocks
* Fixed: Countdown styles size and color
* Fixed: Empty links in Text element in preview
* Fixed: Negative spread values for shadows
* Fixed: Double options in right sidebar for certain elements in responsive views
* Fixed: Images are not rendered on a non default language URL
* Fixed: Use Brizy_Public_AssetProxy::get_mime instead of native function

### 2.3.17 - 2021-09-21

* Fixed: Revert optimization for assets, conflicts with plugins
* Fixed: Recompile popups on update

### 2.3.16 - 2021-09-16

* New: Added vertical align for icon in IconBox
* New: Import and Export for Saved blocks
* Improved: Page loading speed on preview when you have custom fonts on your page
* Fixed: CSS with theme Zita for wooPrice
* Fixed: Popups on Text links
* Fixed: Block screenshots not looking properly in Chrome
* Fixed: Text element with Google translate extensions
* Fixed: Image light-box
* Fixed: False positives malware File Found notifications
* Fixed: Some bugs with meta brizy_post_uid on attachments
* Fixed: Cache related issue when the page appeared broken in preview

### 2.3.15 - 2021-09-09

* Fixed: Broken home page url
* Fixed: Asset manager for pages that contains popups

### 2.3.14 - 2021-09-06

* Fixed: Icons in the Tabs element
* Fixed: Cover images for the Video element
* Fixed: CSS in Countdown element
* Improved: Brizy works better with caching plugins
* Fixed: Some default options values in the builder

### 2.3.13 - 2021-08-26

* Fixed:  Editor for Internal Popup

### 2.3.12 - 2021-08-24

* New: Hide Section icon when not in focus on tablet and mobile
* Fixed: Anchor scroll when block not found
* Fixed: Form multi-select close
* Fixed: Richtext styles
* Fixed: Global blocks in page compiler error
* Fixed: Deprecate function is_user_allowed from Brizy_Editor class
* Fixed: Load popup on non Brizy pages
* Fixed: Popup code refactoring
* Fixed: Check user permissions by current_user_can
* Fixed: Moved the screenshot validation in screenshot manager class
* Fixed: Validate the uid on save block screenshot
* Fixed: Avoid recursion when including assets
* Fixed: Load all script using wp enqueue functions

### 2.3.11 - 2021-08-18

* Fixed: Recompile pages when the Pro plugin is upgraded or disabled

### 2.3.10 - 2021-08-17

* Fixed: Dash separated value name for custom attributes
* Fixed: Cache assets on Brizy websites
* Fixed: Added the version of the plugin at the end of the included scripts
* Fixed: Merge uploaded fonts to one URL
* Fixed: Allow to call register scripts on priority 10 for compatibilities like Astra theme
* Fixed: Enqueue scripts through WordPress

### 2.3.9 - 2021-08-06

* Fixed: Replace global style when import some template
* Fixed: Global sticky header
* Fixed: Assets on preview

### 2.3.8 - 2021-08-05

* Fixed: Composer versions

### 2.3.7 - 2021-08-05

* Fixed: Story contact form element in preview
* Fixed: Typography changes on mobile for the Text element
* Fixed: Broken WooCommerce Products template in preview

### 2.3.6 - 2021-08-04

* New: Added Free blocks category in sidebar when you add blocks
* Improved: Updated Google fonts list
* Improved: Always show Replace global styles checkbox, when you add layouts
* Fixed: Popup CSS when using Twenty Twenty theme
* Fixed: Increased limit to 1.000.000 for the Countdown element
* Fixed: Image mask for Text in preview
* Fixed: Archive and Posts element for category pages

### 2.3.5 - 2021-07-26

* New: Added option to allow json file upload for the Lottie element
* Improved: Changed Protected Page element to Protected
* Improved: Back to Login instead of Login on the Login element
* Improved: Protected element default values
* Fixed: Compatibility with old jQuery
* Fixed: Full height for block slider on mobile
* Fixed: Video fullscreen option
* Fixed: HTML Tag changes style of the title for Accordion element

### 2.3.4 - 2021-07-23

* Fixed: Brizy and Job Manager WP plugin incompatibility render single job template
* Fixed: Logger initialization

### 2.3.3 - 2021-07-21

* Fixed: Compatibility with old Brizy versions

### 2.3.2 - 2021-07-20

* Fixed: Compile popup if it was not compiled by the current plugin
* Fixed: Check the assets content before sending to asset grouping library

### 2.3.1 - 2021-07-20

* Fixed: Global styles reset for text
* Fixed: Fatal Error cased by loading incompatible PRO plugin versions

### 2.3.0 - 2021-07-19

* New: All PRO elements are now visible but locked
* New: Added an API action to obtain the post taxonomies
* New: Stories
* New: Added option to change order for Button and Icon elements
* New: Added more sizes for text (em, rem, vw)
* New: Added Underline, Capitalize, Strikethrough options for the Text element
* New: Added Title HTML Tag option for the Accordion element
* New: Featured Image element
* New: Added Title HTML Tag option for the Post element
* New: Added font sizes (em, rem, vw) in Global Styles
* Improved: Preview assets JS, CSS
* Improved: RichText element
* Improved: Global Block Conditions
* Improved: Styles for when you Copy/Past text in the Text element
* Improved: HTML tag option for Text was moved in the right sidebar
* Improved: Added links to registration and login, fixed spacing, and added a form registration message for the Login
  element
* Improved: Google fonts performance optimizations (prefetch Google fonts for faster loading)
* Fixed: Compile page in the back-end when Rank Math plugin is installed
* Fixed: Save user roles when adding new user
* Fixed: Do not include JS on the profile if the user has no rights of changing roles
* Fixed: Removed the 3 character constraint from search field
* Fixed: Date format of leads by settings format of WP
* Fixed: Disabled start_excerpt and end_excerpt
* Fixed: Warning when no block provided on upload blocks
* Fixed: Return empty content when there are no sample posts for dynamic content placeholders
* Fixed: Do not throw error on get sample post data
* Fixed: The asset insertion for templates for single posts
* Fixed: Method that searches the placeholders that supports a placeholder name
* Fixed: Template rule match for product archive matches all archives
* Fixed: Refactored Brizy_Editor_Compiled HTML
* Fixed: Search placeholder in all placeholder providers
* Fixed: Block to custom post migration trigger check
* Fixed: Removed taxonomy filter from post taxonomies
* Fixed: Show Products post type in global block rules
* Fixed: Product include in rule group list
* Fixed: Added specific template rule match
* Fixed: Color and link for Post Title and Excerpt elements
* Fixed: Align for excerpt and title
* Fixed: Global color for bullets in lists
* Fixed: RichText global styles
* Fixed: Loading incompatible PRO plugin versions

### 2.2.20 - 2021-07-13

* New: error messages in Form element for Number and File input
* Fixed: change Row background for Section slider
* Fixed: styles for Table element
* Fixed: button Drag and Drop when position is set to fixed or absolute
* Fixed: display rules popup for global blocks
* Fixed: Miscellaneous Editor fixes

### 2.2.19 - 2021-07-07

* Improved: Project update project if was changed
* Improved: Added new name for layouts tab
* Fixed: Dynamic content UI
* Fixed: Sync uploaded files
* Fixed: Corner option crashing the editor
* Fixed: Polling request 500
* Fixed: Image blurred in sections
* Fixed: Styles for video iFrame
* Fixed: Membership View as Roles Order
* Fixed: Changed design buttons admin

### 2.2.18 - 2021-06-28

* Fixed:  Update the post content on compile page

### 2.2.17 - 2021-05-24

* New: Added 42 new layout packs and marketing landing pages

### 2.2.16 - 2021-05-18

* Fixed: Anchor scroll in menu
* Fixed: Run migrations after the project data is created

### 2.2.15 - 2021-05-14

* Fixed: html encode for the post content

### 2.2.14 - 2021-05-13

* New: Added file upload to Post Title & excerpt
* New: Added spacing option for the Icon Box element on responsive
* Improved: Translate global blocks conditions
* Improved: Updated the .pot file
* Fixed: Accordion Hover Transition
* Fixed: Scroll animation for anchor
* Fixed: Section height and alignment on responsive
* Fixed: UI minors styles
* Fixed: Disabled extra option in toolbar for playlist elements
* Fixed: Hover effect for play button in playlist elements
* Fixed: Disqus shortname
* Fixed: RichText symbols transform
* Fixed: Global popups inside WP templates
* Fixed: Headings margin in WP Post and WP Excerpt elements
* Fixed: Lost Password link in builder loads a 404 page inside the builder
* Fixed: Avoid html_entity_decode for the post content
* Fixed: Hide draft pages for non logged users
* Fixed: Update translations

### 2.2.13 - 2021-04-14

* Fixed: Text spacing

### 2.2.12 - 2021-04-12

* Improved: Removed postContent when edit post
* Fixed: About Brizy from left sidebar white label issue
* Fixed: Woocomerce minors bugs
* Fixed: Hover, active mode in accordion element
* Fixed: Hover, active mode in tabs element
* Fixed: Accordion animation when have padding
* Fixed: Align for Title and Excerpt elements
* Fixed: Facebook minors bugs

### 2.2.11 - 2021-04-08

* New: Added ability to change tags for post content and post excerpt
* New: Added Brizy_Editor_CompiledHtml::getPageContent
* Improved: Added swipe to Carousel element and for block sliders
* Improved: Icon for Post element
* Fixed: Do not translate Company Name when there is white label
* Fixed: Suppress language when wpml media translation is active on extracting our fonts
* Fixed: Brizy template is not applying for Password-Protected pages
* Fixed: Do not redirect when woo option Default customer location is set to Geolocate
* Fixed: Encode and decode leads with utf-8
* Fixed: Set compiled html to the post content, allow SEO plugins parsing our content.
* Fixed: Remove product_visibility taxonomy from template conditions
* Fixed: Compile page in the WordPress admin panel if the page is created with Brizy
* Fixed: Save focal point when saving posts
* Fixed: Error Brizy could not load the content on blog page
* Fixed: Anchor scroll
* Fixed: Global Blocks Screenshots
* Fixed: Minimum size for Spacer element
* Fixed: Membership placement
* Fixed: Post Content Rich-text element

### 2.2.10 - 2021-03-23

* Fixed: Remove product_visibility taxonomy from template conditions
* Fixed: Compile page in the admin panel if the page is created with Brizy
* Fixed: Save focal point on post save
* Fixed: Sorry, Brizy could not load the content on blog page

### 2.2.9.1 - 2021-03-09

* New: Form input file label is now editable
* Improved: Sections with Membership enabled now have an indicator icon
* Fixed: Some images could experience blurriness
* Fixed: Clicking Global Blocks conditions options would do nothing
* Fixed: Carousel content flicker
* Fixed: Carousel options in responsive mode
* Fixed: Form Submit align option
* Fixed: Form Custom HTML template copy to clipboard
* Fixed: Form Integrations Popup scroll in Safari
* Fixed: Accordion drag and drop
* Fixed: Accordion adjusting browser scroll position even when not needed
* Fixed: Slider Prev and Next buttons outline
* Fixed: Slider padding option
* Fixed: Image sizes
* Fixed: Timeline border CSS
* Fixed: PostContent CSS
* Fixed: WooCommerce Add to Cart CSS
* Fixed: Typography option issues in Safari
* Fixed: Slider option CSS
* Fixed: Saving a block or a layout would fail if the browser did not support screenshot saving
* Fixed: Browser back button not working after clicking an anchor to a block on the page
* Fixed: Do not render Terms page on checkout if it created with Brizy
* Fixed: White label prefix for multi-site
* Fixed: Compatibility with BBpress plugin
* Fixed: Page shop as front page template issue
* Fixed: Exclude rule
* Fixed: Dynamic content in Membership block
* Fixed: Get post lists API
* Fixed: Compatibility with ThemeFuse old themes
* Fixed: Avoid duplicate global blocks on create blocks
* Fixed: Add script dependencies from placeholder
* Fixed: Preview for autosaves
* Fixed: Archive element on Author archive template not available
* Fixed: Possibility to crop an image by its Dynamic URL
* Fixed: Updated .POT file
* Fixed: Added an alert comment when removing a function used in other plugins
* Fixed: Global Blocks would not appear in category pages made with Brizy Template
* Fixed: PostContent CSS
* Fixed: WooCommerce Add to Cart CSS

### 2.2.8 - 2021-02-16

* New: Membership functionality
* New: Accordion content animation
* New: IconText icon link
* Improved: Publish toolbar CSS
* Fixed: Colorpicker minor issues
* Fixed: Drag & Drop for 'absolute' positioned elements
* Fixed: Timeline CSS
* Fixed: Embed CSS

### 2.2.7 - 2021-02-02

* New: Added animation option for Accordion content
* Improved: Code refactoring and optimization
* Fixed: Custom Video CSS option
* Fixed: Images with absolute position no longer blurry
* Fixed: Get taxonomies bug
* Fixed: Removed duplicate dynamic content call
* Fixed: Restore template from trash
* Fixed: Avoid cloud call crash

### 2.2.6 - 2021-01-14

* Fixed: Global Popups

### 2.2.5 - 2021-01-13

* Fixed: Insert Brizy buttons in the editor

### 2.2.4 - 2021-01-12

* Fixed: WOOCart toolbar activating from beneath the backdrop
* Fixed: Sections width on tablet and mobile
* Fixed: Global blocks
* Fixed: Accordion when content not displayed in viewport
* Fixed: Rich-text color style on Copy / Paste
* Fixed: Rich-text font size on mobile view
* Fixed: Custom video in popup
* Fixed: Login hover on field
* Fixed: Login authorization
* Fixed: Stepper on editor in Astra theme
* Fixed: Video open in fullscreen on iPhone
* Fixed: Options in the right sidebar
* Fixed: Slider with padding
* Fixed: Global Popups
* Fixed: Editor UI Slider options
* Fixed: Layout CSS for IE
* Fixed: Section custom attributes option not acception spaces
* Improved: Move elements on top when editing posts with Brizy
* Improved: Polling stop send ping only take over
* Improved: BlocksData get blocksData from S3
* New: Added margin option in Header
* New: Added WooCommerce default Products Page to Pages element

### 2.2.3 - 2020-12-10

* Fixed: Compatibility with WP 5.6

### 2.2.2 - 2020-12-09

* Fixed: Compatibility with WP 5.6

### 2.2.1 - 2020-12-07

* Improved: Templates images
* Updated: Google Fonts
* Fixed: Ping request

### 2.2.0 - 2020-12-03

* New: 7 Pre-made Layouts and Landing pages
* Fixed: Image with included SVG source
* Improved: Reduced plugin size

### 2.1.5 - 2020-11-13

* Fixed: Product single page

### 2.1.4 - 2020-11-12

* Fixed: Popup scroll inner content
* Fixed: GlobalBlocks revision

### 2.1.3 - 2020-11-11

* Fixed: EasyWp images
* Fixed: Error in abstract shortcode

### 2.1.2 - 2020-11-10

* Fixed: Form failing to submit when having multiple Text field

### 2.1.0 - 2020-11-05

* Improved: Reduced the number of divs at preview
* Improved: Reduced the size of JavaScript at preview
* Improved: reCAPTCHA is now displayed after the user submits the form instead of at load
* Fixed: Image sizing when in a MenuPro mobile menu item
* Fixed: the_content/placeholder replace recursion

### 2.0.16 - 2020-10-29

* Fixed: Page content extractor

### 2.0.15 - 2020-10-28

* Improved: PlainText editor (used in Button, Accordion, Tabs, etc) now accepts copy / paste
* Improved: The Sync with Brizy Cloud Popup is now less annoying
* Improved: Login element icon
* Fixed: Screenshots were taking way too long to make for certain blocks
* Fixed: Making a Saved block would sometimes fail because of the block id
* Fixed: Carousel element would crash when dragging it's last slide out of it
* Fixed: Images inside Menu element were having sizing issues
* Fixed: MenuFree css issues
* Fixed: Color toolbar option css issues

### 2.0.14 - 2020-10-13

* New: Audio element loop option
* Improved: Video element will be lazy loaded in browsers that support it
* Improved: Menu element icon
* Fixed: Tab element scrollTop animation on mobile mode
* Fixed: Clear Layout button visible for non admin users
* Fixed: Custom Attributes option not accepting data attributes
* Fixed: Animations in popups were not replayed after reopens
* Fixed: Video Play button appearing over Popup
* Fixed: Form element sometimes working improperly on failed submits
* Fixed: Icons CSS issues caused by the Twenty Twenty theme
* Fixed: Scroll on WP Media Gallery not working properly
* Fixed: Removed regex matching for head and body. There are cases when we hit the backtrack limit configured in
  php.ini.

### 2.0.13 - 2020-09-23 ###

* Fixed: Ignore old blocks on sync
* Fixed: Main editor page html syntax

### 2.0.12 - 2020-09-16 ###

* Fixed: Form submission action bug

### 2.0.10 - 2020-09-14 ###

* Fixed: Cloud sync

### 2.0.9 - 2020-09-11 ###

* Fixed: Blured images

### 2.0.8 - 2020-09-11 ###

* Fixed: Video on Cover in Pop-up
* Fixed: Make global to normal
* Fixed: Embed element in Popup
* Fixed: Icons in preivew
* Fixed: Form radio and checkbox
* Fixed: Responsive for prompt form integrations
* Fixed: Published Global Popup
* Fixed: Button margin
* Fixed: GlobalBlocks in preview
* Fixed: Replaced some calls to file_get_contents with Brizy_Editor_Asset_StaticFile::get_asset_content
* Fixed:  Shortpixel bug
* Fixed:  Added global context for dynamic content
* Fixed:  Fixed template rule form

### 2.0.7 - 2020-08-25 ###

* Fixed: The white label support url
* Fixed: Edit With Brizy is not displayed when using Gutenberg
* Fixed: The creation of the uid when a revision is provided
* Fixed: Mail template has only one value in all placeholders

### 2.0.6 - 2020-08-18 ###

* Fixed: Screenshots not working with Embed with scripts in it
* Fixed: Memory issue that was causing a few projects to not work at preview
* Fixed: Duplicate button not being shown for slider inside a global block
* Fixed: Countdown not displaying properly bigger numbers
* Fixed: PostContent css issue
* Fixed: Some icons did not work at preview
* Fixed: Site health loopback error
* Fixed: Include elementor_library as post type in template conditions
* Fixed: Show all public post types in the rules of the template
* Fixed: Post demo content in the editor
* Fixed: Fixed license page
* Fixed: Apply the content filters for default template
* Fixed: Dynamic content does not have a demo post
* Fixed: Fixed the default rule when product template type is saved
* Fixed: Updated the screenshot migration to contnue migration if the post is invalid (has no valid meta)
* Fixed: Changed the reqex that extract the shortcodes to understand html encoded quotes
* Fixed: Fixed cloud sync for restored databases
* Fixed: Post Info and #author render the display_name of the user

### 2.0.5 - 2020-08-07 ###

* Fixed: Preview, clean empty id
* Fixed: Conflict between Menu and Lottie
* Fixed: Templates rules for white label enabled sites Fixed support URL-s filters
* Fixed: Image optimization PHP version fix

### 2.0.4 - 2020-08-06 ###

* Fixed: Support URL filters

### 2.0.3 - 2020-08-06 ###

* Fixed: Sync process bugs
* Fixed: Allow to continue the sync process if there are block with deleted assets
* Fixed: Recaptcha integration and leads saving
* Fixed: Exclude rule bug
* Fixed: Changed session status check
* Fixed:  Short pixel key validation
* Fixed:  Product tags filter in rule options
* Fixed:  Some placeholder labels
* Fixed: Button spacing
* Fixed: Button color in Mobile menu
* Fixed: Countdown element
* Fixed: Import/Export images
* Fixed: Icons many requests, CORS CDN

### 2.0.2 - 2020-07-31 ###

* Fixed: Plugin version

### 2.0.1 - 2020-07-31 ###

* Fixed: Declared property
* Fixed: Removed code that does not work in older PHP version
* Fixed: Deleted unnecessary files from all dependencies we use extended the Image element (added fixed px size)
* Improved: Plugin loading
* Improved: Sent post directly in the get_the_content post content element
* Improved: Increased the size limit of Image population to 5000px
* Improved: Enabled shape option on responsive for all Sections
* Fixed: Section tag name
* Fixed: Global block toolbar icon
* Fixed: Removed content editable attribute on texts at preview
* Fixed: Toolbar positioning inside popups
* Fixed: TextEditor at undo / redo
* Fixed: Background video loop
* Fixed: Form select responsive width at preview
* Fixed: Section padding resize width
* Fixed: Ignore empty data values when updating global blocks
* Fixed: Changed the update global blocks to allow to update blocks without sending the data
* Fixed: Revision for compile page on preview
* Fixed: Compatibility with TranslatePress (Language by GET parameter)
* Fixed: Compatibility with LiteSpeed plugin
* Fixed: Missing translation ready strings

### 1.0.126 - 2020-06-03 ###

* Fixed: Security fixes

### 1.0.125 - 2020-06-02 ###

* Fixed: Security fixes

### 1.0.124 - 2020-04-25 ###

* New: Switched Nucleo icons for Font Awesome

### 1.0.123 - 2020-04-14 ###

* Improved: The message when the page was edited from another tab or window is now clearer
* Fixed: Search Element not appearing in the elements list
* Fixed: Popup conditions bug
* Fixed: Saved popup blocks not being shown in the global popup editor
* Fixed: Mobile menu now closes when clicking on an anchor link from it
* Fixed: Edit sub-pages with Brizy
* Fixed: Load feedback and widget news only for admin users
* Fixed: Hide Gutenberg of WordPress 5.4

### 1.0.122 - 2020-03-27 ###

* Fixed: Progress element text editor
* Fixed: Hidden population options
* Improved: RichText toolbar doesn't overlap the text

### 1.0.121 - 2020-03-27 ###

* Fixed: Added backward compatibility with old PRO plugins

### 1.0.120 - 2020-03-26 ###

* Fixed: Failed to enqueue script Select2

### 1.0.119 - 2020-03-25 ###

* Fixed: Tooltip position
* Fixed: Brizy content for subpages

### 1.0.118 - 2020-03-25 ###

* New: Notification system for errors and if two users work on the same page.
* New: Maintenance Mode
* New: Add a Get Help link
* New: Shortcut, press Esc key to select parent container
* New: Added toggle options to make the More settings right sidebar sticky
* New: Changed the template rules to allow users to create templates for posts from a specific category
* New: Added compatibility Broken Link Checker
* New: Added compatibility with SeoPress
* New: Added compatibility with RankMath
* New: Add Maintenance Mode Link in the admin toolbar
* New: Changed the template rules to allow users to create templates for posts from a specific category
* New: Added compatibility Broken Link Checker
* New: Added compatibility with SeoPress
* New: Added compatibility with RankMath
* New: Add Maintenance Mode Link in the admin toolbar
* Improved: Added 2 styles for Progress element
* Improved: Added icons, vertical/horizontal options for Tabs element
* Improved: Added icons, tags for the Accordion element
* Improved: Added styles, redirect, message for the Countdown element
* Improved: Added 3 styles for the Counter element
* Improved: Element toolbar doesn’t cover the content you are editing anymore
* Improved: Optimised and re-written options in the builder for Border, Box Shadow, Code Mirror, Color Picker, Image
  upload, Input Text, Multi Select, Element Toolbar, Select, Slider, Switch, Tabs, Toggle, Textarea, Typography
* Fixed: Enable/Disable editing with Brizy
* Fixed: Brizy post revisions
* Fixed: Brizy templates that are using the default theme template
* Fixed: Enable/Disable editing with brizy
* Fixed: Refactoring the post type field in editor config
* Fixed: Post field shortcode to use a sample post for templates
* Fixed: Brizy post revisions
* Fixed: Brizy templates that are using the default theme template
* Fixed: Removed header To from email headers

### 1.0.117 - 2020-03-12 ###

* Fixed: Export errors for certain users
* Fixed: Removed header 'To' from PHPMailer

### 1.0.116 - 2020-03-10 ###

* Fixed: Removed local Lato font
* Fixed: Removed Europa Font
* Fixed: Removed IowanOldStyleBT-Bold Font
* Fixed: Use jQuery from WordPress
* Fixed: Removed all possible screenshot extensions al leaved only jpeg
* Fixed: Force jQuery enqueue.
* Fixed: Removed some unused code added Select2 as a dependency
* Fixed: Removed Site Settings feature as this was never used

### 1.0.115 - 2020-03-10 ###

* Fixed: Removed Nucleo
* Fixed: Added Font Awesome4
* Fixed: Removed all possible screenshot extensions al leaved only jpeg
* Fixed: Force jQuery enqueue.
* Fixed: Removed some unused code added Select2 as a dependency
* Fixed: Removed Site Settings feature as this was never used

### 1.0.114 - 2020-02-12 ###

* Fixed: Builder settings page access

### 1.0.113 - 2020-01-30 ###

* Fixed: Column settings with column draggable

### 1.0.112 - 2020-01-24 ###

* Fixed: WpMediaUpload buttons
* New: Added new Layouts to free

### 1.0.111 - 2020-01-22 ###

* Fixed: PHP warning in RuleSet class
* Fixed: Changed the code to return the exception thrown by wp_mail
* Fixed: Menu align option

### 1.0.110 - 2020-01-20 ###

* Fixed: Send mail for Wordpress form integration

### 1.0.109 - 2020-01-16 ###

* New: Forms added new Fields
* New: SVG Upload Feature
* New: Lazy load for image ( Chrome Only )
* Improved: Images search for optimization
* Improved: Icons for Tabs was added
* Improved: WordPress Dynamic content ( Title, Excerpt, Content )
* Fixed: Pagination on front page
* Fixed: Dashboard Brizy Box
* Fixed: Template rules match
* Fixed: Popup compilation
* Fixes: Popup scroll fixes
* Fixes: Incompatibility with LiteSpeed Cache
* Fixes: Incompatibility with Unicon core plugin
* Fixes: Remove unnecessary SEO, Social entries

### 1.0.108 - 2019-12-18 ###

* Fixed: Editor config cache
* Fixed: Compilation and save post

### 1.0.107 - 2019-12-11 ###

* Fixed: Compile if there is no autosave post on vew page

### 1.0.106 - 2019-12-11 ###

* Improved: Page save
* New: Extended REST api response for brizy posts
* Fixed: Sections shape color in responsive
* Fixed: wp_check_filetype_and_ext argument count
* Fixed: Set DefaultFont for root brizy not body
* Fixed: IconText pre-wrap only buttons
* Fixed: Dnd between columns
* Fixed: Styles, resolve conflicts with twenty twenty theme
* Fixed: Header animation slideUp, slideDown when close/open
* Fixed: Menu align option

### 1.0.105 - 2019-11-21 ###

* Fixed: mkdir warning for folders that already exists
* Fixed: Usage of PHP_INT_MIN constant

### 1.0.104 - 2019-11-18 ###

* Fixed: Row negative margin
* Fixed: Sidebar scroll and reorder blocks
* Fixed: Animation with zIndex
* Fixed: Carousel with inner icons
* Fixed: Section hidden gradient when both gradient are opacity 0
* Fixed: Section full height in editor mode
* Fixed: Popup screenshots
* Fixed: PromptBlock, PromptFonts, PromptForms tooltip pro blocking scroll
* Fixed: Columns Dragging
* Fixed: Section conflicts padding with Twenty Twenty theme
* Improved: Set up default project font to body
* Improved: Leftsidebar disabled options for specific roles

### 1.0.103 - 2019-11-13 ###

* Fixed: Create project method
* Fixed: Temporary screenshot file path
* Fixed: Translation function call

### 1.0.102 - 2019-11-08 ###

* Fixed: Header/Footer box shadow

### 1.0.101 - 2019-11-07 ###

* Fixed: CSS issue that was causing performance problems in Safari

### 1.0.100 - 2019-10-23 ###

* New: Function for dynamic data for RenderPreview in facebook comments
* Fixed: Google fonts error for old users
* Fixed: Fixed temporary screenshot file path

### 1.0.99 - 2019-10-21 ###

* Fixed: Register Brizy supported custom posts on plugin initialization to be able to run migrations
* Fixed: Button not changing colors when switching styles
* Fixed: Load default project font on preview

### 1.0.98 - 2019-10-17 ###

* Fixed: Register custom templates if upgrading from a version < 1.0.70
* Fixed: Dynamic content context generation
* Fixed: Template preview URL for Blogs/Posts page
* Fixed: Template preview URL for 404 page

### 1.0.97 - 2019-10-10 ###

* Fixed: Dynamic content form templates
* Fixed: Data migration script

### 1.0.96 - 2019-10-09 ###

* Fixed: Brizy content filter
* Fixed: Data migration bug

### 1.0.95 - 2019-10-09 ###

* Fixed: Brizy content filter

### 1.0.94 - 2019-10-08 ###

* New: Added Design Kit 2.0

### 1.0.92 - 2019-10-04 ###

* Fixed: Show on tablet & mobile
* Fixed: Facebook Elements Fix

### 1.0.92 - 2019-10-03 ###

* Fixed: Header, translation

### 1.0.91 - 2019-10-01 ###

* New: Added indicator to show or hide all hidden blocks
* Improved: Slider dots and arrows color can now be set per device
* Fixed: The preview Url for archive Brizy templates
* Fixed: Show the latest compiled page if the compiler fails
* Fixed: Text translations
* Fixed: Checking for failed DB request when getting the project instance
* Fixed: Globals data migration

### 1.0.89 - 2019-09-24 ###

* Fixed: Disabled Block Background Attachment Fixed for Responsive

### 1.0.88 - 2019-09-24 ###

* Fixed: Image Shadow Border Radius Fix in Preview

### 1.0.87 - 2019-09-23 ###

* Fixed: Editor version number

### 1.0.86 - 2019-09-20 ###

* Fixed: RichText horizontal align justify
* Fixed: Show on Devices for Section

### 1.0.85 - 2019-09-20 ###

* Fixed: Globals to data migration
* Fixed: WOOProducts shortcode

### 1.0.84 - 2019-09-19 ###

* Fixed: Editor version
* Fixed: Read me files

### 1.0.83 - 2019-09-18 ###

* Fixed: Fonts with Mega Menu section

### 1.0.82 - 2019-09-18 ###

* New: Text image mask
* New: Text shadow
* New: Text gradient color
* New: Block shape dividers were moved from PRO to Free
* Improved: Migrated Soundcloud, Counter, Facebook Group, Page and Comments to a new CSS system meant to clean up the
  DOM
* Improved: Reduced JavaScript file size
* Improved: Improved error handling in api
* Fixed: Unable to “unglobal” Header and Footer blocks
* Fixed: Unable to use drag and drop in a global Popup block
* Fixed: Inputs, selects and textareas not being cleared when successfully submitting a form
* Fixed: Changing Section width in desktop mode affected other modes as well
* Fixed: RichText putting extra whitespace sometimes
* Fixed: SVG for two Section dividers
* Fixed: Wrong submit settings action call
* Fixed: Media asset processor
* Fixed: Template view on network sites
* Fixed: Fixed the case for duplicated global blocks in database
* Fixed: Media asset processor to replace all image urls from static css
* Fixed: Fixed ajax urls

### 1.0.81 - 2019-05-29 ###

* Fixed: Popup option not working for certain users
* Fixed: Url for Go to pro button

### 1.0.80 - 2019-05-28 ###

* Fixed: Section Make it a Slider option
* Fixed: Hotkeys not working in Global blocks
* Fixed: Slider dots options not working with certain WordPress themes
* Fixed: Undo / Redo

### 1.0.79 - 2019-05-27 ###

* Fixed: Brizy template for front page

### 1.0.78 - 2019-05-23 ###

* Fixed: Blank template and template loading

### 1.0.77 - 2019-05-23 ###

* New: Added hover transition option for Icon and Button
* Improved: Set a minimum height to Embed and WordPress elements
* Improved: Migrated Line and Progress to a new CSS system meant to clean up the DOM
* Improved: Sql queries
* Fixed: Menu not working when having more than one in a page
* Fixed: Form number filed triggering validation error when empty but not required
* Fixed: Vertical align in column
* Fixed: Image optimize submit settings
* Fixed: Autosave for globals and saved block

### 1.0.76 - 2019-05-14 ###

* Fixed: Guafrette warning in Path class

### 1.0.75 - 2019-05-10 ###

* New: Integrated Shortpixel image optimizer
* Improved: Lowered the max brizy revision count
* Improved: Delete old autosave posts
* Improved: Changed max brizy revision count value to 30
* Fixed: Optimized delete auto saved posts code
* Fixed: Removed random image names (works only for new image uploads)
* Fixed Create global blocks
* Fixed Create attachment post for block images
* Fixed: Autoptimeze plugin breaks our css

### 1.0.74 - 2019-04-23 ###

* New: Box Shadow option for Button, Icon, Soundcloud, Embed, Header, Footer
* Improved: Disabled Overlay Color option for Video when it has an image cover
* Improved: Return draft posts in Add rule form for template
* Fixed: Carousel toolbar not opening
* Fixed: Embed Border option not working properly
* Fixed: Section Dividers not respecting global color palette values
* Fixed: Background Video option not working in preview in certain instances
* Fixed: Screenshots for Global and Saved blocks not being displayed

### 1.0.73 - 2019-04-19 ###

* Fixed: Publish button not working for certain users
* Fixed: Fixed clear cache method
* Fixed: Undo / Redo

### 1.0.72 - 2019-04-18 ###

* Fixed: Project meta value setter

### 1.0.71 - 2019-04-18 ###

* Fixed: Activate license form

### 1.0.70 - 2019-04-18 ###

* New: Box Shadow option for Icon, Image, Video, Map, Column, Row
* New: Hover transition option for Image
* New: Removed autosave feature when you edit pages
* Improved: Editor performance regressions caused by Context Menu
* Fixed: Chrome warnings regarding scroll passive events
* Fixed: Icon selection popup scrollbar
* Fixed: Slider in rtl mode
* Fixed: Shift+Z shortcut in RichText

### 1.0.69 - 2019-04-09 ###

* New: White label support
* Fixed: Removed the migration per post
* Fixed: Form deserialization

### 1.0.68 - 2019-04-03 ###

* Fixed: RichText losing focus after typing pauses

### 1.0.67 - 2019-04-01 ###

* New: Added shortcuts for various actions
* New: Row and Column link options
* New: Video and Embed border options
* Improved: Right click shortcuts
* Fixed: Preview in IE 11
* Fixed: Image custom CSS option in preview
* Fixed: Archives sort order in preview

### 1.0.66 - 2019-03-28 ###

* Fixed: Form integrations
* Fixed: Back to WordPress button in classic editor
* Fixed: Project dependencies

### 1.0.65 - 2019-03-21 ###

* New: Block Adder UI
* New: Map and Soundcloud border options
* New: Added spacing for cloneable elements (Button, Icon, etc.) on mobile and tablet
* Improved: Custom CSS option
* Improved: Link option tabs order
* Improved: Network optimizations for block screenshots
* Improved: Base64 encode compiled HTML
* Fixed: Stop playing videos inside closed popups
* Fixed: Video cover position
* Fixed: Animations in Safari
* Fixed: Images that are added via Embed option CSS
* Fixed: Screenshot API refactoring
* Fixed: Form serialization
* Fixed: Compatibility SG optimizer
* Fixed: Compile post flag refactoring

### 1.0.64 - 2019-03-07 ###

* Fixed: Autoloader compatibility

### 1.0.63 - 2019-03-06 ###

* Fixed: Fixed the image cropper

### 1.0.62 - 2019-03-06 ###

* New: Border Styles on mobile and tablet for all containers (Sections, Row, Column)
* New: Added wp language placeholder
* New: Added facebook placeholders
* Fixed: Vertical align option on mobile
* Fixed: SectionFooter toolbar icon that shows that it’s a global block missing
* Fixed: Increased the image quality to 100%
* Fixed: The edit with Brizy buttons
* Fixed: Removed template select for posts
* Fixed: Added compatibility with phastpress
* Fixed: Removed redirect_to_mapped_domain function handled on the hook template_redirect

### 1.0.61 - 2019-02-21 ###

* New: Added column revert option for tablet and mobile device modes
* New: Added filters for support and upgrade to pro urls
* Fixed: Crash when making a block global
* Fixed: Video not working at preview with certain themes
* Fixed: Featured image focal point for Gutenberg
* Fixed: Thumbnail for downloaded media
* Fixed: Hide Gutenberg blocks and show the Brizy button

### 1.0.60 - 2019-02-18 ###

* New: Added gradient to backgrounds
* New: Added hover to backgrounds
* Fixed: Background parallax at preview
* Fixed: RichText sometimes removing newline characters
* Fixed: Disabled Row duplicate and delete when inside popup via context menu
* Fixed: Access to rule api
* Fixed: Compatibility with WebCraftic Clearfy plugin
* Fixed: Fixed group options for template rules

### 1.0.59 - 2019-01-29 ###

* Fixed: Wordpress integration for forms

### 1.0.58 - 2019-01-29 ###

* Fixed: Unable to add background images
* Fixed: Migration instance class check

### 1.0.57 - 2019-01-25 ###

* New: Forms and Form Integration support
* Fixed: Block screenshots being made on mobile device mode
* Fixed: Block screenshots not aligning properly in the anchor link option
* Fixed: Backgrounds with parallax not working in editor when in mobile device

### 1.0.56 - 2019-01-18 ###

* New: Added block screenshots in browsers that support it (Chrome, Firefox, Safari to a lesser extent)
* New: Possibility to add custom names to anchor links
* New: Compatibility Litespeed plugin
* New: Added API methods to get/save block screenshots
* Improved: Changed the rule manager to work with different posts
* Improved: Changed the rule api to accept json instead of form-urlencoded values
* Fixed: Remove actions that play with js scripts
* Fixed: Fixed the regexp for head extraction
* Fixed: Fixed page assets url
* Fixed: Used hideSiteUrl on save compiled html to db
* Fixed: Video not being able to go fullscreen
* Fixed: Impossible to add global colors to RichText links
* Fixed: Impossible to change margin to less than -100
* Fixed: Lightbox z-index conflict with header blocks
* Fixed: Check every request for multiple urls by Brizy_Editor_Http_Response
* Fixed: Changed signature of do_action of register API methods brizy_register_api_methods
* Fixed: Added config texts filter
* Fixed: Version check for Gutenberg compatibility

### 1.0.54 - 2019-01-11 ###

* New: Added block screenshots in browsers that support it
* New: Possibility to add custom names to anchor links
* New: Compatibility litespeed plugin
* New: Added api methods to get/save block screenshots
* Fixed: Impossible to add global colors to RichText links
* Fixed: Impossible to change margin to less than -100
* Fixed: Lightbox z-index conflict with header blocks
* Fixed: Remove actions that play with js scripts
* Fixed: Check every request for multiple urls by Brizy_Editor_Http_Response
* Fixed: Fixed the regexp for head extraction

### 1.0.53 - 2018-12-14 ###

* Fixed: Unable to delete Global blocks
* Fixed: Brizy buttons for Wordpress 5

### 1.0.52 - 2018-12-07 ###

* FIxed: Brizy buttons for Gutemberg

### 1.0.51 - 2018-12-06 ###

* New: Columns can now be resizes in mobile device mode
* Fixed: Tempate fixes
* Fixed: Dynamic content fixes
* Fixed: Removed wpautop filter
* Fixed: Added favicon

### 1.0.50 - 2018-11-30 ###

* Fixed: RichText error in certain blocks
* Fixed: Animation delay
* Fixed: Link animation on click
* Fixed: Disable autoptimize plugin when editor is open
* Fixed: Exclude jQuery

### 1.0.49 - 2018-11-27 ###

* Fixed: Image height conflicts with certain plugins
* Fixed: Slider video background height
* Fixed: Animation class name

### 1.0.48 - 2018-11-26 ###

* Fixed: Fixed autoload for some users

### 1.0.47 - 2018-11-23 ###

* New: Added Column resize in tablet mode
* Fixed: NaN showing in RichText toolbar line-height option in tablet and mobile modes
* Fixed: Animations z-index issues on preview
* Fixed: Iframe with scroll css issue in tablet and mobile modes
* Fixed: Fixed css that made deleting Global and Saved blocks or very hard
* Fixed: Fixed notices layout
* Fixed: Added author list in internal url list
* Fixed: Added display type on placeholders
* Fixed: Fixed compatibility with WP 5.0

### 1.0.46 - 2018-11-13 ###

* Updated: Removed browser restriction overlay
* Improved: Typography inputs can now be edited using the keyboard
* Improved: Added revision limits for brizy posts. By default we store 100 revisions.
* Fixed: Cursor jumping when editing RichText url
* Fixed: Crash when changing device mode with certain themes
* Fixed: Removed title attribute from images
* Fixed: ImagePicker option styling
* Fixed: Added missing justify option to RichText alignment on tablet
* Fixed: Editor config
* Fixed: Added versioning for plugin assets

### 1.0.45 - 2018-11-09 ###

* Fixed: Fixed editor and plugin version in project
* Fixed: Missing Saved and Global blocks that were started from BLANK BLOCK

### 1.0.44 - 2018-11-06 ###

* Fixed: Section slider icons at export

### 1.0.43 - 2018-11-05 ###

* Improved: Refactored the content module

### 1.0.42 - 2018-11-01 ###

* New: Added tablet mode
* Improved: Added warning when the theme does not use the_content filter
* Fixed: Typography toolbar styles

### 1.0.41 - 2018-10-29 ###

* New: Added mobile body class
* Fixed: Preview url for all pages template
* Fixed: Carousel at export

### 1.0.40 - 2018-10-26 ###

* New: Added context (right click) menu for most elements
* Improved: Button and Icon groups are now vertically centered
* Improved: Toolbar options styling
* Improved: Added percentage to Image toolbar zoom option
* Fixed: Import posts/projects
* Fixed: Execute do_shortcodes on page content
* Fixed: Brizy Menu for unsupported posts
* Fixed: Compatibility fixes for gutemberg, autoptimize and w3-total-cache
* Fixed: Class autoloader fix
* Fixed: Updated project API
* Fixed: Image url problems when using WPML
* Fixed: Image missing alt and title attributes
* Fixed: CSS Corrupted file compression issue with Siteground
* Fixed: Forms stop sending other requests if one is already in progress
* Fixed: Nucleo icon font issue
* Fixed: Duplicate media
* Fixed: Ignore template rules for deleted templates
* Fixed: Fixed template rules for deleted templates

### 1.0.39 - 2018-10-11 ###

* Fixed: Section background image for mobil
* Fixed: Gutemberg compatilbility
* Fixed: User role and capability checker
* Fixed: Fixed feed pages

### 1.0.38 - 2018-10-03 ###

* New: Added migration module
* New: Migrate project to custom post

### 1.0.37 - 2018-10-03 ###

* New: Added migration module
* New: Migrate project to custom post

### 1.0.36 - 2018-10-01 ###

* Fixed: Add Elements from left sidebar broken order

### 1.0.35 - 2018-09-28 ###

* New: Added justify to alignment options for RichText
* Updated: RichText font size limit was increased up to 300
* Fixed: Section with slider enabled Full Height option
* Fixed: Fixed select2 compatibility
* Fixed: Remove Content-Length header when returning assets
* Fixed: Fixed the_Excerpt recursion
* Fixed: Fixed icons urls

### 1.0.34 - 2018-09-24 ###

* Improved: Added redundant config urls

### 1.0.33 - 2018-09-22 ###

* Fixed: Editor crash bug

### 1.0.32 - 2018-09-21 ###

* Improved: Removed taxonomies from config
* Fixed: Carousel incorrect large width on mobile

### 1.0.31 - 2018-09-19 ###

* Improved: Reduced the number of divs generated by the editor
* Fixed: Form submit toolbar not showing for certain users
* Fixed: Preview for draft posts

### 1.0.30 - 2018-09-17 ###

* Updated: Carousel library that is used in the editor (react-slick)
* Fixed: Display keys instead of blank texts in the editor when missing translations

### 1.0.29 - 2018-09-14 ###

* Improved: Laid some groundwork for future pro features
* Improved: Use native query to get the attachment by uid
* Fixed: Mobile Tabs content Scroll
* Fixed: The conflict with Live composer builder
* Fixed: The conflict with Wp copyright plugin
* Fixed: The insert content filter
* Fixed: Changed the UrlBuilder and CromMedia classe to depend on post id
* Fixed: Filter the texonomies that does not have any terms
* Fixed: Image crop on dynamic content placeholders

### 1.0.28 - 2018-09-10 ###

* Fixed: Brizy templates preview when the user was not logged in

### 1.0.27 - 2018-09-06 ###

* Improved: CSS transition for Section padding resizer
* Improved: Show a special overlay for unsupported browsers instead of loading the editor
* Fixed: External links that were broken by previous update
* Fixed: RichText font families that were broken by previous update
* Fixed: Do not show Upgrade to Pro option when Pro is enabled
* Fixed: ColorPicker option in advanced options (right sidebar) being cut by overflow

### 1.0.26 - 2018-08-30 ###

* New: Added get_taxonomies api method
* Improved: Links will not open a new tab by default
* Improved: Toolbar labels color contrast for better readability
* Improved: Device mode popover styles
* Improved: Icons popup categories dropdown styles
* Improved: Modified the crop proxy to accept attachemt ids and uid hashes
* Improved: Added custom preview urls for templates
* Fixed: Image LightBox cursor style (set to zoom-in)
* Fixed: Text space for ordered and unordered lists
* Fixed: Line css conflicts with certain WordPress themes
* Fixed: Refresh permalink cache
* Fixed: Bug fixes on template module
* Fixed: Fixed templates for user with limited access or no acccess
* Fixed: Fixed the rule class in template module
* Fixed: Fixed the compile check for templates

### 1.0.25 - 2018-08-22 ###

* New: Added Featured Image option in LeftSidebar
* New: Added Upgrade to Pro option in LeftSidebar
* New: Added Submit an Issue option in LeftSidebar
* New: Added Brizy Templates
* New: Added Image LightBox

### 1.0.24 - 2018-08-07 ###

* Fixed: Upload path for windows installs

### 1.0.23 - 2018-08-06 ###

* Fixed: RichText word-break in Firefox
* Fixed: Added twig file system cache to avoid using eval function.
* Fixed: Disabled Expect header for compiler requests
* Fixed: Improved the preview page
* Fixed: Filter content only on main request regardles of what page type we show the content

### 1.0.22 - 2018-08-02 ###

* Improved: Removed duplicate code that updates the needs_compile flag when the globals is updated
* Improved: Added validation of global JSON object
* Fixed: Editor loading animation wouldn’t end when certain plugins were installed

### 1.0.21 - 2018-07-30 ###

* Improved: Smooth scroll for internal WordPress menu links
* Improved: Text for link nofollow option
* Fixed: The editor should now work with performance optimization plugins
* Fixed: Color styles for form fields
* Fixed: EmbedCode height consistent with content
* Fixed: RichText hyphens
* Fixed: Used body_class in body tag in brizy-blank-template.php
* Fixed: Fixed the inline json for editor
* Fixed: Admin url fix for wpengine hosting

### 1.0.20 - 2018-07-24 ###

* New: Added option to external links
* New: Check the PHP version and stop the plugin if the required php version is not meet
* Improved: Added font subsets (e.g., arabic, bengali, cyrillic)
* Improved: Video element will be loaded after click on it’s preview image
* Improved: Reduced tooltip animation delay for better UX
* Improved: Clicking on a Tabs element handle on mobile will scroll the document to the top of it’s content
* Fixed: PHP compatibility fix
* Fixed: jQuery conflicts at preview
* Fixed: Some Image element resize / crop issues
* Fixed: Linking to global blocks should now work as expected
* Fixed: Section slider styles in Safari and some conflicts with host theme’s styles
* Fixed: RichText tags (i.e., p, span, a, em) & figure tag style conflicts with the host theme (edited)

### 1.0.19 - 2018-07-16 ###

* New: Added box shadow option for various elements
* New: Added hamburger option for Menu
* New: Revisions support
* New: Image resize integration
* New: Settings page redesign
* Improved: Image resizing will now happen locally in WP instead of on Brizy servers
* Improved: IconBox, Form, Tabs, Accordion toolbar looks like Row Column ones
* Improved: Added tooltips for sidebar elements
* Fixed: Corrected Countdown preview bug
* Fixed: Corrected Form integration url
* Fixed: Fixed the upload urls
* Fixed: Fixed https value in
* Fixed: Other minor bugs

### 1.0.18 - 2018-06-28 ###

* Fixed: Fixed asset proxy url

### 1.0.17 - 2018-06-27 ###

* Fixed: Form email field validation
* Fixed: Section auto generated ids anchor problems
* Fixed: Video not being able to go full screen
* Fixed: Other minor bugs

### 1.0.16 - 2018-06-25 ###

* Fixed: Changed the way we store the data in db
* Fixed: Submit form for guests
* Fixed: Form serialization
* Fixed: Clean the logs table when the plugin is deactivated

### 1.0.15 - 2018-06-18 ###

* New: Added new icons
* Fixed: Fixed the scripts that hide the editor
* Fixed: Update page script
* Fixed: A bunch of small bugs

### 1.0.14 - 2018-06-14 ###

* Fixed: update global values request

### 1.0.13 - 2018-06-13 ###

* Fixed: Removed signature and token check

### 1.0.12 - 2018-06-13 ###

* New: Added WordPress form integration
* New: Added FontWeight and LetterSpacing for RichText element on Mobile
* Improved: Section toolbar shows a special icon if the block is global
* Improved: Section toolbar Save button feedback when clicked
* Fixed: Button text editing on Safari
* Fixed: Other minor bugs
* Fixed: Changed the the_content filter
* Fixed: Do not check the signature of the user if it's a local user
* Fixed: Removed from email and name from form class

### 1.0.11 - 2018-06-11 ###

* Improved: Trigger post change when project global data is updated
* Fixed: Brizy editor now works properly on SiteGround
* Fixed: Fixed page title for editor page

### 1.0.10 - 2018-06-11 ###

* Fixed: Changelogs in readme files
* Fixed: Back compatibility issues

### 1.0.9 - 2018-06-08 ###

* New: Added saved and global blocks
* New: Paddings and margins now accept values in percent
* Fixed: Form number input type not accepting negative and decimal values
* Fixed: Form submit text editing in Firefox
* Fixed: RichText element align on mobile
* Fixed: Other minor bugs
* Fixed: Removed functions.php
* Fixed: Store the platform credentials in plugin config to avoid one platform request

### 1.0.8 - 2018-06-06 ###

* New: Added saved and global blocks
* New: Added Form element integrations
* New: Paddings and margins now accept values in percent
* Fixed: Form submit text editing in Firefox
* Fixed: RichText element align on mobile
* Fixed: Other minor bugs

### 1.0.7 - 2018-05-30 ###

* New: Made the editor translatable
* New: Added 3 new svg icons for wp shortcodes
* Improved: Image element drag resizer now works better
* Improved: Added the possibility to enable/disable logs
* Fixed: Video element autoplay
* Fixed: Vertical align for row and column elements
* Fixed: Some issues with text element and undo / redo
* Fixed: Force all posts to be compiled on next view if the globals has been updated
* Fixed: Removed autoformat for wordpress content
* Fixed: Other minor bugs

### 1.0.6 - 2018-05-24 ###

* New: Disabled all platform api calls
* New: Added resizing via drag for Section paddings
* New: Added resizing via drag for various elements (Image, Map, Spacer, etc.)
* Fixed: Other minor bugs

### 1.0.5 - 2018-05-22 ###

* New: Added WooCommerce elements

### 1.0.4 - 2018-05-21 ###

* Fixed: Fixed array declaration syntax to support older php versions

### 1.0.3 - 2018-05-21 ###

* New: Added basic animations
* New: Added spacing option to Menu element
* Fixed: Other minor bugs

### 1.0.2 - 2018-05-15 ###

* New: Added cover option to Video element
* Improved: Updated readme files
* Improved: Clicking on a anchor will trigger a smooth transition to the target
* Improved: Tabs element with long labels will look better on mobile
* Improved: Better support for retina displays
* Fixed: Other minor bugs
* Fixed: Capability access to edit/save brizy posts
* Fixed: Settings page
* Fixed: Recompile page after plugin update
* Fixed: The default title of the newly created pages will be "Brizy #{ID}" format
* Fixed: Save compiler version at compile time
* Fixed: Media asset proxy

### 1.0.1 - 2018-05-11 ###

* Fixed: Reconfigured the page compiler

### 1.0.0 - 2018-05-08 ###

* New: Added keyword shortcuts for undo / redo
* Improved: Navigation will return empty if the menu name is null
* Improved: Added support for custom type posts
* Improved: Updated the plugin name
* Improved: Disabled leave confirmation when editing with brizy is clicked
* Fixed: Long compile page requests
* Fixed: Changed page compilation
* Fixed: Responsive issues
* Fixed: Scroll speed in Firefox
* Fixed: Other minor bugs

### 0.2.5 - 2018-04-27  ### 

* Fixed: Publish/Update button

### 0.2.0 - 2018-04-13 ### 

* Fixed: Bug Fixes

### 0.1.0 - 2018-04-12 ###

* New: Initial Beta Release
