<?php
/**
 * This file is part of Bring Fraktguiden for WooCommerce.
 *
 * @package Bring_Fraktguiden
 */

use Bring_Fraktguiden\Vas\VAS_Checkbox;

return [
	// New VAS.
	[
		'enabled'        => false,
		'code'           => '1142',
		'name'           => 'Notification VAS',
		'default'        => false,
		'bring_products' => [ 5000, 4850, 5100, 5300 ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => false,
		'code'           => '1000',
		'name'           => 'Cash On Delivery (COD)',
		'default'        => false,
		'bring_products' => [ 5800 ],
	],
	[
		'enabled'        => true,
		'code'           => '2084',
		'name'           => 'Electronic notification',
		'default'        => true,
		'bring_products' => [ 5800 ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => true,
		'code'           => 'alternative_delivery_dates',
		'name'           => 'Alternative delivery dates',
		'default'        => true,
		'bring_products' => [ 5600, 1736 ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => false,
		'code'           => '0041',
		'name'           => 'Simplified delivery',
		'default'        => false,
		'bring_products' => [ 5000, 4850, 5100, 5300, 5600 ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => false,
		'code'           => '2141',
		'name'           => 'Frost-free',
		'default'        => false,
		'bring_products' => [ 5000, 4850, 5100, 5300 ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => true,
		'code'           => '1133',
		'name'           => 'ID verification',
		'default'        => false,
		'bring_products' => [ 4850, 5800, 5600 ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => true,
		'code'           => '1134',
		'name'           => 'Individual verification',
		'default'        => false,
		'bring_products' => [ 5800, 5600, 'HOME_DELIVERY_PARCEL', 'PICKUP_PARCEL' ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => false,
		'code'           => '2045',
		'name'           => 'Consignment stopped and returned',
		'default'        => false,
		'bring_products' => [ 5000, 4850, 5300, 5800, 5600 ],
	],
	[
		'enabled'        => false,
		'code'           => '1082',
		'name'           => 'Social check',
		'default'        => false,
		'bring_products' => [ 5000, 4850, 5100, 5300, 5800, 5600 ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => false,
		'code'           => '2142',
		'name'           => 'Special goods',
		'default'        => false,
		'bring_products' => [ 5100, 5300 ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => false,
		'code'           => '0068',
		'name'           => 'Optional insurance',
		'default'        => false,
		'bring_products' => [ 5000, 5800, 5600, 9000 ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => false,
		'code'           => '1062',
		'name'           => 'Saturday delivery',
		'default'        => false,
		'bring_products' => [ 4850, 9600 ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => false,
		'code'           => '2086',
		'name'           => 'Notification by letter',
		'default'        => false,
		'bring_products' => [ 5800 ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => false,
		'code'           => '1245',
		'name'           => 'Dangerous goods',
		'default'        => false,
		'bring_products' => [ 5100, 5300 ],
		'class'          => VAS_Checkbox::class,
	],
	// Old VAS.
	[
		'enabled'        => true,
		'code'           => 'EVARSLING',
		'name'           => 'Recipient notification over SMS or E-Mail',
		'default'        => false,
		'bring_products' => [ 'BPAKKE_DOR-DOR', 'SERVICEPAKKE', 'EKSPRESS09' ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => false,
		'code'           => 'POSTOPPKRAV',
		'name'           => 'Cash on Delivery',
		'default'        => false,
		'bring_products' => [ 'MAIL', 'BPAKKE_DOR-DOR', 'SERVICEPAKKE', 'PA_DOREN', 'EKSPRESS09' ],
	],
	[
		'enabled'        => false,
		'code'           => 'LORDAGSUTKJORING',
		'name'           => 'Delivery on Saturdays',
		'default'        => false,
		'bring_products' => [ 'EKSPRESS09' ],
	],
	[
		'enabled'        => false,
		'code'           => 'ENVELOPE',
		'name'           => 'Express Envelope',
		'default'        => false,
		'bring_products' => [ 'EXPRESS_INTERNATIONAL_0900', 'EXPRESS_INTERNATIONAL_1200', 'EXPRESS_INTERNATIONAL' ],
	],
	[
		'enabled'        => false,
		'code'           => 'ADVISERING',
		'name'           => 'Bring contacts recipient',
		'default'        => false,
		'bring_products' => [ 'CARGO_GROUPAGE' ],
	],
	[
		'enabled'        => true,
		'code'           => 'PICKUP_POINT',
		'name'           => 'Delivery to pickup point',
		'default'        => false,
		'bring_products' => [ 'PICKUP_PARCEL', 'PICKUP_PARCEL_BULK' ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => false,
		'code'           => 'EVE_DELIVERY',
		'name'           => 'Evening delivery',
		'default'        => false,
		'bring_products' => [ 'CARGO', 'CARGO_GROUPAGE' ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => false,
		'code'           => 'SIMPLIFIED_DELIVERY',
		'name'           => 'Simplified delivery',
		'default'        => false,
		'bring_products' => [ 'PAKKE_I_POSTKASSEN', 'PAKKE_I_POSTKASSEN_SPORBAR' ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => true,
		'code'           => '1081',
		'name'           => 'Bag on door delivery',
		'default'        => false,
		'bring_products' => [ 3584, 3570 ],
		'class'          => VAS_Checkbox::class,
	],
	[
		'enabled'        => true,
		'code'           => '1280',
		'name'           => __('Signature required (prevents customers from selecting bag on door delivery)', 'bring-fraktguiden-for-woocommerce'),
		'default'        => false,
		'bring_products' => [ 3584, 3570 ],
		'class'          => VAS_Checkbox::class,
	],
];
