<?php

class Breadcrumbs_Made_Easy_PICP_Insight
{
    public function send_insight($action, $args = [])
    {

        // Get current plugin details
        $plugin_details = defined('BREADCRUMBS_MADE_EASY_PLUGIN_DIR') ? get_plugin_data(BREADCRUMBS_MADE_EASY_PLUGIN_DIR . 'breadcrumbs-made-easy.php') : get_plugin_data(plugin_dir_path(__DIR__) . 'breadcrumbs-made-easy.php');

        // return if plugin details is empty
        if (empty($plugin_details) || empty($plugin_details['Name']) || empty($plugin_details['TextDomain']) || empty($plugin_details['Version'])) {
            return;
        }

        $site_info = [
            'action'            => $action,
            'site_url'          => get_site_url(),
            'admin_email'       => get_option('admin_email'),
            'plugin_name'       => $plugin_details['Name'],
            'plugin_textdomain' => $plugin_details['TextDomain'],
            'plugin_version'    => $plugin_details['Version'],
            'wp_version'        => get_bloginfo('version'),
            'site_language'     => get_bloginfo('language'),
            'site_location'     => get_option('timezone_string') ?: date_default_timezone_get(),
            'args' => $args
        ];

        // PICP API URL
        $url = 'https://conicplex.com/wp-json/picp/v1/track';

        $args = [
            'method'    => 'POST',
            'body'      => $site_info,
        ];

        // Make the request
        $response = wp_remote_request(
            $url,
            $args
        );

        // error_log(json_encode($response));
    }
}
