<?php

/**
 * Fired during plugin deactivation
 *
 * @link       https://github.com/husenmemon
 * @since      1.0.0
 *
 * @package    Breadcrumbs_Made_Easy
 * @subpackage Breadcrumbs_Made_Easy/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Breadcrumbs_Made_Easy
 * @subpackage Breadcrumbs_Made_Easy/includes
 * @author     Husen Memon <husen@conicplex.com>
 */
class Breadcrumbs_Made_Easy_Deactivator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {

		$args = [];
		if (isset($_GET['picp_deactivation_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['picp_deactivation_nonce'])), 'picp_deactivation_nonce_action')) {

			if (isset($_GET['picp_deactivation_reason']) && !empty($_GET['picp_deactivation_reason'])) {
				$args['deactivation_reason'] = sanitize_text_field(wp_unslash($_GET['picp_deactivation_reason']));
			}
			if (isset($_GET['picp_deactivation_reason_text']) && !empty($_GET['picp_deactivation_reason_text'])) {
				$args['deactivation_reason_text'] = sanitize_text_field(wp_unslash($_GET['picp_deactivation_reason_text']));
			}
		}

		// Plugin insight code
		require_once BREADCRUMBS_MADE_EASY_PLUGIN_DIR . 'includes/class-breadcrumbs-made-easy-insight.php';
		$picp_insight = new Breadcrumbs_Made_Easy_PICP_Insight();
		$picp_insight->send_insight('deactivation', $args);

	}

}
