<?php

/**
 * Fired during plugin activation
 *
 * @link       https://github.com/husenmemon
 * @since      1.0.0
 *
 * @package    Breadcrumbs_Made_Easy
 * @subpackage Breadcrumbs_Made_Easy/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Breadcrumbs_Made_Easy
 * @subpackage Breadcrumbs_Made_Easy/includes
 * @author     Husen Memon <husen@conicplex.com>
 */
class Breadcrumbs_Made_Easy_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {

		// Plugin insight code
		require_once BREADCRUMBS_MADE_EASY_PLUGIN_DIR . 'includes/class-breadcrumbs-made-easy-insight.php';
		$picp_insight = new Breadcrumbs_Made_Easy_PICP_Insight();
		$picp_insight->send_insight('activation');

	}

}
