<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://github.com/husenmemon
 * @since             1.0.0
 * @package           Breadcrumbs_Made_Easy
 *
 * @wordpress-plugin
 * Plugin Name:       Breadcrumbs Made Easy
 * Plugin URI:        https://conicplex.com/breadcrumbs-made-easy
 * Description:       A lightweight, simple to use plugin that adds Breadcrumbs on your website, without any heavy plugins or theme dependency. Need custom theme or plugin developed? Contact us at husen@conicplex.com or Whatsapp at https://wa.me/917359857602.
 * Version:           1.0.0
 * Author:            ConicPlex
 * Author URI:        https://conicplex.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       breadcrumbs-made-easy
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (! defined('WPINC')) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('BREADCRUMBS_MADE_EASY_VERSION', '1.0.0');
define('BREADCRUMBS_MADE_EASY_PLUGIN_FILE', plugin_basename(__FILE__));
define('BREADCRUMBS_MADE_EASY_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('BREADCRUMBS_MADE_EASY_PLUGIN_URL', plugin_dir_url(__FILE__));
define('BREADCRUMBS_MADE_EASY_DEBUG_FILE', BREADCRUMBS_MADE_EASY_PLUGIN_DIR . 'debug.log');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-breadcrumbs-made-easy-activator.php
 */
function breadcrumbs_made_easy_activate()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-breadcrumbs-made-easy-activator.php';
	Breadcrumbs_Made_Easy_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-breadcrumbs-made-easy-deactivator.php
 */
function breadcrumbs_made_easy_deactivate()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-breadcrumbs-made-easy-deactivator.php';
	Breadcrumbs_Made_Easy_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'breadcrumbs_made_easy_activate');
register_deactivation_hook(__FILE__, 'breadcrumbs_made_easy_deactivate');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-breadcrumbs-made-easy.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function breadcrumbs_made_easy_run()
{
	$plugin = new Breadcrumbs_Made_Easy();
	$plugin->run();
}
breadcrumbs_made_easy_run();
