<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://github.com/husenmemon
 * @since      1.0.0
 *
 * @package    Breadcrumbs_Made_Easy
 * @subpackage Breadcrumbs_Made_Easy/admin/partials
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

wp_enqueue_script('jquery');
// Enqueue the color picker CSS and JS
wp_enqueue_style('wp-color-picker');
wp_enqueue_style($this->version . '-settings', BREADCRUMBS_MADE_EASY_PLUGIN_URL . 'admin/css/breadcrumbs-made-easy-admin.css', array(), $this->version, 'all');
wp_enqueue_script($this->version . '-settings', BREADCRUMBS_MADE_EASY_PLUGIN_URL . 'admin/js/breadcrumbs-made-easy-admin.js', array('wp-color-picker'), $this->version, true);


if (isset($_POST['bmecp_save_settings'])) {
    // Verify the nonce to ensure this request came from our form
    check_admin_referer('bmecp_settings_nonce');

    // Retrieve and sanitize form fields
    $settings = array(
        'show_on_home' => isset($_POST['bmecp_show_on_home']) ? sanitize_text_field(wp_unslash($_POST['bmecp_show_on_home'])) : '',
        'show_current' => isset($_POST['bmecp_show_current']) ? sanitize_text_field(wp_unslash($_POST['bmecp_show_current'])) : '',
        'separator' => isset($_POST['bmecp_breadcrumbs_separator']) ? sanitize_text_field(wp_unslash($_POST['bmecp_breadcrumbs_separator'])) : '',
        'highlight_last_item' => isset($_POST['bmecp_highlight_last_item']) ? sanitize_text_field(wp_unslash($_POST['bmecp_highlight_last_item'])) : '',
        'home_label' => isset($_POST['bmecp_home_label']) ? sanitize_text_field(wp_unslash($_POST['bmecp_home_label'])) : '',
        'search_result_label' => isset($_POST['bmecp_search_result_label']) ? sanitize_text_field(wp_unslash($_POST['bmecp_search_result_label'])) : '',
        'archive_label' => isset($_POST['bmecp_archive_label']) ? sanitize_text_field(wp_unslash($_POST['bmecp_archive_label'])) : '',
        'tag_label' => isset($_POST['bmecp_tag_label']) ? sanitize_text_field(wp_unslash($_POST['bmecp_tag_label'])) : '',
        'author_label' => isset($_POST['bmecp_author_label']) ? sanitize_text_field(wp_unslash($_POST['bmecp_author_label'])) : '',
        'error_label' => isset($_POST['bmecp_error_label']) ? sanitize_text_field(wp_unslash($_POST['bmecp_error_label'])) : '',
        'font_size' => isset($_POST['bmecp_font_size']) ? absint(wp_unslash($_POST['bmecp_font_size'])) : '',
        'font_color' => isset($_POST['bmecp_font_color']) ? sanitize_hex_color(wp_unslash($_POST['bmecp_font_color'])) : '',
        'current_page_font_color' => isset($_POST['bmecp_current_page_font_color']) ? sanitize_hex_color(wp_unslash($_POST['bmecp_current_page_font_color'])) : '',
        'separator_color' => isset($_POST['bmecp_separator_color']) ? sanitize_hex_color(wp_unslash($_POST['bmecp_separator_color'])) : '',
        'display_on' => isset($_POST['bmecp_display_on']) ? sanitize_text_field(wp_unslash($_POST['bmecp_display_on'])) : '',
    );

    // Update options in the database
    $updated = update_option('bmecp_settings', $settings);

    if ($updated) {
        // Show a success message
        echo '<div class="notice notice-success is-dismissible"><p><strong>' . esc_html__('Settings saved.', 'breadcrumbs-made-easy') . '</strong></p></div>';
    }
}

// B. Get current settings
$current_settings = get_option('bmecp_settings', array(
    'show_on_home' => 0,
    'show_current' => 1,
    'separator' => '>',
    'highlight_last_item' => 1,
    'home_label' => 'Home',
    'search_result_label' => 'Search results for',
    'archive_label' => 'Archive',
    'tag_label' => 'Posts tagged',
    'author_label' => 'Author page for',
    'error_label' => 'Error 404',
    'font_size' => '20',
    'font_color' => '#66686B',
    'current_page_font_color' => '#66686B',
    'separator_color' => '#66686B',
    'display_on' => '',
));

$show_on_home = esc_attr($current_settings['show_on_home']);
$show_current = esc_attr($current_settings['show_current']);
$separator = esc_attr($current_settings['separator'] ?? '>');
$highlight_last_item = esc_attr($current_settings['highlight_last_item']);
$home_label = esc_html($current_settings['home_label'] ?? 'Home');
$search_result_label = esc_html($current_settings['search_result_label'] ?? 'Search results for');
$archive_label = esc_html($current_settings['archive_label'] ?? 'Archive');
$tag_label = esc_html($current_settings['tag_label'] ?? 'Posts tagged');
$author_label = esc_html($current_settings['author_label'] ?? 'Author page for');
$error_label = esc_html($current_settings['error_label'] ?? 'Error 404');
$font_size = esc_attr($current_settings['font_size'] ?? '20');
$font_color = esc_html($current_settings['font_color'] ?? '#66686B');
$current_page_font_color = esc_html($current_settings['current_page_font_color'] ?? '#66686B');
$separator_color = esc_html($current_settings['separator_color'] ?? '#66686B');
$display_on = esc_html($current_settings['display_on'] ?? '');

// C. Display the form
?>
<div class="wrap bmecp-settings">
    <h1><?php esc_html_e('Settings', 'breadcrumbs-made-easy'); ?></h1>

    <form method="post" action="">
        <?php
        // WordPress security: adds hidden form fields for nonce
        wp_nonce_field('bmecp_settings_nonce');
        ?>

        <table class="form-table">


            <!-- Shortcode -->
            <tr>
                <th scope="row"><label for="bmecp_shortcode"><?php esc_html_e('Shortcode', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <input type="text" name="bmecp_shortcode" id="bmecp_shortcode" value="[easy_breadcrumbs]" class="regulasr-text" readonly />
                    <p class="description"><?php esc_html_e('Use this shortcode to output the breadcrumbs.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Auto display breadcrumbs -->
            <tr>
                <th scope="row"><label for="bmecp_display_on"><?php esc_html_e('Auto Insert Breadcrumbs', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <select name="bmecp_display_on" id="bmecp_display_on">
                        <option value="" <?php selected($display_on, ''); ?>><?php esc_html_e('Do not auto insert', 'breadcrumbs-made-easy'); ?></option>
                        <option value="before_title" <?php selected($display_on, 'before_title'); ?>><?php esc_html_e('Before Title', 'breadcrumbs-made-easy'); ?></option>
                        <option value="after_title" <?php selected($display_on, 'after_title'); ?>><?php esc_html_e('After Title', 'breadcrumbs-made-easy'); ?></option>
                        <option value="before_content" <?php selected($display_on, 'before_content'); ?>><?php esc_html_e('Before Content', 'breadcrumbs-made-easy'); ?></option>
                        <option value="after_content" <?php selected($display_on, 'after_content'); ?>><?php esc_html_e('After Content', 'breadcrumbs-made-easy'); ?></option>
                    </select>
                    <p class="description"><?php esc_html_e('Select where you want to auto insert the breadcrumbs on post pages.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Show on Home Field -->
            <tr>
                <th scope="row"><label for="bmecp_show_on_home"><?php esc_html_e('Show on Home', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <div class="checkbox-wrapper-bmecp">
                        <input class='tgl tgl-ios' name='bmecp_show_on_home' id='bmecp_show_on_home' type='checkbox' value="1" <?php checked($show_on_home, 1); ?> />
                        <label class='tgl-btn' for='bmecp_show_on_home'></label>
                    </div>
                    <p class="description"><?php esc_html_e('Check this box to show the breadcrumbs on the homepage.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Restricted (Offer) Page Field -->
            <tr>
                <th scope="row"><label for="bmecp_show_current"><?php esc_html_e('Show Current Page', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <div class="checkbox-wrapper-bmecp">
                        <input class='tgl tgl-ios' name='bmecp_show_current' id='bmecp_show_current' type='checkbox' value="1" <?php checked($show_current, 1); ?> />
                        <label class='tgl-btn' for='bmecp_show_current'></label>
                    </div>
                    <p class="description"><?php esc_html_e('Check this box to hide the current page in the breadcrumbs.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Breadcrumbs Separator -->
            <tr>
                <th scope="row"><label for="bmecp_breadcrumbs_separator"><?php esc_html_e('Breadcrumbs Separator', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <input type="text" name="bmecp_breadcrumbs_separator" id="bmecp_breadcrumbs_separator" value="<?php echo esc_attr($separator); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('Enter the separator you want to use between breadcrumbs.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Highlight last item -->
            <tr>
                <th scope="row"><label for="bmecp_highlight_last_item"><?php esc_html_e('Highlight Last Item', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <div class="checkbox-wrapper-bmecp">
                        <input class='tgl tgl-ios' name='bmecp_highlight_last_item' id='bmecp_highlight_last_item' type='checkbox' value="1" <?php checked($highlight_last_item, 1); ?> />
                        <label class='tgl-btn' for='bmecp_highlight_last_item'></label>
                    </div>
                    <p class="description"><?php esc_html_e('Highlight the last item in the breadcrumbs.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Home Label -->
            <tr>
                <th scope="row"><label for="bmecp_home_label"><?php esc_html_e('Label for Homepage', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <input type="text" name="bmecp_home_label" id="bmecp_home_label" value="<?php echo esc_attr($home_label); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('Enter the label you want to use for the homepage.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Search Results Label -->
            <tr>
                <th scope="row"><label for="bmecp_search_result_label"><?php esc_html_e('Label for Search Results', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <input type="text" name="bmecp_search_result_label" id="bmecp_search_result_label" value="<?php echo esc_attr($search_result_label); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('Enter the label you want to use for the search results page.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Archive Label -->
            <tr>
                <th scope="row"><label for="bmecp_archive_label"><?php esc_html_e('Label for Archive Pages', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <input type="text" name="bmecp_archive_label" id="bmecp_archive_label" value="<?php echo esc_attr($archive_label); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('Enter the label you want to use for the archive pages.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Tag page Label -->
            <tr>
                <th scope="row"><label for="bmecp_tag_label"><?php esc_html_e('Label for Tags Pages', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <input type="text" name="bmecp_tag_label" id="bmecp_tag_label" value="<?php echo esc_attr($tag_label); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('Enter the label you want to use for the tags pages.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Author Label -->
            <tr>
                <th scope="row"><label for="bmecp_author_label"><?php esc_html_e('Label for Author Pages', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <input type="text" name="bmecp_author_label" id="bmecp_author_label" value="<?php echo esc_attr($author_label); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('Enter the label you want to use for the author pages.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Error 404 Label -->
            <tr>
                <th scope="row"><label for="bmecp_error_label"><?php esc_html_e('Label for Error 404 Page', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <input type="text" name="bmecp_error_label" id="bmecp_error_label" value="<?php echo esc_attr($error_label); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('Enter the label you want to use for the error 404 page.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Font Size -->
            <tr>
                <th scope="row"><label for="bmecp_font_size"><?php esc_html_e('Font Size', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <input type="number" min="1" name="bmecp_font_size" id="bmecp_font_size" value="<?php echo esc_attr($font_size); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('Enter the font size in px for breadcrumbs.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Font Color -->
            <tr>
                <th scope="row"><label for="bmecp_font_color"><?php esc_html_e('Font Color', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <input type="text" min="1" name="bmecp_font_color" id="bmecp_font_color" data-default-color="#66686B" value="<?php echo esc_html($font_color); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('Enter the font color for breadcrumbs.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Current Page Font Color -->
            <tr>
                <th scope="row"><label for="bmecp_current_page_font_color"><?php esc_html_e('Current Page Color', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <input type="text" min="1" name="bmecp_current_page_font_color" id="bmecp_current_page_font_color" data-default-color="#66686B" value="<?php echo esc_html($current_page_font_color); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('Enter the font color for current page in breadcrumbs.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

            <!-- Separator Color -->
            <tr>
                <th scope="row"><label for="bmecp_separator_color"><?php esc_html_e('Separator Color', 'breadcrumbs-made-easy'); ?></label></th>
                <td>
                    <input type="text" min="1" name="bmecp_separator_color" id="bmecp_separator_color" data-default-color="#66686B" value="<?php echo esc_html($separator_color); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('Enter the breadcrumbs separator color.', 'breadcrumbs-made-easy'); ?></p>
                </td>
            </tr>

        </table>

        <!-- Submit -->
        <p class="submit">
            <input
                type="submit"
                name="bmecp_save_settings"
                id="bmecp_save_settings"
                class="button button-primary"
                value="<?php esc_attr_e('Save Changes', 'breadcrumbs-made-easy'); ?>" />
        </p>
    </form>
</div>