jQuery(document).ready(async function ($) {
    let picp_deactivation_options = ``;
    if (bmecp_picp_deactivation.picp_deactivation_reasons.length > 0) {
        for (let picp_deactivation_reason of bmecp_picp_deactivation.picp_deactivation_reasons) {
            picp_deactivation_options += `<div class="picp-deactivation-option">
                                            <div>
                                                <input type="radio" name="picp_deactivation_reason" id="picp_deactivation_reason_${
                                                    picp_deactivation_reason.id
                                                }" value="${
                picp_deactivation_reason.id
            }">
                                            </div>
                                            <label for="picp_deactivation_reason_${
                                                picp_deactivation_reason.id
                                            }">${
                picp_deactivation_reason.label
            }</label>
                                            ${
                                                picp_deactivation_reason.is_textbox
                                                    ? `<input type="text" class="picp_reason_text" id="picp_reason_text_${picp_deactivation_reason.id}" placeholder="Please share the reason" style="margin-top: 5px; width: 100%; display: none" />`
                                                    : ``
                                            }
                                        </div>`;
        }
    }

    $("body").append(`
        <div class="picp-deactivation-modal" id="picp_deactivation_modal" style="display: none">
            <div class="picp-deactivation-dialog">
                <div class="picp-deactivation-modal-header">
                    <span class="picp-deactivation-modal-title">QUICK FEEDBACK</span>
                </div>
                <div class="picp-deactivation-modal-content">

                    <span class="picp-deactivation-modal-subtitle">If you have a moment, please share why you are deactivating Booking:</span>

                    <div class="picp-deactivation-options-list">
                        ${picp_deactivation_options}
                    </div>

                    <div class="picp-deactivation-buttons">
                        <div>
                            <button type="button" class="picp-btn-deactivation-submit" id="picp_deactivation_submit">Submit & Deactivate</button>
                            <button type="button" class="picp-btn-deactivation-skip" id="picp_deactivation_cancel">Cancel</button>
                        </div>
                        <div>
                            <button type="button" class="picp-btn-deactivation-skip" id="picp_deactivation_skip">Skip & Deactivate</button>
                        </div>
                    </div>

                    <div class="picp-deactivation-selection-error">Please select any reason.</div>
                </div>
            </div>
        <div>
    `);

    var picp_plugin = "breadcrumbs-made-easy/breadcrumbs-made-easy.php";
    var picp_deactivation_link = `tr[data-plugin="${picp_plugin}"] .deactivate a`;

    $(document).on("click", picp_deactivation_link, function (e) {
        e.preventDefault();
        picp_deactivation_modal_show();
    });

    $(document).on("click", "body", function (e) {
        if ($(e.target).hasClass("picp-deactivation-modal")) {
            picp_deactivation_modal_hide();
        }
    });

    $(document).on("click", "#picp_deactivation_submit", function (e) {
        let id = $("input[name='picp_deactivation_reason']:checked").val();
        if (!id) {
            $(".picp-deactivation-selection-error").show();
            return false;
        }
        let text = $(`#picp_reason_text_${id}`).val();
        if (!text) {
            text = "";
        }
        console.log(text);
        

        window.location.href =
            $(picp_deactivation_link).attr("href") +
            `&picp_deactivation_reason=${id}&picp_deactivation_reason_text=${text}&picp_deactivation_nonce=${bmecp_picp_deactivation.nonce}`;
    });

    $(document).on("click", "#picp_deactivation_skip", function (e) {
        window.location.href = $(picp_deactivation_link).attr("href");
    });

    $(document).on("click", "#picp_deactivation_cancel", function (e) {
        picp_deactivation_modal_hide();
    });

    $(document).on(
        "change",
        "input[name='picp_deactivation_reason']",
        function (e) {
            $(".picp_reason_text").val("").hide();
            $(".picp-deactivation-selection-error").hide();
            let id = $("input[name='picp_deactivation_reason']:checked").val();
            $(`#picp_reason_text_${id}`).show();
        }
    );

    function picp_deactivation_modal_show() {
        $("body").css("overflow", "hidden");
        $("#picp_deactivation_modal").fadeIn();
    }

    function picp_deactivation_modal_hide() {
        $("body").css("overflow", "auto");
        $("#picp_deactivation_modal").fadeOut();
    }
});
