<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://github.com/husenmemon
 * @since      1.0.0
 *
 * @package    Breadcrumbs_Made_Easy
 * @subpackage Breadcrumbs_Made_Easy/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Breadcrumbs_Made_Easy
 * @subpackage Breadcrumbs_Made_Easy/admin
 * @author     Husen Memon <husen@conicplex.com>
 */
class Breadcrumbs_Made_Easy_Admin
{

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct($plugin_name, $version)
	{

		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles($hook)
	{
		//wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/breadcrumbs-made-easy-admin.css', array(), $this->version, 'all');
		if ($hook === 'plugins.php') {
			wp_enqueue_style($this->plugin_name . 'picp-deactivation', BREADCRUMBS_MADE_EASY_PLUGIN_URL . 'admin/css/picp-deactivation.css', array(), $this->version, 'all');
		}
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts($hook)
	{

		//wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/breadcrumbs-made-easy-admin.js', array('jquery'), $this->version, false);

		if ($hook === 'plugins.php') {

			$picp_deactivation_reasons = [];
			$response = wp_remote_get('https://conicplex.com/wp-json/picp/v1/deactivation-reasons');

			if (!is_wp_error($response)) {
				$body = wp_remote_retrieve_body($response);
				$picp_deactivation_reasons = json_decode($body, true)['data'];
			}

			wp_enqueue_script($this->plugin_name . 'picp-deactivation', BREADCRUMBS_MADE_EASY_PLUGIN_URL . 'admin/js/picp-deactivation.js', array('jquery'), $this->version, false);
			wp_localize_script($this->plugin_name . 'picp-deactivation', 'bmecp_picp_deactivation', array(
				'nonce' => wp_create_nonce('picp_deactivation_nonce_action'),
				'picp_deactivation_reasons' => $picp_deactivation_reasons,
			));
		}
	}

	public function bmecp_admin_menu()
	{
		add_options_page(
			'Breadcrumbs Made Easy Settings', // Page title
			'Breadcrumbs Made Easy', // Menu title
			'manage_options', // Capability
			'breadcrumbs-made-easy', // Menu slug
			array($this, 'bmecp_settings_page') // Callback function
		);
	}

	public function bmecp_settings_page()
	{
		include BREADCRUMBS_MADE_EASY_PLUGIN_DIR . 'admin/partials/breadcrumbs-made-easy-admin-display.php';
	}

	/**
	 * Display the developer info into plugin list.
	 * @since    1.0.0
	 */
	function bmecp_add_conicplex_contact_plugin_link($links, $file)
	{
		if ($file == BREADCRUMBS_MADE_EASY_PLUGIN_FILE) {
			$custom_link = sprintf(
				'<a href="%s" target="_blank" rel="noopener noreferrer">%s</a>',
				esc_url('https://wa.me/917359857602'),
				esc_html__('Contact for Plugin Development', 'breadcrumbs-made-easy')
			);
			$links[] = $custom_link;
		}

		return $links;
	}
}
