<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
$enabled          = isset( $enabled ) ? $enabled : true;
$url              = isset( $url ) ? $url : '';
$content          = isset( $content ) ? $content : '';
$start_datetime   = isset( $start_datetime ) ? $start_datetime : '';
$end_datetime     = isset( $end_datetime ) ? $end_datetime : '';
$show_frequency   = isset( $show_frequency ) ? $show_frequency : 'always';
$custom_interval  = isset( $custom_interval ) ? $custom_interval : 30;
$user_visibility  = isset( $user_visibility ) ? $user_visibility : 'logged_in';
?>
<div class="btpn-wrap">
    <div class="btpn-header">
        <h1>📢<?php esc_html_e( 'Popup Notification', 'brandismtech-popup-notification' ); ?></h1>
        <p><?php esc_html_e( 'Create and manage popup notifications for your website visitors.', 'brandismtech-popup-notification' ); ?></p>
    </div>

    <?php
    $nonce            = isset( $_GET['_wpnonce'] ) ? sanitize_text_field( wp_unslash( $_GET['_wpnonce'] ) ) : '';
    $settings_updated = isset( $_GET['settings-updated'] ) ? sanitize_text_field( wp_unslash( $_GET['settings-updated'] ) ) : '';

    $options_changed = false;
    if ( isset( $_GET['page'] ) && 'btpn-settings' === $_GET['page'] ) {
        $current_options = [
            'btpn_enabled'          => get_option( 'btpn_enabled', true ),
            'btpn_url'              => get_option( 'btpn_url', '' ),
            'btpn_content'          => get_option( 'btpn_content', '' ),
            'btpn_start_datetime'   => get_option( 'btpn_start_datetime', '' ),
            'btpn_end_datetime'     => get_option( 'btpn_end_datetime', '' ),
            'btpn_show_frequency'   => get_option( 'btpn_show_frequency', 'always' ),
            'btpn_custom_interval'  => get_option( 'btpn_custom_interval', 30 ),
            'btpn_user_visibility'  => get_option( 'btpn_user_visibility', 'logged_in' ),
        ];
        $previous_options = get_transient( 'btpn_previous_options' );
        if ( false !== $previous_options && $previous_options !== $current_options ) {
            $options_changed = true;
        }
        set_transient( 'btpn_previous_options', $current_options, 60 );
    }

    if ( ( $settings_updated && wp_verify_nonce( $nonce, BTPN_Popup_Notification::OPTION_GROUP . '-options' ) ) || $options_changed ) : ?>
        <div class="btpn-alert btpn-alert-info">
            <span style="font-size:20px;">✓</span>
            <strong><?php esc_html_e( 'Settings saved successfully!', 'brandismtech-popup-notification' ); ?></strong>
        </div>
    <?php endif; ?>

    <?php if ( empty( $url ) ) : ?>
        <div class="btpn-alert btpn-alert-warning">
            <span style="font-size:20px;">⚠</span>
            <div>
                <strong><?php esc_html_e( 'Action Required', 'brandismtech-popup-notification' ); ?></strong><br>
                <?php esc_html_e( 'Please configure a URL below to activate your popup notification.', 'brandismtech-popup-notification' ); ?>
            </div>
        </div>
    <?php endif; ?>

    <form method="post" action="options.php">
        <?php settings_fields( BTPN_Popup_Notification::OPTION_GROUP ); ?>
        <div class="btpn-card">
            <!-- General Settings -->
            <div class="btpn-section">
                <div class="btpn-section-header">
                    <div class="btpn-section-icon white">⚙️</div>
                    <h2 class="btpn-section-title"><?php esc_html_e( 'General Settings', 'brandismtech-popup-notification' ); ?></h2>
                </div>
                <div class="btpn-field">
                    <label class="btpn-toggle">
                        <input type="checkbox" name="btpn_enabled" value="1" <?php checked( $enabled, 1 ); ?> class="btpn-checkbox">
                        <span class="btpn-toggle-label"><?php esc_html_e( 'Enable Popup Notification', 'brandismtech-popup-notification' ); ?></span>
                    </label>
                    <p class="btpn-description"><?php esc_html_e( 'Toggle to activate or deactivate the popup.', 'brandismtech-popup-notification' ); ?></p>
                </div>
                <div class="btpn-field">
                    <label class="btpn-label" for="btpn_user_visibility"><?php esc_html_e( 'Show Popup To', 'brandismtech-popup-notification' ); ?></label>
                    <select id="btpn_user_visibility" name="btpn_user_visibility" class="btpn-input">
                        <option value="logged_in"     <?php selected( $user_visibility, 'logged_in' ); ?>><?php esc_html_e( 'Logged-in Users Only', 'brandismtech-popup-notification' ); ?></option>
                        <option value="not_logged_in" <?php selected( $user_visibility, 'not_logged_in' ); ?>><?php esc_html_e( 'Not Logged-in Users Only', 'brandismtech-popup-notification' ); ?></option>
                        <option value="both"          <?php selected( $user_visibility, 'both' ); ?>><?php esc_html_e( 'Both Logged-in and Not Logged-in Users', 'brandismtech-popup-notification' ); ?></option>
                    </select>
                    <p class="btpn-description"><?php esc_html_e( 'Choose which users can see the popup. Note: Display frequency settings apply only to logged-in users.', 'brandismtech-popup-notification' ); ?></p>
                </div>
            </div>

            <!-- Frequency -->
            <div class="btpn-section">
                <div class="btpn-section-header">
                    <div class="btpn-section-icon">🔄</div>
                    <h2 class="btpn-section-title"><?php esc_html_e( 'Display Frequency', 'brandismtech-popup-notification' ); ?></h2>
                </div>
                <div class="btpn-field">
                    <label class="btpn-label" for="btpn_show_frequency"><?php esc_html_e( 'Show Popup', 'brandismtech-popup-notification' ); ?></label>
                    <select id="btpn_show_frequency" name="btpn_show_frequency" class="btpn-input">
                        <option value="always"            <?php selected( $show_frequency, 'always' ); ?>><?php esc_html_e( 'Every Page Load', 'brandismtech-popup-notification' ); ?></option>
                        <option value="once_per_session" <?php selected( $show_frequency, 'once_per_session' ); ?>><?php esc_html_e( 'Once Per Session', 'brandismtech-popup-notification' ); ?></option>
                        <option value="custom_interval"  <?php selected( $show_frequency, 'custom_interval' ); ?>><?php esc_html_e( 'Custom Interval', 'brandismtech-popup-notification' ); ?></option>
                    </select>
                    <p class="btpn-description"><?php esc_html_e( 'Control how often the popup appears to logged-in users.', 'brandismtech-popup-notification' ); ?></p>
                </div>
                <div class="btpn-field btpn-custom-interval" <?php echo 'custom_interval' !== $show_frequency ? 'style="display:none;"' : ''; ?>>
                    <label class="btpn-label" for="btpn_custom_interval"><?php esc_html_e( 'Custom Interval (Minutes)', 'brandismtech-popup-notification' ); ?></label>
                    <input type="number" id="btpn_custom_interval" name="btpn_custom_interval" value="<?php echo esc_attr( $custom_interval ); ?>" class="btpn-input" min="1" placeholder="30">
                    <p class="btpn-description"><?php esc_html_e( 'Set the time interval (in minutes) before the popup can appear again for logged-in users.', 'brandismtech-popup-notification' ); ?></p>
                </div>
            </div>

            <!-- URL -->
            <div class="btpn-section btpn-highlight">
                <div class="btpn-section-header">
                    <div class="btpn-section-icon white">🔗</div>
                    <h2 class="btpn-section-title"><?php esc_html_e( 'Display Location', 'brandismtech-popup-notification' ); ?></h2>
                </div>
                <div class="btpn-field">
                    <label class="btpn-label" for="btpn_url"><?php esc_html_e( 'Page URL Path (Required)', 'brandismtech-popup-notification' ); ?></label>
                    <input type="text" id="btpn_url" name="btpn_url" value="<?php echo esc_attr( $url ); ?>" class="btpn-input" placeholder="<?php esc_attr_e( '/your-page/', 'brandismtech-popup-notification' ); ?>" required>
                    <div class="btpn-url-preview">
                        <strong><?php esc_html_e( 'Current URL:', 'brandismtech-popup-notification' ); ?></strong>
                        <?php echo ! empty( $url ) ? esc_html( $url ) : '<em>' . esc_html__( 'Not configured', 'brandismtech-popup-notification' ) . '</em>'; ?>
                    </div>
                    <div class="btpn-example-box">
                        <strong>URL Format Examples:</strong>
                        • <?php esc_html_e( 'For Menu page:', 'brandismtech-popup-notification' ); ?> <code>/menu/</code><br>
                        • <?php esc_html_e( 'For About page:', 'brandismtech-popup-notification' ); ?> <code>/about/</code><br>
                        • <?php esc_html_e( 'For Contact page:', 'brandismtech-popup-notification' ); ?> <code>/contact/</code><br>
                        • <?php esc_html_e( 'For Home page:', 'brandismtech-popup-notification' ); ?> <code>/</code>
                    </div>
                    <p class="btpn-description"><strong><?php esc_html_e( 'Note:', 'brandismtech-popup-notification' ); ?></strong> <?php esc_html_e( 'Enter the URL path where the popup should appear.', 'brandismtech-popup-notification' ); ?></p>
                </div>
            </div>

            <!-- Schedule -->
            <div class="btpn-section">
                <div class="btpn-section-header">
                    <div class="btpn-section-icon">📅</div>
                    <h2 class="btpn-section-title"><?php esc_html_e( 'Schedule Settings', 'brandismtech-popup-notification' ); ?></h2>
                </div>
                <div class="btpn-field">
                    <label class="btpn-label" for="btpn_start_datetime"><?php esc_html_e( 'Start Date & Time', 'brandismtech-popup-notification' ); ?></label>
                    <input type="datetime-local" id="btpn_start_datetime" name="btpn_start_datetime" value="<?php echo esc_attr( $start_datetime ); ?>" class="btpn-datetime">
                    <p class="btpn-description"><?php esc_html_e( 'Popup will start displaying from this date and time (leave empty to show immediately)', 'brandismtech-popup-notification' ); ?></p>
                </div>
                <div class="btpn-field">
                    <label class="btpn-label" for="btpn_end_datetime"><?php esc_html_e( 'End Date & Time', 'brandismtech-popup-notification' ); ?></label>
                    <input type="datetime-local" id="btpn_end_datetime" name="btpn_end_datetime" value="<?php echo esc_attr( $end_datetime ); ?>" class="btpn-datetime">
                    <p class="btpn-description"><?php esc_html_e( 'Popup will stop displaying after this date and time (leave empty for no end date)', 'brandismtech-popup-notification' ); ?></p>
                </div>
            </div>

            <!-- Content -->
            <div class="btpn-section">
                <div class="btpn-section-header">
                    <div class="btpn-section-icon">✍️</div>
                    <h2 class="btpn-section-title"><?php esc_html_e( 'Popup Content', 'brandismtech-popup-notification' ); ?></h2>
                </div>
                <div class="btpn-field">
                    <label class="btpn-label"><?php esc_html_e( 'Message Content', 'brandismtech-popup-notification' ); ?></label>
                    <?php
                    wp_editor( $content, 'btpn_content', [
                        'textarea_name' => 'btpn_content',
                        'wpautop'       => true,
                        'media_buttons' => false,
                        'textarea_rows' => 14,
                        'tinymce'       => [
                            'toolbar1' => 'formatselect,bold,italic,underline,strikethrough,bullist,numlist,blockquote,hr,alignleft,aligncenter,alignright,link,unlink,wp_more,spellchecker,wp_fullscreen,wp_adv',
                            'toolbar2' => 'forecolor,backcolor,removeformat,undo,redo',
                        ],
                    ] );
                    ?>
                    <p class="btpn-description"><?php esc_html_e( 'Create your popup message using the rich text editor above.', 'brandismtech-popup-notification' ); ?></p>
                </div>
            </div>

            <!-- Submit -->
            <div class="btpn-section">
                <button type="submit" class="btpn-btn">💾<?php esc_html_e( 'Save', 'brandismtech-popup-notification' ); ?></button>
            </div>
        </div>
    </form>
</div>