(function () {
    'use strict';
    var modal    = document.getElementById('btpnPopupModal');
    var closeBtn = document.getElementById('btpnCloseBtn');
    if (!modal || !closeBtn) return;

    setTimeout(function () {
        modal.classList.add('show');
        document.body.style.overflow = 'hidden';
    }, 400);

    function closePopup() {
        modal.style.animation = 'btpnFadeOut 0.3s ease-out';
        setTimeout(function () {
            modal.classList.remove('show');
            modal.style.animation = '';
            document.body.style.overflow = '';
        }, 300);
    }

    closeBtn.addEventListener('click', closePopup);
    modal.addEventListener('click', function (e) {
        if (e.target === modal) closePopup();
    });
    document.addEventListener('keydown', function (e) {
        if (e.key === 'Escape' && modal.classList.contains('show')) closePopup();
    });
})();