<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="bvg-wrapper">
    <div class="bvg-card">
        <div class="bvg-header">
            <div class="bvg-icon-badge">🎙️</div>
            <h1>Voice Over Generator <span class="text-gradient">for Content Creators</span></h1>
            <p>Transform your script into professional audio with our AI-powered voice engine.</p>
        </div>

        <div class="bvg-group">
            <label for="voice-select">Select Voice Personality</label>
            <div class="bvg-select-wrapper">
                <select id="voice-select">
                    <option value="Kore">Kore (Clear, Firm)</option>
                    <option value="Puck">Puck (Upbeat, Enthusiastic)</option>
                    <option value="Charon">Charon (Informative, Deep)</option>
                    <option value="Leda">Leda (Youthful, Soft)</option>
                    <option value="Zephyr">Zephyr (Bright, Engaging)</option>
                    <option value="Fenrir">Fenrir (Excitable, Dynamic)</option>
                </select>
            </div>
        </div>

        <div class="bvg-group">
            <label for="text-input">Script Text</label>
            <textarea id="text-input" rows="6" placeholder="Type something amazing here..."></textarea>
        </div>

        <div class="bvg-toggle-group">
            <input type="checkbox" id="ssml-toggle" class="bvg-checkbox">
            <label for="ssml-toggle">Enable SSML (Advanced pauses & emphasis)</label>
        </div>

        <div class="bvg-controls-grid">
            <div class="bvg-slider-box">
                <div class="bvg-slider-label">
                    <label for="rate-slider">Speed</label>
                    <span id="rate-value">1.0x</span>
                </div>
                <input id="rate-slider" type="range" min="0.5" max="2.0" step="0.1" value="1.0">
            </div>
            <div class="bvg-slider-box">
                <div class="bvg-slider-label">
                    <label for="pitch-slider">Pitch</label>
                    <span id="pitch-value">0</span>
                </div>
                <input id="pitch-slider" type="range" min="-20" max="20" step="1" value="0">
            </div>
        </div>

        <div class="bvg-actions">
            <button id="generate-btn" class="bvg-btn-primary">
                <span class="btn-text">Generate Voice & Play</span>
                <span class="btn-icon">✨</span>
            </button>

            <div id="loading-indicator" class="bvg-loader hidden">
                <div class="spinner"></div>
                <span>Synthesizing audio...</span>
            </div>
        </div>

        <div id="download-container" class="bvg-download-area"></div>

        <div class="bvg-pro-features">
            <table class="widefat" id="bvg-history-table" style="margin-top: 20px; display:none;">
                <thead>
                    <tr>
                        <th>Voice</th>
                        <th>Script</th>
                        <th>Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody id="bvg-history-table-body"></tbody>
            </table>
            <table class="widefat" id="bvg-media-library-table" style="margin-top: 20px; display:none;">
                 <tbody id="bvg-media-library-table-body"></tbody>
            </table>
        </div>

        <div class="bvg-player-area">
            <div id="error-message" class="bvg-error"></div>
            <label class="bvg-label-sm">Generated Audio Result:</label>
            <audio id="audio-player" controls style="display: none;"></audio>
        </div>
    </div>
</div>
