<?php

add_action('woocommerce_shipping_init', 'bf_chung_hwa_post_shipping_method');

function bf_chung_hwa_post_shipping_method()
{
    class BOXFUL_Chung_Hwa_Post_Shipping_Method extends WC_Shipping_Method
    {
        public function __construct($instance_id = 0)
        {
            $this->instance_id = absint($instance_id);
            $this->id = 'bf_chung_hwa_post';
            $this->method_title = 'Boxful 中華郵政';
            $this->method_description = '每一筆固定費用(可設定免運門檻)';
            $this->supports = array(
                'shipping-zones',
                'instance-settings',
                'instance-settings-modal',
            );
            $this->title = 'Boxful 中華郵政';
            $this->enabled = 'yes';
            $this->init();
        }

        function init()
        {
            $this->init_form_fields();
            $this->init_settings();
            add_action('woocommerce_update_options_shipping_' . $this->id, array($this, 'process_admin_options'));
        }

        function init_form_fields()
        {
            $this->instance_form_fields = [
                'title'                  => [
                    'title'       => '物流顯示名稱',
                    'type'        => 'text',
                    'description' => null,
                    'default'     => 'Boxful 中華郵政'
                ],
                'cost'                   => [
                    'title'       => '每筆費用',
                    'type'        => 'number',
                    'description' => null,
                    'default'     => 85
                ],
                'enabled_free_logistics' => [
                    'title'   => '金額達標免運',
                    'type'    => 'checkbox',
                    'label'   => '啟用',
                    'default' => 'no',
                ],
                'free_logistics_price'   => [
                    'title'       => '達標免運門檻',
                    'type'        => 'number',
                    'description' => null,
                    'default'     => 0
                ],
            ];
        }

        public function calculate_shipping($package = array())
        {
            $intance_settings = $this->instance_settings;
            $this->add_rate(array(
                    'id'      => $this->id,
                    'label'   => $intance_settings['title'],
                    'cost'    => $intance_settings['cost'],
                    'package' => $package,
                    'taxes'   => false,
                )
            );
        }
    }

}