<?php

class ShippingMethodController
{
    function __construct()
    {
        $this->init();
        if (is_admin()) {
            new AdminShippingMethodController();
        } else {
            new UserShippingMethodController();
        }
    }

    public function addMethod()
    {
        require_once(BOXFUL_FULFILLMENT_PLUGIN_DIR . "controller/shipping-method/class/" . "BoxfulDailyLogistics.php");
        require_once(BOXFUL_FULFILLMENT_PLUGIN_DIR . "controller/shipping-method/class/" . "BoxfulCrossBorder.php");
        require_once(BOXFUL_FULFILLMENT_PLUGIN_DIR . "controller/shipping-method/class/" . "BoxfulSevenEleven.php");
        require_once(BOXFUL_FULFILLMENT_PLUGIN_DIR . "controller/shipping-method/class/" . "BoxfulFamilyMart.php");
        require_once(BOXFUL_FULFILLMENT_PLUGIN_DIR . "controller/shipping-method/class/" . "BoxfulHiLife.php");
        require_once(BOXFUL_FULFILLMENT_PLUGIN_DIR . "controller/shipping-method/class/" . "BoxfulHct.php");
        require_once(BOXFUL_FULFILLMENT_PLUGIN_DIR . "controller/shipping-method/class/" . "BoxfulKerryExpress.php");
        require_once(BOXFUL_FULFILLMENT_PLUGIN_DIR . "controller/shipping-method/class/" . "BoxfulTCat.php");
        require_once(BOXFUL_FULFILLMENT_PLUGIN_DIR . "controller/shipping-method/class/" . "BoxfulChungHwaPost.php");
    }

    public function init()
    {
        $this->addMethod();
        add_filter('woocommerce_shipping_methods', [$this, 'addBFShippingMethod']);
    }

    function addBFShippingMethod($methods)
    {
        $methods['bf_daily_logistics'] = 'BOXFUL_Daily_Logistics_Shipping_Method';
        $methods['bf_cross_border'] = 'BOXFUL_Cross_Border_Shipping_Method';
        $methods['bf_seven_eleven'] = 'BOXFUL_Seven_Eleven_Shipping_Method';
        $methods['bf_family_mart'] = 'BOXFUL_Family_Mart_Shipping_Method';
        $methods['bf_hi_life'] = 'BOXFUL_Hi_Life_Shipping_Method';
        $methods['bf_hct'] = 'BOXFUL_Hct_Shipping_Method';
        $methods['bf_kerry_express'] = 'BOXFUL_Kerry_Express_Shipping_Method';
        $methods['bf_t_cat'] = 'BOXFUL_T_Cat_Shipping_Method';
        $methods['bf_chung_hwa_post'] = 'BOXFUL_Chung_Hwa_Post_Shipping_Method';
        return $methods;
    }
}

require_once(BOXFUL_FULFILLMENT_PLUGIN_DIR . "controller/shipping-method/" . "AdminShippingMethodController.php");
require_once(BOXFUL_FULFILLMENT_PLUGIN_DIR . "controller/shipping-method/" . "UserShippingMethodController.php");

new ShippingMethodController();