function b0xTPortal_cls_address_vldtr(b0xTPortal_arg_config) { 
     var b0xTPortal_address_data = this;
     b0xTPortal_address_data.config = b0xTPortal_arg_config;
     b0xTPortal_address_data.random_number = Math.floor(Math.random() * 1000000);

     b0xTPortal_address_data.validated = "0";

     this._b0xTPortal_init = async function() {
          let b0xTPortal_waitForGoogle = async function() {
               return new Promise(function(b0xTPortal_resolve) {
                    async function b0xTPortal_isItReady() {
                         if(typeof(google.maps.places) !== "undefined") {
                              try { //make a call to make sure the api is included in the key.
                                    //this call is not included in billing because the get details never
                                    //never gets called.
                                   const b0xTPortal_token = new google.maps.places.AutocompleteSessionToken();
                                   const b0xTPortal_suggestions = await google.maps.places.AutocompleteSuggestion.fetchAutocompleteSuggestions({
                                        sessionToken: b0xTPortal_token,
                                        input: "588",
                                        language: "en-US",
                                        includedRegionCodes: ["us", "ca"]    
                                   });
                              } catch(e) {
                                    b0xTPortal_resolve(1);
                              } 
                              b0xTPortal_resolve(0);
                         } else {
                              setTimeout(b0xTPortal_isItReady, 50);
                         }
                    } 
                    b0xTPortal_isItReady();
               });
          };

          let b0xTPortal_legacy_check = await b0xTPortal_waitForGoogle();

          if(b0xTPortal_legacy_check) {
               b0xTPortal_address_data._b0xTPortal_init_legacy(); 
               return; 
          }

          let b0xTPortal_address_suggestion_wrap                   = document.createElement("div");
          b0xTPortal_address_suggestion_wrap.style.position        = "absolute";
          b0xTPortal_address_suggestion_wrap.style.marginTop       = "1px";
          b0xTPortal_address_suggestion_wrap.style.borderRadius    = "1px";
          b0xTPortal_address_suggestion_wrap.style.backgroundColor = "#ffffff";
          b0xTPortal_address_suggestion_wrap.style.zIndex          = 1;

          //allow developers to style it
          b0xTPortal_address_suggestion_wrap.setAttribute("class", "b0xTPortal_address_suggestion_wrap");

          b0xTPortal_address_data.address_suggestion_wrap          = b0xTPortal_address_suggestion_wrap;
          b0xTPortal_address_data.config.searchCtrl.after(b0xTPortal_address_suggestion_wrap);
          b0xTPortal_address_data.config.searchCtrl.setAttribute("placeholder", "Search Address");

          //setup event listensers on fields
          b0xTPortal_address_data.config.searchCtrl.addEventListener("keyup", function(b0xTPortal_e) {
               if(b0xTPortal_e.key != "ArrowDown" && b0xTPortal_e.key != "ArrowUp" && b0xTPortal_e.key != "ArrowLeft" && b0xTPortal_e.key != "ArrowRight" && b0xTPortal_e.key != "Enter") {     
                    clearTimeout(b0xTPortal_address_data.searchTimeOut);  
                    b0xTPortal_address_data.searchTimeOut = setTimeout(function() {
                         if(!String(b0xTPortal_address_data.config.searchCtrl.value).trim()) { 
                              b0xTPortal_address_data.address_suggestion_wrap.innerHTML = "";
                              b0xTPortal_address_data.address_suggestion_wrap.style.boxShadow = "none";
                              return; 
                         }

                         //if we are using the search bar to act as the address bar aswell. then trigger the address changed
                         if(b0xTPortal_address_data.config.addressCtrl && (b0xTPortal_address_data.config.addressCtrl == b0xTPortal_address_data.config.searchCtrl)) {
                              b0xTPortal_address_data._b0xTPortal_address_changed();
                         }
      
                         b0xTPortal_address_data._b0xTPortal_get_suggestions(b0xTPortal_address_data.config.searchCtrl.value);
                         b0xTPortal_address_data.address_suggestion_wrap.style.boxShadow = "0px 0px 4px 1px #d2d2d2";
                    }, 500);
               }
          });

          b0xTPortal_address_data.config.searchCtrl.addEventListener("keydown", function(b0xTPortal_e) {
               let b0xTPortal_address_suggestions_wrap = document.getElementById("b0xTPortal_"+b0xTPortal_address_data.random_number+"_AddrVldtrSuggestionsContent");
               if(!b0xTPortal_address_suggestions_wrap) { return; }

               let b0xTPortal_selected = function(b0xTPortal_argDiv) {
                    b0xTPortal_argDiv.parentElement.style.color = "#0174ab";
                    b0xTPortal_argDiv.parentElement.style.backgroundColor = "#dddddd";
                    b0xTPortal_address_data.config.searchCtrl.value = b0xTPortal_argDiv.valHTML;
               };

               let b0xTPortal_unSelected = function(b0xTPortal_argDiv) {
                    b0xTPortal_argDiv.parentElement.style.removeProperty("color");
                    b0xTPortal_argDiv.parentElement.style.removeProperty("background-color");
               };
 
               if(b0xTPortal_e.key == "ArrowDown" || b0xTPortal_e.key == "ArrowUp" || b0xTPortal_e.key == "Enter") {
                    let b0xTPortal_child_wrappers = Array.from(b0xTPortal_address_suggestions_wrap.children);

                    if(b0xTPortal_e.key == "ArrowDown" || b0xTPortal_e.key == "ArrowUp") {
                         clearTimeout(b0xTPortal_address_data.cursorTimeout);
                         b0xTPortal_child_wrappers.forEach(function(b0xTPortal_argDiv) {
                              b0xTPortal_unSelected(b0xTPortal_argDiv.children[0]);
                         });

                         if(String(b0xTPortal_address_suggestions_wrap.keyIndex) == "") {
                              b0xTPortal_address_suggestions_wrap.keyIndex  = -1;
                         }

                         if(b0xTPortal_e.key == "ArrowDown") {
                              if(b0xTPortal_address_suggestions_wrap.keyIndex < b0xTPortal_child_wrappers.length) {
                                   b0xTPortal_address_suggestions_wrap.keyIndex++;
                              }

                              if(b0xTPortal_address_suggestions_wrap.keyIndex == b0xTPortal_child_wrappers.length) {
                                   b0xTPortal_address_suggestions_wrap.keyIndex = -1;
                              }
                         } else {
                              if(b0xTPortal_address_suggestions_wrap.keyIndex >= -1) {
                                   b0xTPortal_address_suggestions_wrap.keyIndex--;
                              }

                              if(b0xTPortal_address_suggestions_wrap.keyIndex == -2) {
                                   b0xTPortal_address_suggestions_wrap.keyIndex = b0xTPortal_child_wrappers.length - 1;
                              }
                         }

                         if(b0xTPortal_child_wrappers[b0xTPortal_address_suggestions_wrap.keyIndex]) {
                              let b0xTPortal_nextDiv = b0xTPortal_child_wrappers[b0xTPortal_address_suggestions_wrap.keyIndex].children[0];
                              b0xTPortal_selected(b0xTPortal_nextDiv);
                         } else {
                              b0xTPortal_address_data.config.searchCtrl.value = b0xTPortal_address_suggestions_wrap.keyOrgVal;
                         }

                         //for smooth transition
                         b0xTPortal_address_data.config.searchCtrl.style.caretColor = 'transparent';
                         b0xTPortal_address_data.cursorTimeout = setTimeout(function() {
                              let b0xTPortal_valLength = b0xTPortal_address_data.config.searchCtrl.value.length;
                              b0xTPortal_address_data.config.searchCtrl.setSelectionRange(b0xTPortal_valLength, b0xTPortal_valLength);
                              b0xTPortal_address_data.config.searchCtrl.style.removeProperty("caret-color");
                         }, 10);
                    } else if(b0xTPortal_e.key == "Enter") {
                         if(b0xTPortal_child_wrappers[b0xTPortal_address_suggestions_wrap.keyIndex]) {
                              let b0xTPortal_nextDiv = b0xTPortal_child_wrappers[b0xTPortal_address_suggestions_wrap.keyIndex].children[0];
                              b0xTPortal_nextDiv.click();
                              b0xTPortal_address_data.config.searchCtrl.blur();
                         }
                    }
               }
          });

          b0xTPortal_address_data.config.searchCtrl.addEventListener("focus", function(b0xTPortal_e) {      
               clearTimeout(b0xTPortal_address_data.searchTimeOut);  
               b0xTPortal_address_data.searchTimeOut = setTimeout(function() {
                    if(!String(b0xTPortal_address_data.config.searchCtrl.value).trim()) { return; }
                    b0xTPortal_address_data._b0xTPortal_get_suggestions(b0xTPortal_address_data.config.searchCtrl.value);
                    b0xTPortal_address_data.address_suggestion_wrap.style.boxShadow = "0px 0px 4px 1px #d2d2d2";
               }, 500);
          });

          b0xTPortal_address_data.config.searchCtrl.addEventListener("blur", function(b0xTPortal_e) { 
               clearTimeout(b0xTPortal_address_data.blurTimeOut);  
               b0xTPortal_address_data.blurTimeOut = setTimeout(function() {
                    let b0xTPortal_address_suggestions_wrap_content = document.getElementById("b0xTPortal_"+b0xTPortal_address_data.random_number+"_AddrVldtrSuggestionsContent");
                    if(b0xTPortal_address_suggestions_wrap_content) {
                         b0xTPortal_address_data.config.searchCtrl.value = b0xTPortal_address_suggestions_wrap_content.keyOrgVal;
                    }

                    b0xTPortal_address_data.address_suggestion_wrap.innerHTML = "";
                    b0xTPortal_address_data.address_suggestion_wrap.style.boxShadow = "none";
               }, 500);
          });

          //if we are not using the search bar to act as the address bar, then set an onchange handler. Otherwise skip it
          if(b0xTPortal_address_data.config.addressCtrl && (b0xTPortal_address_data.config.addressCtrl != b0xTPortal_address_data.config.searchCtrl)) {
               b0xTPortal_address_data.config.addressCtrl = b0xTPortal_address_data._b0xTPortal_address_changed;
          }

          b0xTPortal_address_data.config.cityCtrl.onchange   = b0xTPortal_address_data._b0xTPortal_address_changed;
          b0xTPortal_address_data.config.stateCtrl.onchange  = b0xTPortal_address_data._b0xTPortal_address_changed;
          b0xTPortal_address_data.config.postalCtrl.onchange = b0xTPortal_address_data._b0xTPortal_address_changed; 
     };

     this._b0xTPortal_init_legacy = function() {
          let b0xTPortal_search = b0xTPortal_address_data.config.searchCtrl;
          let b0xTPortal_place_auto_complete = new google.maps.places.Autocomplete(
               b0xTPortal_search, { 
                    fields: ['geometry', 'address_component', 'type']
               }
          );

          let b0xTPortal_call_back = function () {
               b0xTPortal_address_data._b0xTPortal_fill_in_address_legacy();
          }

          b0xTPortal_place_auto_complete.addListener('place_changed',  b0xTPortal_call_back);
          b0xTPortal_address_data.placeautocomplete_legacy = b0xTPortal_place_auto_complete;

          //limit the counties to usa and canada
          b0xTPortal_place_auto_complete.setComponentRestrictions({
               country: ['us', 'ca']
          });

          //setup event listensers on fields
          b0xTPortal_address_data.config.addressCtrl.onchange = function() { b0xTPortal_address_data._b0xTPortal_address_changed(1); }
          b0xTPortal_address_data.config.cityCtrl.onchange    = function() { b0xTPortal_address_data._b0xTPortal_address_changed(1); }
          b0xTPortal_address_data.config.stateCtrl.onchange   = function() { b0xTPortal_address_data._b0xTPortal_address_changed(1); }
          b0xTPortal_address_data.config.postalCtrl.onchange  = function() { b0xTPortal_address_data._b0xTPortal_address_changed(1); }
     }

     this._b0xTPortal_get_suggestions = async function(b0xTPortal_v) { 
          //creating a new session if it does not exist.
          const b0xTPortal_token = b0xTPortal_address_data.token_session ? b0xTPortal_address_data.token_session : new google.maps.places.AutocompleteSessionToken();
          b0xTPortal_address_data.token_session = b0xTPortal_token;

          let b0xTPortal_options = {
               sessionToken: b0xTPortal_token,
               input: b0xTPortal_v,
               language: "en-US",
               includedRegionCodes: ["us", "ca"]
          };

          const b0xTPortal_suggestions = await google.maps.places.AutocompleteSuggestion.fetchAutocompleteSuggestions(b0xTPortal_options);
          const b0xTPortal_suggestions_array = b0xTPortal_suggestions.suggestions;

          let b0xTPortal_fill_structure = function(b0xTPortal_address_suggestions_wrap) {
               b0xTPortal_address_suggestions_wrap.innerHTML = "";
               b0xTPortal_address_suggestions_wrap.keyIndex  = "";
               b0xTPortal_address_suggestions_wrap.keyOrgVal = b0xTPortal_address_data.config.searchCtrl.value;

               b0xTPortal_suggestions_array.forEach(function(b0xTPortal_suggestion, b0xTPortal_index) {
                    const b0xTPortal_place_prediction = b0xTPortal_suggestion.placePrediction;
                    let b0xTPortal_input_wrap              = document.createElement("div");
                    let b0xTPortal_input                   = document.createElement("div");
                    b0xTPortal_input.style.whiteSpace      = "nowrap";
                    b0xTPortal_input.style.borderRadius    = "0px";
                    b0xTPortal_input.style.border          = "0px";
                    b0xTPortal_input.style.padding         = "10px";
                    b0xTPortal_input.style.cursor          = "pointer";

                    let b0xTPortal_icon                    = document.createElement("i");
                    b0xTPortal_icon.style.verticalAlign    = "middle";
                    b0xTPortal_icon.style.fontSize         = "14pt";
                    b0xTPortal_icon.style.marginRight      = "5px";
                    b0xTPortal_icon.style.color            = "#808080";

                    b0xTPortal_icon.setAttribute("class", "material-icons");
                    b0xTPortal_icon.innerHTML = "place";

                    b0xTPortal_input.appendChild(b0xTPortal_icon);
                    b0xTPortal_input.innerHTML += b0xTPortal_place_prediction.text.toString();
                    b0xTPortal_input.valHTML = b0xTPortal_place_prediction.text.toString();

                    if(b0xTPortal_index < b0xTPortal_suggestions_array.length - 1) {
                         b0xTPortal_input_wrap.style.borderBottom = "1px solid #d1cfcf";
                    }

                    b0xTPortal_input.onmouseover = function() {
                         this.style.color = "#0174ab";
                         this.style.backgroundColor = "#f5f5f5";
                    };
                    b0xTPortal_input.onmouseout = function() {
                         this.style.removeProperty("color");
                         this.style.removeProperty("background-color");
                    }
                    b0xTPortal_input.onclick = function() {
                         clearTimeout(b0xTPortal_address_data.blurTimeOut);
                         clearTimeout(b0xTPortal_address_data.searchTimeOut);
                         b0xTPortal_address_data._b0xTPortal_fill_in_address(b0xTPortal_place_prediction);
                         b0xTPortal_address_data.address_suggestion_wrap.innerHTML = "";
                         b0xTPortal_address_data.address_suggestion_wrap.style.boxShadow = "none";
                    }

                    b0xTPortal_input_wrap.appendChild(b0xTPortal_input);
                    b0xTPortal_address_suggestions_wrap.appendChild(b0xTPortal_input_wrap);
               });
          };

          let b0xTPortal_build_structure = function() {
               let b0xTPortal_flex_master_div                 = document.createElement("div");
               b0xTPortal_flex_master_div.style.flexDirection = "column";
               b0xTPortal_flex_master_div.style.display       = "flex";

               //content
               let b0xTPortal_address_suggestions_wrap                = document.createElement("div");
               b0xTPortal_address_suggestions_wrap.setAttribute("id", "b0xTPortal_"+b0xTPortal_address_data.random_number+"_AddrVldtrSuggestionsContent");
               b0xTPortal_address_suggestions_wrap.style.border       = "1px solid #d1cfcf";
               b0xTPortal_address_suggestions_wrap.style.borderBottom = "0px";
               b0xTPortal_address_suggestions_wrap.style.overflowY    = "auto";
               b0xTPortal_address_suggestions_wrap.style.maxHeight    = "300px";

               b0xTPortal_fill_structure(b0xTPortal_address_suggestions_wrap);

               b0xTPortal_flex_master_div.appendChild(b0xTPortal_address_suggestions_wrap);

               //logo
               let b0xTPortal_powered_by_wrap = document.createElement("div");
               b0xTPortal_powered_by_wrap.style.border    = "1px solid #d1cfcf";          
               b0xTPortal_powered_by_wrap.style.borderTop = "0px";

               let b0xTPortal_powered_by = document.createElement("div");
               b0xTPortal_powered_by.style.borderRadius  = "0px";
               b0xTPortal_powered_by.style.border        = "0px";
               b0xTPortal_powered_by.style.padding       = "10px";

               b0xTPortal_powered_by.style.color         = "#808080";
               b0xTPortal_powered_by.style.textAlign     = "right";
               b0xTPortal_powered_by.style.fontWeight    = "bold";
               b0xTPortal_powered_by.style.pointerEvents = "none";
               b0xTPortal_powered_by.innerHTML           = "powered by";

               let b0xTPortal_icon = document.createElement("img");
               b0xTPortal_icon.setAttribute("src", b0xTPortal_address_data.config.imageUrl+"/Google_logo.png");

               b0xTPortal_icon.style.height        = "18px";
               b0xTPortal_icon.style.verticalAlign = "middle";
               b0xTPortal_icon.style.marginLeft    = "5px";

               b0xTPortal_powered_by.appendChild(b0xTPortal_icon);
               b0xTPortal_powered_by_wrap.appendChild(b0xTPortal_powered_by);

               b0xTPortal_flex_master_div.appendChild(b0xTPortal_powered_by_wrap);

               //put it together
               b0xTPortal_address_data.address_suggestion_wrap.appendChild(b0xTPortal_flex_master_div);
          };

          let b0xTPortal_address_suggestions_wrap = document.getElementById("b0xTPortal_"+b0xTPortal_address_data.random_number+"_AddrVldtrSuggestionsContent");

          if(!b0xTPortal_address_suggestions_wrap) {
               b0xTPortal_build_structure();
          } else { 
               b0xTPortal_fill_structure(b0xTPortal_address_suggestions_wrap);
          }
     };

     this._b0xTPortal_fill_in_address = async function (b0xTPortal_place_prediction) {
          var b0xTPortal_place = b0xTPortal_place_prediction.toPlace();

          await b0xTPortal_place.fetchFields({fields: ['location', 'addressComponents', 'types', 'displayName']});

          //clear session token, this way we create a
          //new one when the suggestion triggers again
          b0xTPortal_address_data.token_session = undefined;

          if (!b0xTPortal_place.location) {
               b0xTPortal_address_data.b0xTPortal_refresh_google_verification();

               if(b0xTPortal_address_data.dBox) {
                    b0xTPortal_address_data.dBox.b0xTPortal_open_dialog("WARNING!!", 'No details available for input: '+b0xTPortal_place.displayName, null);
               }
               return;
          }
        
          //get autocompleted address
          let b0xTPortal_street_number = b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.addressComponents, 'street_number' );
          b0xTPortal_street_number.shortText = b0xTPortal_street_number.shortText ? b0xTPortal_street_number.shortText : b0xTPortal_address_data.config.searchCtrl.value.split(' ')[0].replaceAll(/\D/g, '');
  
          let b0xTPortal_street_name = b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.addressComponents, 'street_address' );
          b0xTPortal_street_name = b0xTPortal_street_name.longText ? b0xTPortal_street_name : b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.addressComponents, 'route' );
          b0xTPortal_street_name = b0xTPortal_street_name.longText ? b0xTPortal_street_name : b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.addressComponents, 'intersection' );
  
          let b0xTPortal_city = b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.addressComponents, 'locality' );
          b0xTPortal_city = b0xTPortal_city.longText ? b0xTPortal_city : b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.addressComponents, 'administrative_area_level_3' );
          b0xTPortal_city = b0xTPortal_city.longText ? b0xTPortal_city : b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.addressComponents, 'sublocality_level_1' );
  
          let b0xTPortal_state = b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.addressComponents, 'administrative_area_level_1' );
          let b0xTPortal_postal = b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.addressComponents, 'postal_code' );         
          let b0xTPortal_postal_suffix = b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.addressComponents, 'postal_code_suffix' );

          //we are done, clear address field
          b0xTPortal_address_data.config.addressCtrl.value = "";

          //however, is state part of the selected country ?
          //if not we dont want to go any further than this
          var found_state = 0;
          for(var option of b0xTPortal_address_data.config.stateCtrl.options) {
               if(option.value == b0xTPortal_state.shortText) {
                    found_state++;
               }
          }

          if(!found_state) {
               b0xTPortal_address_data.config.cityCtrl.value = "";
               b0xTPortal_address_data.config.stateCtrl.value = "";
               b0xTPortal_address_data.b0xTPortal_refresh_google_verification();
               if(b0xTPortal_address_data.dBox) {
                    b0xTPortal_address_data.dBox.b0xTPortal_open_dialog("WARNING!!", "This address appears to reside in a country that is not accepted by this company", null);
               }
               return;
          }

          b0xTPortal_address_data.config.addressCtrl.value = `${b0xTPortal_street_number.shortText} ${b0xTPortal_street_name.shortText}`;
          b0xTPortal_address_data.current_address = `${b0xTPortal_street_number.shortText} ${b0xTPortal_street_name.shortText}`;
          b0xTPortal_address_data.config.cityCtrl.value = b0xTPortal_city.longText;
          b0xTPortal_address_data.config.stateCtrl.value = b0xTPortal_state.shortText;
          b0xTPortal_address_data.config.postalCtrl.value = b0xTPortal_postal.shortText;

          //check if the address is rooftop
          let b0xTPortal_verified = b0xTPortal_place.types.includes('premise') || b0xTPortal_place.location.location_type == 'ROOFTOP' || b0xTPortal_postal_suffix.shortText.length;

          b0xTPortal_verified = b0xTPortal_verified ? 1 : 0;
          b0xTPortal_address_data.b0xTPortal_refresh_google_verification(b0xTPortal_verified);
     };

     this._b0xTPortal_fill_in_address_legacy = function () {
          var b0xTPortal_place = b0xTPortal_address_data.placeautocomplete_legacy.getPlace();

          if (!b0xTPortal_place.geometry) {
               b0xTPortal_address_data.config.addressCtrl.value = "";
               b0xTPortal_address_data.b0xTPortal_refresh_google_verification();
               if(b0xTPortal_address_data.dBox) {
                    b0xTPortal_address_data.dBox.b0xTPortal_open_dialog("WARNING!!", 'No details available for input: '+b0xTPortal_place.name, null);
               }
               return;
          }
        
          //get autocompleted address
          let b0xTPortal_street_number = b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.address_components, 'street_number' );
          b0xTPortal_street_number.short_name = b0xTPortal_street_number.short_name ? b0xTPortal_street_number.short_name : b0xTPortal_address_data.config.searchCtrl.value.split(' ')[0].replaceAll(/\D/g, '');
  
          let b0xTPortal_street_name = b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.address_components, 'street_address' );
          b0xTPortal_street_name = b0xTPortal_street_name.long_name ? b0xTPortal_street_name : b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.address_components, 'route' );
          b0xTPortal_street_name = b0xTPortal_street_name.long_name ? b0xTPortal_street_name : b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.address_components, 'intersection' );
  
          let b0xTPortal_city = b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.address_components, 'locality' );
          b0xTPortal_city = b0xTPortal_city.long_name ? b0xTPortal_city : b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.address_components, 'administrative_area_level_3' );
          b0xTPortal_city = b0xTPortal_city.long_name ? b0xTPortal_city : b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.address_components, 'sublocality_level_1' );
  
          let b0xTPortal_state = b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.address_components, 'administrative_area_level_1' );
          let b0xTPortal_postal = b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.address_components, 'postal_code' );         
          let b0xTPortal_postal_suffix = b0xTPortal_address_data._b0xTPortal_find_address_component( b0xTPortal_place.address_components, 'postal_code_suffix' );

          //we are done, clear address field
          b0xTPortal_address_data.config.addressCtrl.value = "";

          //however, is state part of the selected country ?
          //if not we dont want to go any further than this
          var found_state = 0;
          for(var option of b0xTPortal_address_data.config.stateCtrl.options) {
               if(option.value == b0xTPortal_state.short_name) {
                    found_state++;
               }
          }

          if(!found_state) {
               b0xTPortal_address_data.config.cityCtrl.value = "";
               b0xTPortal_address_data.config.stateCtrl.value = "";
               b0xTPortal_address_data.b0xTPortal_refresh_google_verification();
               if(b0xTPortal_address_data.dBox) {
                    b0xTPortal_address_data.dBox.b0xTPortal_open_dialog("WARNING!!", "This address appears to reside in a country that is not accepted by this company", null);
               }
               return;
          }

          b0xTPortal_address_data.config.addressCtrl.value = `${b0xTPortal_street_number.short_name} ${b0xTPortal_street_name.short_name}`;
          b0xTPortal_address_data.current_address = `${b0xTPortal_street_number.short_name} ${b0xTPortal_street_name.short_name}`;
          b0xTPortal_address_data.config.cityCtrl.value = b0xTPortal_city.long_name;
          b0xTPortal_address_data.config.stateCtrl.value = b0xTPortal_state.short_name;
          b0xTPortal_address_data.config.postalCtrl.value = b0xTPortal_postal.short_name;

          //check if the address is rooftop
          let b0xTPortal_verified = b0xTPortal_place.types.includes('premise') || b0xTPortal_place.geometry.location_type == 'ROOFTOP' || b0xTPortal_postal_suffix.short_name.length;

          b0xTPortal_verified = b0xTPortal_verified ? 1 : 0;
          b0xTPortal_address_data.b0xTPortal_refresh_google_verification(b0xTPortal_verified);
     };

     this._b0xTPortal_find_address_component = function(b0xTPortal_address_array, b0xTPortal_search, b0xTPortal_arg_legacy) {
          for( let i = 0; i < b0xTPortal_address_array.length; i++ ) {
               if ( b0xTPortal_address_array[i].types[0] == b0xTPortal_search ) {
                    return b0xTPortal_address_array[i];
               }
          }
          if(b0xTPortal_arg_legacy) {
               return { long_name: '', short_name: '', types: [ b0xTPortal_search ] };
          }
          return { longText: '', shortText: '', types: [ b0xTPortal_search ] };
     };

     this.b0xTPortal_refresh_google_verification = function(b0xTPortal_arg_code) {
          //sanity check
          if(!b0xTPortal_arg_code) {
               b0xTPortal_arg_code = 0; 
          }

          switch(b0xTPortal_arg_code * 1) { //make sure its number
               case 1:
               case 2:
               case 3:
                    b0xTPortal_address_data.config.validateCtrl.style.color = "#008000";
                    b0xTPortal_address_data.config.validateCtrl.innerHTML = 'VERIFIED';
                    break;
               default:
                    b0xTPortal_address_data.config.validateCtrl.style.color = "#f30c0c";
                    b0xTPortal_address_data.config.validateCtrl.innerHTML = 'NOT VERIFIED';
                    break;
          }

          b0xTPortal_address_data.validated = String(b0xTPortal_arg_code);
     };

     this._b0xTPortal_address_changed = function(b0xTPortal_arg_legacy) {
          let b0xTPortal_the_work = function() {
               if(b0xTPortal_address_data.validated * 1 == 0) {} else {
                    b0xTPortal_address_data.b0xTPortal_refresh_google_verification(0);
               }
          }

          if(b0xTPortal_arg_legacy) {
               b0xTPortal_the_work();
               return;
          }

          clearTimeout(b0xTPortal_address_data.changeTimeout);
          b0xTPortal_address_data.changeTimeout = setTimeout(function() {
               b0xTPortal_the_work();  
          }, 500);
     };

     this._b0xTPortal_set_defaults = function() {
          if ( !b0xTPortal_address_data.config.addressCtrl   ) b0xTPortal_address_data.config.addressCtrl   = b0xTPortal_address_data._b0xTPortal_create_input_text_obj();
          if ( !b0xTPortal_address_data.config.cityCtrl      ) b0xTPortal_address_data.config.cityCtrl      = b0xTPortal_address_data._b0xTPortal_create_input_text_obj();
          if ( !b0xTPortal_address_data.config.stateCtrl     ) b0xTPortal_address_data.config.stateCtrl     = b0xTPortal_address_data._b0xTPortal_create_input_text_obj();
          if ( !b0xTPortal_address_data.config.postalCtrl    ) b0xTPortal_address_data.config.postalCtrl    = b0xTPortal_address_data._b0xTPortal_create_input_text_obj();

          if (b0xTPortal_address_data.config.status) {
               b0xTPortal_address_data.validated = b0xTPortal_address_data.config.status;
          }

          if(b0xTPortal_address_data.config.validateCtrl) {
               b0xTPortal_address_data.b0xTPortal_refresh_google_verification(b0xTPortal_address_data.validated);
          }

          if((typeof(b0xTPortal_pop_up_dialog) === "function")) {
               var config = new Object();
               config.binder = b0xTPortal_address_data.config.addressCtrl;
               b0xTPortal_address_data.dBox = new b0xTPortal_pop_up_dialog(config);
          }
     };

     this._b0xTPortal_create_input_text_obj = function() {
        let b0xTPortal_input = document.createElement('INPUT');
        b0xTPortal_input.setAttribute('type', 'text');
        return b0xTPortal_input;
     };

     this._b0xTPortal_set_defaults();
     this._b0xTPortal_init();
     return this;
}

