<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * When populating this file, consider the following flow
 * of control:
 *
 * - This method should be static
 * - Check if the $_REQUEST content actually is the plugin name
 * - Run an admin referrer check to make sure it goes through authentication
 * - Verify the output of $_GET makes sense
 * - Repeat with other user roles. Best directly by using the links/query string parameters.
 * - Repeat things for multisite. Once for a single site in the network, once sitewide.
 *
 * @link       https://t.me/naumov_top
 * @since      1.0.0
 * @package    BotSubmit
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

/**
 * Delete all plugin options from the database
 */
delete_option( 'botsubmit_api_key' );
delete_option( 'botsubmit_global_log' );
delete_option( 'botsubmit_send_types' );
delete_option( 'botsubmit_send_update' );
delete_option( 'botsubmit_services' );
delete_option( 'botsubmit_api_keys' );
delete_option( 'botsubmit_service_params' );

/**
 * For multisite installations, delete options from all sites
 */
if ( is_multisite() ) {
	global $wpdb;
	
	// Get all blog IDs
	// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Required for multisite uninstall
	$botsubmit_blog_ids = $wpdb->get_col( "SELECT blog_id FROM {$wpdb->blogs}" );
	
	foreach ( $botsubmit_blog_ids as $blog_id ) {
		switch_to_blog( $blog_id );
		
		// Delete options for each site
		delete_option( 'botsubmit_api_key' );
		delete_option( 'botsubmit_global_log' );
		delete_option( 'botsubmit_send_types' );
		delete_option( 'botsubmit_send_update' );
		delete_option( 'botsubmit_services' );
		delete_option( 'botsubmit_api_keys' );
		delete_option( 'botsubmit_service_params' );
		
		// Delete post meta for this site
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Required for bulk delete on uninstall
		$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->postmeta} WHERE meta_key = %s", '_botsubmit_log' ) );
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Required for bulk delete on uninstall
		$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->postmeta} WHERE meta_key = %s", '_botsubmit_send_on_publish' ) );
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Required for bulk delete on uninstall
		$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->postmeta} WHERE meta_key = %s", '_botsubmit_send_on_update' ) );
		
		restore_current_blog();
	}
} else {
	// Delete post meta for single site installation
	global $wpdb;
	// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Required for bulk delete on uninstall
	$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->postmeta} WHERE meta_key = %s", '_botsubmit_log' ) );
	// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Required for bulk delete on uninstall
	$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->postmeta} WHERE meta_key = %s", '_botsubmit_send_on_publish' ) );
	// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Required for bulk delete on uninstall
	$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->postmeta} WHERE meta_key = %s", '_botsubmit_send_on_update' ) );
}

/**
 * Clear any cached data that may have been stored
 */
wp_cache_flush();

/**
 * Optional: Delete any transients used by the plugin
 * (currently the plugin doesn't use transients, but this is here for future use)
 */
// delete_transient( 'botsubmit_some_transient' );

/**
 * Optional: Log the uninstallation
 * Uncomment if you want to track when the plugin is uninstalled
 */
// error_log( 'BotSubmit plugin uninstalled at ' . current_time( 'mysql' ) );
