<?php

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

function chatbot_remove_messages_table() {
    global $wpdb;
    
    // Table name with prefix (matching Botami_Chat_Messages class)
    $table_name = $wpdb->prefix . 'botamichat_messages';
    
    // phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery
    // phpcs:disable WordPress.DB.DirectDatabaseQuery.NoCaching
    // phpcs:disable WordPress.DB.DirectDatabaseQuery.SchemaChange
    
    $table_exists = $wpdb->get_var(
        $wpdb->prepare(
            "SHOW TABLES LIKE %s",
            $table_name
        )
    );
    
    if ($table_exists) {
        // Drop the table and its data
        $wpdb->query(
            "DROP TABLE IF EXISTS " . esc_sql($table_name)
        );
    }
    // phpcs:enable WordPress.DB.DirectDatabaseQuery.DirectQuery
    // phpcs:enable WordPress.DB.DirectDatabaseQuery.NoCaching
    // phpcs:enable WordPress.DB.DirectDatabaseQuery.SchemaChange
}

// Remove the messages table
chatbot_remove_messages_table();

function chatbot_remove_leads_table() {
    global $wpdb;
    
    $table_name = $wpdb->prefix . 'botami_chatbot_leads';
    
    // phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery
    // phpcs:disable WordPress.DB.DirectDatabaseQuery.NoCaching
    // phpcs:disable WordPress.DB.DirectDatabaseQuery.SchemaChange
    
    $table_exists = $wpdb->get_var(
        $wpdb->prepare(
            "SHOW TABLES LIKE %s",
            $table_name
        )
    );
    
    if ($table_exists) {
        $wpdb->query(
            "DROP TABLE IF EXISTS " . esc_sql($table_name)
        );
    }
    
    // phpcs:enable WordPress.DB.DirectDatabaseQuery.DirectQuery
    // phpcs:enable WordPress.DB.DirectDatabaseQuery.NoCaching
    // phpcs:enable WordPress.DB.DirectDatabaseQuery.SchemaChange
}

chatbot_remove_leads_table();

$options_to_delete = array(
    // API and authentication
    'botami_api_key',
    'botami_plan',
    'botami_exceed_limit',
    
    // URL and content management
    'botami_excluded_urls',
    'botami_knowledge_urls',
    'botami_knowledge_document',
    
    // UI appearance options
    'botami_bot_image_url',
    'botami_bot_image_id',
    'botami_primary_color',
    'botami_secondary_color',
    
    // Text configurations
    'botami_welcome_message', 
    'botami_heading_text',
    'botami_online_status_text',
    'botami_reload_text',
    'botami_placeholder_text',
    'botami_default_message',
    
    // Feature toggles
    'botami_welcome_message_enabled',
    'botami_is_active',
    'botami_should_reload',
    
    // Quick replies configuration
    'botami_quick_replies',
    
    // Lead generation options
    'botami_lead_gen_enabled',
    'botami_lead_gen_intro_message',
    'botami_lead_gen_consentment',
    'botami_lead_gen_name_placeholder',
    'botami_lead_gen_email_placeholder',
    'botami_lead_gen_field_placeholder',
    'botami_lead_gen_button_text',
    'botami_lead_gen_quick_reply',
    'botami_lead_gen_thank_you',
    'botami_lead_email_enabled',
    
    'botami_total_conversations',
    'botami_total_messages',
    'botami_total_leads',
    'botami_token_usage',
    'botami_token_limit',

    'botami_knowledge_file',

    'botami_cache_buster',
    'botami_show_powered_by',
    'botami_powered_by_popup_shown',

    'botami_input_language',
    'botami_enabled_languages',
    'botami_placeholder_text_translations',
    'botami_default_message_translations',
    'botami_reload_text_translations',
    'botami_welcome_message_translations',
);

// Clean up all plugin options
foreach ($options_to_delete as $option) {
    delete_option($option);
    // Also clean up any potential site options in multisite
    if (is_multisite()) {
        delete_site_option($option);
    }
}

// Clean up uploaded bot image if it exists
$bot_image_id = get_option('botami_bot_image_id');
if ($bot_image_id) {
    wp_delete_attachment($bot_image_id, true);
    delete_option('botami_bot_image_id');
}

// Flush rewrite rules to clean up any potential URL rules
flush_rewrite_rules();