<?php
if (!defined('ABSPATH')) exit;
?>
<div id="chatbot-container-botami" style="position: fixed !important; z-index: 2147483647 !important;">
    <div id="chatbot-widget-botami">
        <!-- En-tête du chatbot -->
        <div id="chatbot-header-botami">
            <div style="display: flex !important; align-items: center !important;">
                <?php
                echo wp_kses( $bot_image_html, array(
                    'img' => array(
                        'src'      => true,
                        'alt'      => true,
                        'class'    => true,
                        'style'    => true,
                        'width'    => true,
                        'height'   => true,
                        'loading'  => true,
                        'decoding' => true,
                    ),
                ) );
                ?>
                <div style="margin-left: 1rem !important; margin-right: 1rem !important;">
                    <h4 style="font-weight: 700 !important; margin-bottom: 0 !important; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif !important; font-size: 14px !important; color: white !important; line-height: 1.2 !important; margin: 0 !important; padding: 0 !important; text-shadow: none !important;"><?php echo esc_attr(get_option('botami_heading_text', Botami_Language_Manager::get_text('greeting'))); ?></h4>
                    <div style="display: flex !important; align-items: center !important;">
                        <span class="online-dot"></span>
                        <p style="margin-bottom: 0 !important; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif !important; font-size: 13px !important; color: rgba(255, 255, 255, 0.9) !important; line-height: 1.5 !important; margin: 0 !important; padding: 0 !important; font-weight: 500 !important;"><?php echo esc_attr(get_option('botami_online_status_text', Botami_Language_Manager::get_text('online_status'))); ?></p>
                    </div>
                </div>
            </div>
            <svg xmlns="http://www.w3.org/2000/svg" id="chatbot-close" width="34" height="34" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <line x1="18" y1="6" x2="6" y2="18"></line>
                <line x1="6" y1="6" x2="18" y2="18"></line>
            </svg>
        </div>

        <div class="div-btn-refresh">
            <button id="refreshbtn" class="btn-refresh"></button>
        </div>

        <!-- Zone de messages -->
        <div id="chatbot-messages"></div>

        <!-- Input pour taper le message -->
        <div class="chat-bot-textearea">
            <input id="chatbot-input" type="text" placeholder="">
            <button id="chatbot-send">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="white" width="18px" height="18px">
                    <path d="M2.01 21L23 12 2.01 3v7l15 2-15 2z" />
                </svg>
            </button>
        </div>

        <!-- Powered by en bas -->
        <div id="chatbot-powered-by">
            <a href="https://www.botami.ai" target="_blank">
                <img src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'assets/img/bot_image.jpeg'); ?>" alt="Botami" class="powered-by-logo">
                <span><?php echo esc_textarea(Botami_Language_Manager::get_text('powered_by')); ?></span>
            </a>
        </div>
    </div>
</div>

<?php if (esc_attr(get_option('botami_welcome_message_enabled', '1')) === '1') { ?>
    <span id="champ_start_mesage">
        <span id="welcome-message-text"></span>
        <span id="champ_start_mesage_btn_close">x</span>
    </span>
<?php } ?>

<button id="chatbot-open-botami" style="border: 0 !important; padding: 0.5rem !important; margin-bottom: 1rem !important; font-size: 2rem !important; line-height: 1 !important;">
    <?php
    echo wp_kses( $bot_image_small_html, array(
        'img' => array(
            'src'      => true,
            'alt'      => true,
            'class'    => true,
            'style'    => true,
            'width'    => true,
            'height'   => true,
            'loading'  => true,
            'decoding' => true,
        ),
    ) );
    ?>
</button>

<?php
// Add dynamic CSS using wp_add_inline_style
$dynamic_css = "
    :root {
        /* Couleurs dynamiques PHP */
        --chatbot-primary: " . esc_attr($primary_color) . ";
        --chatbot-secondary: " . esc_attr($secondary_color) . ";
    }

    /* Header modernisé avec couleurs PHP */
    #chatbot-header-botami {
        background: linear-gradient(135deg, " . esc_attr($primary_color) . " 0%, " . esc_attr($secondary_color) . " 100%) !important;
    }

    /* Bouton submit lead avec couleurs PHP */
    .btn_submit_lead {
        background: linear-gradient(135deg, " . esc_attr($primary_color) . " 0%, " . esc_attr($secondary_color) . " 100%) !important;
    }

    #chatbot-messages::-webkit-scrollbar-thumb:hover {
        background: var(--chatbot-on-surface-variant);
    }

    /* Messages utilisateur avec couleurs PHP */
    .message.user-message {
        background: linear-gradient(135deg, " . esc_attr($primary_color) . " 0%, " . esc_attr($secondary_color) . " 100%) !important;
    }

    /* Bouton send avec couleurs PHP */
    #chatbot-send {
        background: linear-gradient(135deg, " . esc_attr($primary_color) . " 0%, " . esc_attr($secondary_color) . " 100%) !important;
    }

    #chatbot-send:hover {
        transform: translateY(-2px) scale(1.05) !important;
        box-shadow: var(--shadow-lg) !important;
        background: linear-gradient(135deg, " . esc_attr($primary_color) . " 0%, " . esc_attr($secondary_color) . " 100%) !important;
    }

    #chatbot-send:active {
        transform: translateY(0) scale(1) !important;
    }

    /* Bouton refresh avec couleurs PHP */
    .btn-refresh {
        background: linear-gradient(135deg, " . esc_attr($primary_color) . " 0%, " . esc_attr($secondary_color) . " 100%) !important;
    }

    .btn-refresh:hover {
        transform: translateY(-1px) !important;
        box-shadow: var(--shadow-md) !important;
    }

    /* Responsive design modernisé */
    @media (max-width: 768px) {
        #chatbot-container-botami {
            position: fixed !important;
            bottom: 0px !important;
            right: 0px !important;
            left: 0px !important;
        }

        @keyframes slideUp {
            0% {
                transform: translateY(100%);
            }
            100% {
                transform: translateY(0);
            }
        }
    }

    .question-option-btn {
        border: 2px solid " . esc_attr($primary_color) . ";
    }

    .question-option-btn:hover {
        background: linear-gradient(135deg, " . esc_attr($primary_color) . " 0%, " . esc_attr($secondary_color) . " 100%) !important;
        border-color: " . esc_attr($primary_color) . ";
        box-shadow: 0 6px 12px " . esc_attr($primary_color) . ";
    }

    .message.user-message {
        background: linear-gradient(135deg, " . esc_attr($primary_color) . " 0%, " . esc_attr($secondary_color) . " 100%);
    }
";

// Add the dynamic CSS to the chatbot style handle
wp_add_inline_style('botami-style', $dynamic_css);
?>