<?php
/*
Plugin Name: AI Chatbot by Botami – WordPress AI Chatbot for Support, Sales & Lead Generation
Description: Boost conversions and improve customer support with an intelligent AI chatbot for WordPress
Version: 1.9
Author: Botami
Author URI: https://botami.ai
License: GPL v2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
*/

if (!defined('ABSPATH')) {
    exit;
}

if (!defined('BOTAMI_VERSION')) {
    define('BOTAMI_VERSION', '1.9');
}

// Define other useful constants
if (!defined('BOTAMI_PLUGIN_PATH')) {
    define('BOTAMI_PLUGIN_PATH', plugin_dir_path(__FILE__));
}

if (!defined('BOTAMI_PLUGIN_URL')) {
    define('BOTAMI_PLUGIN_URL', plugin_dir_url(__FILE__));
}

require_once BOTAMI_PLUGIN_PATH . 'includes/class-main.php';
require_once BOTAMI_PLUGIN_PATH . 'includes/class-plugin-activator.php';
require_once BOTAMI_PLUGIN_PATH . 'includes/class-plugin-deactivator.php';

function botami_add_settings_link($links) {
    $settings_link = '<a href="admin.php?page=botami-settings">Settings</a>';
    array_unshift($links, $settings_link);
    return $links;
}
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'botami_add_settings_link');

register_activation_hook(__FILE__, ['Botami_Activator', 'activate']);
register_deactivation_hook(__FILE__, ['Botami_Deactivator', 'deactivate']);

function botami_run() {
    $plugin = new Botami_Chatbot();
}
botami_run();

