<?php
if (!defined('ABSPATH')) exit;
class Botami_Widget {
    public static function add_to_footer() {
        if (!Botami_Url_Checker::is_url_excluded()) {
            wp_enqueue_style('botami-style', BOTAMI_PLUGIN_URL . 'assets/css/chatbot.css', array(), BOTAMI_VERSION);
            // Récupérer l'URL et l'ID de l'image du bot
            $bot_image_url = esc_attr(get_option('botami_bot_image_url', plugins_url('/assets/img/bot_logo_3.png', plugin_dir_path(__FILE__))));
            $bot_image_id = get_option('botami_bot_image_id');
            
            // Récupérer les couleurs
            $primary_color_raw = get_option('botami_primary_color', '#673DE6');
            $primary_color = sanitize_hex_color( $primary_color_raw ) ?: '#673DE6';
            $secondary_color_raw = get_option('botami_secondary_color', '#673DE6');
            $secondary_color = sanitize_hex_color( $secondary_color_raw ) ?: '#673DE6';
    
            // Image principale du bot
            $bot_image_html = ($bot_image_id && $bot_image_id !== '') ? 
                wp_get_attachment_image($bot_image_id, 'thumbnail', false, array(
                    'class' => 'rounded-circle',
                    'style' => 'width: 50px; height: 50px;',
                    'alt' => esc_attr__('Bot Avatar', 'botami-chatbot')
                )) : 
                wp_kses(sprintf(
                    '<img src="%s" alt="%s" class="rounded-circle" style="width: 50px; height: 50px;">',
                    esc_url($bot_image_url),
                    esc_attr__('Bot Image', 'botami-chatbot')
                ), array(
                    'img' => array(
                        'src' => array(),
                        'alt' => array(),
                        'class' => array(),
                        'style' => array()
                    )
                ));
    
            // Image miniature du bot
            $bot_image_small_html = ($bot_image_id && $bot_image_id !== '') ? 
                wp_get_attachment_image($bot_image_id, 'thumbnail', false, array(
                    'class' => 'rounded-circle',
                    'style' => 'width:50px; height: 50px;',
                    'alt' => esc_attr__('Bot Avatar', 'botami-chatbot')
                )) : 
                wp_kses(sprintf(
                    '<img src="%s" alt="%s" class="rounded-circle" style="width:50px; height: 50px;">',
                    esc_url($bot_image_url),
                    esc_attr__('Bot Image', 'botami-chatbot')
                ), array(
                    'img' => array(
                        'src' => array(),
                        'alt' => array(),
                        'class' => array(),
                        'style' => array()
                    )
                ));
                
            include(BOTAMI_PLUGIN_PATH . 'templates/widget-template.php');
        }
    }
}